/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff;

import org.hipparchus.linear.Array2DRowRealMatrix;
import org.hipparchus.ode.EquationsMapper;
import org.hipparchus.ode.ODEStateAndDerivative;
import org.hipparchus.ode.sampling.AbstractODEStateInterpolator;
import org.hipparchus.util.FastMath;

class AdamsStateInterpolator
extends AbstractODEStateInterpolator {
    private static final long serialVersionUID = 20160402L;
    private double scalingH;
    private final ODEStateAndDerivative reference;
    private double[] scaled;
    private Array2DRowRealMatrix nordsieck;

    AdamsStateInterpolator(double stepSize, ODEStateAndDerivative reference, double[] scaled, Array2DRowRealMatrix nordsieck, boolean isForward, ODEStateAndDerivative globalPreviousState, ODEStateAndDerivative globalCurrentState, EquationsMapper equationsMapper) {
        this(stepSize, reference, scaled, nordsieck, isForward, globalPreviousState, globalCurrentState, globalPreviousState, globalCurrentState, equationsMapper);
    }

    private AdamsStateInterpolator(double stepSize, ODEStateAndDerivative reference, double[] scaled, Array2DRowRealMatrix nordsieck, boolean isForward, ODEStateAndDerivative globalPreviousState, ODEStateAndDerivative globalCurrentState, ODEStateAndDerivative softPreviousState, ODEStateAndDerivative softCurrentState, EquationsMapper equationsMapper) {
        super(isForward, globalPreviousState, globalCurrentState, softPreviousState, softCurrentState, equationsMapper);
        this.scalingH = stepSize;
        this.reference = reference;
        this.scaled = (double[])scaled.clone();
        this.nordsieck = new Array2DRowRealMatrix(nordsieck.getData(), false);
    }

    @Override
    protected AdamsStateInterpolator create(boolean newForward, ODEStateAndDerivative newGlobalPreviousState, ODEStateAndDerivative newGlobalCurrentState, ODEStateAndDerivative newSoftPreviousState, ODEStateAndDerivative newSoftCurrentState, EquationsMapper newMapper) {
        return new AdamsStateInterpolator(this.scalingH, this.reference, this.scaled, this.nordsieck, newForward, newGlobalPreviousState, newGlobalCurrentState, newSoftPreviousState, newSoftCurrentState, newMapper);
    }

    public double[] getScaled() {
        return (double[])this.scaled.clone();
    }

    public Array2DRowRealMatrix getNordsieck() {
        return this.nordsieck;
    }

    @Override
    protected ODEStateAndDerivative computeInterpolatedStateAndDerivatives(EquationsMapper equationsMapper, double time, double theta, double thetaH, double oneMinusThetaH) {
        return AdamsStateInterpolator.taylor(equationsMapper, this.reference, time, this.scalingH, this.scaled, this.nordsieck);
    }

    public static ODEStateAndDerivative taylor(EquationsMapper equationsMapper, ODEStateAndDerivative reference, double time, double stepSize, double[] scaled, Array2DRowRealMatrix nordsieck) {
        double x = time - reference.getTime();
        double normalizedAbscissa = x / stepSize;
        double[] stateVariation = new double[scaled.length];
        double[] estimatedDerivatives = new double[scaled.length];
        double[][] nData = nordsieck.getDataRef();
        for (int i = nData.length - 1; i >= 0; --i) {
            int order = i + 2;
            double[] nDataI = nData[i];
            double power = FastMath.pow((double)normalizedAbscissa, (int)order);
            for (int j = 0; j < nDataI.length; ++j) {
                double d = nDataI[j] * power;
                stateVariation[j] = stateVariation[j] + d;
                estimatedDerivatives[j] = estimatedDerivatives[j] + d * (double)order;
            }
        }
        double[] estimatedState = reference.getCompleteState();
        for (int j = 0; j < stateVariation.length; ++j) {
            stateVariation[j] = stateVariation[j] + scaled[j] * normalizedAbscissa;
            estimatedState[j] = estimatedState[j] + stateVariation[j];
            estimatedDerivatives[j] = (estimatedDerivatives[j] + scaled[j] * normalizedAbscissa) / x;
        }
        return equationsMapper.mapStateAndDerivative(time, estimatedState, estimatedDerivatives);
    }
}

