/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.integration;

import java.util.List;
import java.util.stream.Collectors;
import org.hipparchus.linear.Array2DRowRealMatrix;
import org.hipparchus.linear.RealMatrix;
import org.orekit.propagation.MatricesHarvester;
import org.orekit.propagation.SpacecraftState;
import org.orekit.utils.ParameterDriversList;

public abstract class AbstractJacobiansMapper
implements MatricesHarvester {
    public static final int STATE_DIMENSION = 6;
    private String name;
    private final ParameterDriversList parameters;

    protected AbstractJacobiansMapper(String name, ParameterDriversList parameters) {
        this.name = name;
        this.parameters = parameters;
    }

    public String getName() {
        return this.name;
    }

    public int getParameters() {
        return this.parameters.getNbParams();
    }

    public int getAdditionalStateDimension() {
        return 6 * (6 + this.parameters.getNbParams());
    }

    @Deprecated
    public void analyticalDerivatives(SpacecraftState s) {
    }

    @Override
    public void setReferenceState(SpacecraftState reference) {
    }

    @Override
    public RealMatrix getStateTransitionMatrix(SpacecraftState s) {
        double[][] dYdY0 = new double[6][6];
        this.getStateJacobian(s, dYdY0);
        return new Array2DRowRealMatrix(dYdY0, false);
    }

    @Override
    public RealMatrix getParametersJacobian(SpacecraftState s) {
        if (this.getParameters() == 0) {
            return null;
        }
        double[][] dYdP = new double[6][this.getParameters()];
        this.getParametersJacobian(s, dYdP);
        return new Array2DRowRealMatrix(dYdP, false);
    }

    @Override
    public List<String> getJacobiansColumnsNames() {
        return this.parameters.getDrivers().stream().map(d -> d.getName()).collect(Collectors.toList());
    }

    public abstract void setInitialJacobians(SpacecraftState var1, double[][] var2, double[][] var3, double[] var4);

    public abstract void getStateJacobian(SpacecraftState var1, double[][] var2);

    public abstract void getParametersJacobian(SpacecraftState var1, double[][] var2);
}

