/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.special.elliptic.jacobi;

import org.hipparchus.special.elliptic.jacobi.CopolarN;
import org.hipparchus.special.elliptic.jacobi.JacobiElliptic;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.SinCos;

class NearZeroParameter
extends JacobiElliptic {
    NearZeroParameter(double m) {
        super(m);
    }

    @Override
    public CopolarN valuesN(double u) {
        SinCos sc = FastMath.sinCos(u);
        double factor = 0.25 * this.getM() * (u - sc.sin() * sc.cos());
        return new CopolarN(sc.sin() - factor * sc.cos(), sc.cos() + factor * sc.sin(), 1.0 - 0.5 * this.getM() * sc.sin() * sc.sin());
    }
}

