/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.special.elliptic.jacobi;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.complex.Complex;
import org.hipparchus.complex.FieldComplex;
import org.hipparchus.special.elliptic.jacobi.BigParameter;
import org.hipparchus.special.elliptic.jacobi.BoundedParameter;
import org.hipparchus.special.elliptic.jacobi.ComplexParameter;
import org.hipparchus.special.elliptic.jacobi.FieldBigParameter;
import org.hipparchus.special.elliptic.jacobi.FieldBoundedParameter;
import org.hipparchus.special.elliptic.jacobi.FieldComplexParameter;
import org.hipparchus.special.elliptic.jacobi.FieldJacobiElliptic;
import org.hipparchus.special.elliptic.jacobi.FieldNearOneParameter;
import org.hipparchus.special.elliptic.jacobi.FieldNearZeroParameter;
import org.hipparchus.special.elliptic.jacobi.FieldNegativeParameter;
import org.hipparchus.special.elliptic.jacobi.JacobiElliptic;
import org.hipparchus.special.elliptic.jacobi.NearOneParameter;
import org.hipparchus.special.elliptic.jacobi.NearZeroParameter;
import org.hipparchus.special.elliptic.jacobi.NegativeParameter;

public class JacobiEllipticBuilder {
    private static final double NEAR_ZERO = 1.0E-9;
    private static final double NEAR_ONE = 0.999999999;

    private JacobiEllipticBuilder() {
    }

    public static JacobiElliptic build(double m) {
        if (m < 0.0) {
            return new NegativeParameter(m);
        }
        if (m > 1.0) {
            return new BigParameter(m);
        }
        if (m < 1.0E-9) {
            return new NearZeroParameter(m);
        }
        if (m > 0.999999999) {
            return new NearOneParameter(m);
        }
        return new BoundedParameter(m);
    }

    public static <T extends CalculusFieldElement<T>> FieldJacobiElliptic<T> build(T m) {
        if (m.getReal() < 0.0) {
            return new FieldNegativeParameter<T>(m);
        }
        if (m.getReal() > 1.0) {
            return new FieldBigParameter<T>(m);
        }
        if (m.getReal() < 1.0E-9) {
            return new FieldNearZeroParameter<T>(m);
        }
        if (m.getReal() > 0.999999999) {
            return new FieldNearOneParameter<T>(m);
        }
        return new FieldBoundedParameter<T>(m);
    }

    public static FieldJacobiElliptic<Complex> build(Complex m) {
        return new ComplexParameter(m);
    }

    public static <T extends CalculusFieldElement<T>> FieldJacobiElliptic<FieldComplex<T>> build(FieldComplex<T> m) {
        return new FieldComplexParameter<T>(m);
    }
}

