/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.special.elliptic.jacobi;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.special.elliptic.jacobi.FieldCopolarC;
import org.hipparchus.special.elliptic.jacobi.FieldCopolarD;
import org.hipparchus.special.elliptic.jacobi.FieldCopolarN;
import org.hipparchus.special.elliptic.jacobi.FieldCopolarS;

public abstract class FieldJacobiElliptic<T extends CalculusFieldElement<T>> {
    private final T m;

    protected FieldJacobiElliptic(T m) {
        this.m = m;
    }

    public T getM() {
        return this.m;
    }

    public abstract FieldCopolarN<T> valuesN(T var1);

    public FieldCopolarN<T> valuesN(double u) {
        return this.valuesN((CalculusFieldElement)this.m.newInstance(u));
    }

    public FieldCopolarS<T> valuesS(T u) {
        return new FieldCopolarS<T>(this.valuesN(u));
    }

    public FieldCopolarS<T> valuesS(double u) {
        return new FieldCopolarS<T>(this.valuesN(u));
    }

    public FieldCopolarC<T> valuesC(T u) {
        return new FieldCopolarC<T>(this.valuesN(u));
    }

    public FieldCopolarC<T> valuesC(double u) {
        return new FieldCopolarC<T>(this.valuesN(u));
    }

    public FieldCopolarD<T> valuesD(T u) {
        return new FieldCopolarD<T>(this.valuesN(u));
    }

    public FieldCopolarD<T> valuesD(double u) {
        return new FieldCopolarD<T>(this.valuesN(u));
    }
}

