/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.special.elliptic.carlson;

import org.hipparchus.special.elliptic.carlson.RealDuplication;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;

class RcRealDuplication
extends RealDuplication {
    static final double S0 = 80080.0;
    static final double S2 = 24024.0;
    static final double S3 = 11440.0;
    static final double S4 = 30030.0;
    static final double S5 = 32760.0;
    static final double S6 = 61215.0;
    static final double S7 = 90090.0;
    static final double DENOMINATOR = 80080.0;

    RcRealDuplication(double x, double y) {
        super(x, y);
    }

    @Override
    protected void initialMeanPoint(double[] va) {
        va[2] = (va[0] + va[1] * 2.0) / 3.0;
    }

    @Override
    protected double convergenceCriterion(double r, double max) {
        return max / FastMath.sqrt(FastMath.sqrt(FastMath.sqrt(r * 3.0)));
    }

    @Override
    protected void update(int m, double[] vaM, double[] sqrtM, double fourM) {
        double lambdaA = sqrtM[0] * sqrtM[1] * 2.0;
        double lambdaB = vaM[1];
        vaM[0] = MathArrays.linearCombination(0.25, vaM[0], 0.25, lambdaA, 0.25, lambdaB);
        vaM[1] = MathArrays.linearCombination(0.25, vaM[1], 0.25, lambdaA, 0.25, lambdaB);
        vaM[2] = MathArrays.linearCombination(0.25, vaM[2], 0.25, lambdaA, 0.25, lambdaB);
    }

    @Override
    protected double evaluate(double[] va0, double aM, double fourM) {
        double s = (va0[1] - va0[2]) / (aM * fourM);
        double poly = ((((((90090.0 * s + 61215.0) * s + 32760.0) * s + 30030.0) * s + 11440.0) * s + 24024.0) * s * s + 80080.0) / 80080.0;
        return poly / FastMath.sqrt(aM);
    }
}

