/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.solvers;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.CalculusFieldUnivariateFunction;
import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.analysis.solvers.AllowedSolution;
import org.hipparchus.analysis.solvers.BracketedUnivariateSolver;
import org.hipparchus.analysis.solvers.BrentSolver;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.NullArgumentException;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;

public class UnivariateSolverUtils {
    private UnivariateSolverUtils() {
    }

    public static double solve(UnivariateFunction function, double x0, double x1) throws MathIllegalArgumentException, NullArgumentException {
        MathUtils.checkNotNull(function, LocalizedCoreFormats.FUNCTION, new Object[0]);
        BrentSolver solver = new BrentSolver();
        return solver.solve(Integer.MAX_VALUE, function, x0, x1);
    }

    public static double solve(UnivariateFunction function, double x0, double x1, double absoluteAccuracy) throws MathIllegalArgumentException, NullArgumentException {
        MathUtils.checkNotNull(function, LocalizedCoreFormats.FUNCTION, new Object[0]);
        BrentSolver solver = new BrentSolver(absoluteAccuracy);
        return solver.solve(Integer.MAX_VALUE, function, x0, x1);
    }

    public static double forceSide(int maxEval, UnivariateFunction f, BracketedUnivariateSolver<UnivariateFunction> bracketing, double baseRoot, double min, double max, AllowedSolution allowedSolution) throws MathIllegalArgumentException {
        if (allowedSolution == AllowedSolution.ANY_SIDE) {
            return baseRoot;
        }
        double step = FastMath.max(bracketing.getAbsoluteAccuracy(), FastMath.abs(baseRoot * bracketing.getRelativeAccuracy()));
        double xLo = FastMath.max(min, baseRoot - step);
        double fLo = f.value(xLo);
        double xHi = FastMath.min(max, baseRoot + step);
        double fHi = f.value(xHi);
        int remainingEval = maxEval - 2;
        while (remainingEval > 0) {
            if (fLo >= 0.0 && fHi <= 0.0 || fLo <= 0.0 && fHi >= 0.0) {
                return bracketing.solve(remainingEval, f, xLo, xHi, baseRoot, allowedSolution);
            }
            boolean changeLo = false;
            boolean changeHi = false;
            if (fLo < fHi) {
                if (fLo >= 0.0) {
                    changeLo = true;
                } else {
                    changeHi = true;
                }
            } else if (fLo > fHi) {
                if (fLo <= 0.0) {
                    changeLo = true;
                } else {
                    changeHi = true;
                }
            } else {
                changeLo = true;
                changeHi = true;
            }
            if (changeLo) {
                xLo = FastMath.max(min, xLo - step);
                fLo = f.value(xLo);
                --remainingEval;
            }
            if (!changeHi) continue;
            xHi = FastMath.min(max, xHi + step);
            fHi = f.value(xHi);
            --remainingEval;
        }
        throw new MathIllegalArgumentException(LocalizedCoreFormats.FAILED_BRACKETING, xLo, xHi, fLo, fHi, maxEval - remainingEval, maxEval, baseRoot, min, max);
    }

    public static double[] bracket(UnivariateFunction function, double initial, double lowerBound, double upperBound) throws MathIllegalArgumentException, NullArgumentException {
        return UnivariateSolverUtils.bracket(function, initial, lowerBound, upperBound, 1.0, 1.0, Integer.MAX_VALUE);
    }

    public static double[] bracket(UnivariateFunction function, double initial, double lowerBound, double upperBound, int maximumIterations) throws MathIllegalArgumentException, NullArgumentException {
        return UnivariateSolverUtils.bracket(function, initial, lowerBound, upperBound, 1.0, 1.0, maximumIterations);
    }

    public static double[] bracket(UnivariateFunction function, double initial, double lowerBound, double upperBound, double q, double r, int maximumIterations) throws MathIllegalArgumentException {
        MathUtils.checkNotNull(function, LocalizedCoreFormats.FUNCTION, new Object[0]);
        if (q <= 0.0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_SMALL_BOUND_EXCLUDED, q, 0);
        }
        if (maximumIterations <= 0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.INVALID_MAX_ITERATIONS, maximumIterations);
        }
        UnivariateSolverUtils.verifySequence(lowerBound, initial, upperBound);
        double a = initial;
        double b = initial;
        double fa = Double.NaN;
        double fb = Double.NaN;
        double delta = 0.0;
        for (int numIterations = 0; numIterations < maximumIterations && (a > lowerBound || b < upperBound); ++numIterations) {
            double previousA = a;
            double previousFa = fa;
            double previousB = b;
            double previousFb = fb;
            delta = r * delta + q;
            a = FastMath.max(initial - delta, lowerBound);
            b = FastMath.min(initial + delta, upperBound);
            fa = function.value(a);
            fb = function.value(b);
            if (numIterations == 0) {
                if (!(fa * fb <= 0.0)) continue;
                return new double[]{a, b};
            }
            if (fa * previousFa <= 0.0) {
                return new double[]{a, previousA};
            }
            if (!(fb * previousFb <= 0.0)) continue;
            return new double[]{previousB, b};
        }
        throw new MathIllegalArgumentException(LocalizedCoreFormats.NOT_BRACKETING_INTERVAL, a, b, fa, fb);
    }

    public static <T extends CalculusFieldElement<T>> T[] bracket(CalculusFieldUnivariateFunction<T> function, T initial, T lowerBound, T upperBound) throws MathIllegalArgumentException, NullArgumentException {
        return UnivariateSolverUtils.bracket(function, initial, lowerBound, upperBound, (CalculusFieldElement)((CalculusFieldElement)initial.getField().getOne()), (CalculusFieldElement)((CalculusFieldElement)initial.getField().getOne()), (int)Integer.MAX_VALUE);
    }

    public static <T extends CalculusFieldElement<T>> T[] bracket(CalculusFieldUnivariateFunction<T> function, T initial, T lowerBound, T upperBound, int maximumIterations) throws MathIllegalArgumentException, NullArgumentException {
        return UnivariateSolverUtils.bracket(function, initial, lowerBound, upperBound, (CalculusFieldElement)((CalculusFieldElement)initial.getField().getOne()), (CalculusFieldElement)((CalculusFieldElement)initial.getField().getOne()), (int)maximumIterations);
    }

    public static <T extends CalculusFieldElement<T>> T[] bracket(CalculusFieldUnivariateFunction<T> function, T initial, T lowerBound, T upperBound, T q, T r, int maximumIterations) throws MathIllegalArgumentException {
        MathUtils.checkNotNull(function, LocalizedCoreFormats.FUNCTION, new Object[0]);
        if (q.getReal() <= 0.0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_SMALL_BOUND_EXCLUDED, q, 0);
        }
        if (maximumIterations <= 0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.INVALID_MAX_ITERATIONS, maximumIterations);
        }
        UnivariateSolverUtils.verifySequence(lowerBound.getReal(), initial.getReal(), upperBound.getReal());
        CalculusFieldElement a = initial;
        CalculusFieldElement b = initial;
        FieldElement<FieldElement> fa = null;
        FieldElement<FieldElement> fb = null;
        CalculusFieldElement delta = (CalculusFieldElement)initial.getField().getZero();
        for (int numIterations = 0; numIterations < maximumIterations && (a.getReal() > lowerBound.getReal() || b.getReal() < upperBound.getReal()); ++numIterations) {
            CalculusFieldElement previousA = a;
            FieldElement previousFa = fa;
            CalculusFieldElement previousB = b;
            FieldElement previousFb = fb;
            delta = r.multiply((CalculusFieldElement)delta).add(q);
            a = UnivariateSolverUtils.max(initial.subtract((CalculusFieldElement)delta), lowerBound);
            b = UnivariateSolverUtils.min(initial.add((CalculusFieldElement)delta), upperBound);
            fa = function.value(a);
            fb = function.value(b);
            if (numIterations == 0) {
                if (!(((CalculusFieldElement)fa.multiply(fb)).getReal() <= 0.0)) continue;
                CalculusFieldElement[] interval = (CalculusFieldElement[])MathArrays.buildArray(initial.getField(), (int)2);
                interval[0] = a;
                interval[1] = b;
                return interval;
            }
            if (((CalculusFieldElement)fa.multiply(previousFa)).getReal() <= 0.0) {
                CalculusFieldElement[] interval = (CalculusFieldElement[])MathArrays.buildArray(initial.getField(), (int)2);
                interval[0] = a;
                interval[1] = previousA;
                return interval;
            }
            if (!(((CalculusFieldElement)fb.multiply(previousFb)).getReal() <= 0.0)) continue;
            CalculusFieldElement[] interval = (CalculusFieldElement[])MathArrays.buildArray(initial.getField(), (int)2);
            interval[0] = previousB;
            interval[1] = b;
            return interval;
        }
        throw new MathIllegalArgumentException(LocalizedCoreFormats.NOT_BRACKETING_INTERVAL, a.getReal(), b.getReal(), fa.getReal(), fb.getReal());
    }

    private static <T extends CalculusFieldElement<T>> T max(T a, T b) {
        return a.subtract(b).getReal() <= 0.0 ? b : a;
    }

    private static <T extends CalculusFieldElement<T>> T min(T a, T b) {
        return a.subtract(b).getReal() <= 0.0 ? a : b;
    }

    public static double midpoint(double a, double b) {
        return (a + b) * 0.5;
    }

    public static boolean isBracketing(UnivariateFunction function, double lower, double upper) throws NullArgumentException {
        MathUtils.checkNotNull(function, LocalizedCoreFormats.FUNCTION, new Object[0]);
        double fLo = function.value(lower);
        double fHi = function.value(upper);
        return fLo >= 0.0 && fHi <= 0.0 || fLo <= 0.0 && fHi >= 0.0;
    }

    public static boolean isSequence(double start, double mid, double end) {
        return start < mid && mid < end;
    }

    public static void verifyInterval(double lower, double upper) throws MathIllegalArgumentException {
        if (lower >= upper) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.ENDPOINTS_NOT_AN_INTERVAL, lower, upper, false);
        }
    }

    public static void verifySequence(double lower, double initial, double upper) throws MathIllegalArgumentException {
        UnivariateSolverUtils.verifyInterval(lower, initial);
        UnivariateSolverUtils.verifyInterval(initial, upper);
    }

    public static void verifyBracketing(UnivariateFunction function, double lower, double upper) throws MathIllegalArgumentException, NullArgumentException {
        MathUtils.checkNotNull(function, LocalizedCoreFormats.FUNCTION, new Object[0]);
        UnivariateSolverUtils.verifyInterval(lower, upper);
        if (!UnivariateSolverUtils.isBracketing(function, lower, upper)) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NOT_BRACKETING_INTERVAL, lower, upper, function.value(lower), function.value(upper));
        }
    }
}

