/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.integration.gauss;

import org.hipparchus.analysis.integration.gauss.ConvertingRuleFactory;
import org.hipparchus.analysis.integration.gauss.FieldLegendreRuleFactory;
import org.hipparchus.analysis.integration.gauss.GaussIntegrator;
import org.hipparchus.analysis.integration.gauss.HermiteRuleFactory;
import org.hipparchus.analysis.integration.gauss.LaguerreRuleFactory;
import org.hipparchus.analysis.integration.gauss.LegendreRuleFactory;
import org.hipparchus.analysis.integration.gauss.RuleFactory;
import org.hipparchus.analysis.integration.gauss.SymmetricGaussIntegrator;
import org.hipparchus.dfp.Dfp;
import org.hipparchus.dfp.DfpField;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.Pair;

public class GaussIntegratorFactory {
    public static final int DEFAULT_DECIMAL_DIGITS = 40;
    private final RuleFactory legendre = new LegendreRuleFactory();
    private final RuleFactory legendreHighPrecision;
    private final RuleFactory hermite;
    private final RuleFactory laguerre;

    public GaussIntegratorFactory() {
        this(40);
    }

    public GaussIntegratorFactory(int decimalDigits) {
        this.legendreHighPrecision = new ConvertingRuleFactory<Dfp>(new FieldLegendreRuleFactory<Dfp>(new DfpField(decimalDigits)));
        this.hermite = new HermiteRuleFactory();
        this.laguerre = new LaguerreRuleFactory();
    }

    public GaussIntegrator laguerre(int numberOfPoints) {
        return new GaussIntegrator(this.laguerre.getRule(numberOfPoints));
    }

    public GaussIntegrator legendre(int numberOfPoints) {
        return new GaussIntegrator(this.legendre.getRule(numberOfPoints));
    }

    public GaussIntegrator legendre(int numberOfPoints, double lowerBound, double upperBound) throws MathIllegalArgumentException {
        return new GaussIntegrator(this.transform(this.legendre.getRule(numberOfPoints), lowerBound, upperBound));
    }

    public GaussIntegrator legendreHighPrecision(int numberOfPoints) throws MathIllegalArgumentException {
        return new GaussIntegrator(this.legendreHighPrecision.getRule(numberOfPoints));
    }

    public GaussIntegrator legendreHighPrecision(int numberOfPoints, double lowerBound, double upperBound) throws MathIllegalArgumentException {
        return new GaussIntegrator(this.transform(this.legendreHighPrecision.getRule(numberOfPoints), lowerBound, upperBound));
    }

    public SymmetricGaussIntegrator hermite(int numberOfPoints) {
        return new SymmetricGaussIntegrator(this.hermite.getRule(numberOfPoints));
    }

    private Pair<double[], double[]> transform(Pair<double[], double[]> rule, double a, double b) {
        double[] points = rule.getFirst();
        double[] weights = rule.getSecond();
        double scale = (b - a) / 2.0;
        double shift = a + scale;
        int i = 0;
        while (i < points.length) {
            points[i] = points[i] * scale + shift;
            int n = i++;
            weights[n] = weights[n] * scale;
        }
        return new Pair<double[], double[]>(points, weights);
    }
}

