/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.integration.gauss;

import org.hipparchus.FieldElement;
import org.hipparchus.analysis.integration.gauss.AbstractRuleFactory;
import org.hipparchus.analysis.integration.gauss.FieldRuleFactory;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.Pair;

public class ConvertingRuleFactory<T extends FieldElement<T>>
extends AbstractRuleFactory {
    private final FieldRuleFactory<T> fieldFactory;

    public ConvertingRuleFactory(FieldRuleFactory<T> fieldFactory) {
        this.fieldFactory = fieldFactory;
    }

    @Override
    protected Pair<double[], double[]> computeRule(int numberOfPoints) throws MathIllegalArgumentException {
        Pair<T[], T[]> rule = this.fieldFactory.getRule(numberOfPoints);
        FieldElement[] pT = (FieldElement[])rule.getFirst();
        FieldElement[] wT = (FieldElement[])rule.getSecond();
        int len = pT.length;
        double[] pD = new double[len];
        double[] wD = new double[len];
        for (int i = 0; i < len; ++i) {
            pD[i] = pT[i].getReal();
            wD[i] = wT[i].getReal();
        }
        return new Pair<double[], double[]>(pD, wD);
    }
}

