/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.differentiation;

import java.util.HashMap;
import java.util.Map;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.differentiation.FDSFactory;
import org.hipparchus.analysis.differentiation.FieldUnivariateDerivative2;

public class FieldUnivariateDerivative2Field<T extends CalculusFieldElement<T>>
implements Field<FieldUnivariateDerivative2<T>> {
    private static final Map<Field<?>, FieldUnivariateDerivative2Field<?>> CACHE = new HashMap();
    private final FieldUnivariateDerivative2<T> zero;
    private final FieldUnivariateDerivative2<T> one;
    private final FDSFactory<T> factory;

    private FieldUnivariateDerivative2Field(Field<T> valueField) {
        this.zero = new FieldUnivariateDerivative2<CalculusFieldElement>((CalculusFieldElement)valueField.getZero(), (CalculusFieldElement)valueField.getZero(), (CalculusFieldElement)valueField.getZero());
        this.one = new FieldUnivariateDerivative2<CalculusFieldElement>((CalculusFieldElement)valueField.getOne(), (CalculusFieldElement)valueField.getZero(), (CalculusFieldElement)valueField.getZero());
        this.factory = new FDSFactory<T>(valueField, 1, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends CalculusFieldElement<T>> FieldUnivariateDerivative2Field<T> getUnivariateDerivative2Field(Field<T> valueField) {
        Map<Field<?>, FieldUnivariateDerivative2Field<?>> map = CACHE;
        synchronized (map) {
            FieldUnivariateDerivative2Field<Object> cached = CACHE.get(valueField);
            if (cached == null) {
                cached = new FieldUnivariateDerivative2Field<T>(valueField);
                CACHE.put(valueField, cached);
            }
            FieldUnivariateDerivative2Field<?> tCached = cached;
            return tCached;
        }
    }

    @Override
    public FieldUnivariateDerivative2<T> getOne() {
        return this.one;
    }

    @Override
    public FieldUnivariateDerivative2<T> getZero() {
        return this.zero;
    }

    FDSFactory<T> getConversionFactory() {
        return this.factory;
    }

    @Override
    public Class<FieldUnivariateDerivative2<T>> getRuntimeClass() {
        return this.zero.getClass();
    }

    public boolean equals(Object other) {
        return this == other;
    }

    public int hashCode() {
        return 1061910846;
    }
}

