/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.differentiation;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.differentiation.DSCompiler;
import org.hipparchus.analysis.differentiation.FieldDerivativeStructure;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.MathArrays;

public class FDSFactory<T extends CalculusFieldElement<T>> {
    private final DSCompiler compiler;
    private final Field<T> valueField;
    private final DerivativeField<T> derivativeField;

    public FDSFactory(Field<T> valueField, int parameters, int order) {
        this.compiler = DSCompiler.getCompiler(parameters, order);
        this.valueField = valueField;
        this.derivativeField = new DerivativeField<CalculusFieldElement>(this.constant((CalculusFieldElement)valueField.getZero()), this.constant((CalculusFieldElement)valueField.getOne()), this.constant((CalculusFieldElement)((CalculusFieldElement)valueField.getZero()).getPi()));
    }

    public Field<T> getValueField() {
        return this.valueField;
    }

    public DerivativeField<T> getDerivativeField() {
        return this.derivativeField;
    }

    public FieldDerivativeStructure<T> constant(double value) {
        return this.constant((CalculusFieldElement)((CalculusFieldElement)this.valueField.getZero()).add(value));
    }

    public FieldDerivativeStructure<T> constant(T value) {
        FieldDerivativeStructure<T> fds = new FieldDerivativeStructure<T>(this);
        fds.setDerivativeComponent(0, value);
        return fds;
    }

    public FieldDerivativeStructure<T> variable(int index, T value) throws MathIllegalArgumentException {
        if (index >= this.getCompiler().getFreeParameters()) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_LARGE_BOUND_EXCLUDED, index, this.getCompiler().getFreeParameters());
        }
        FieldDerivativeStructure<T> fds = new FieldDerivativeStructure<T>(this);
        fds.setDerivativeComponent(0, value);
        if (this.getCompiler().getOrder() > 0) {
            fds.setDerivativeComponent(DSCompiler.getCompiler(index, this.getCompiler().getOrder()).getSize(), (CalculusFieldElement)this.valueField.getOne());
        }
        return fds;
    }

    public FieldDerivativeStructure<T> variable(int index, double value) throws MathIllegalArgumentException {
        if (index >= this.getCompiler().getFreeParameters()) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_LARGE_BOUND_EXCLUDED, index, this.getCompiler().getFreeParameters());
        }
        FieldDerivativeStructure<CalculusFieldElement> fds = new FieldDerivativeStructure<CalculusFieldElement>(this);
        fds.setDerivativeComponent(0, (CalculusFieldElement)((CalculusFieldElement)this.valueField.getZero()).newInstance(value));
        if (this.getCompiler().getOrder() > 0) {
            fds.setDerivativeComponent(DSCompiler.getCompiler(index, this.getCompiler().getOrder()).getSize(), (CalculusFieldElement)this.valueField.getOne());
        }
        return fds;
    }

    @SafeVarargs
    public final FieldDerivativeStructure<T> build(T ... derivatives) throws MathIllegalArgumentException {
        CalculusFieldElement[] data = this.buildArray();
        if (derivatives.length != data.length) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, derivatives.length, data.length);
        }
        System.arraycopy(derivatives, 0, data, 0, data.length);
        return new FieldDerivativeStructure(this, data);
    }

    public FieldDerivativeStructure<T> build(double ... derivatives) throws MathIllegalArgumentException {
        CalculusFieldElement[] data = this.buildArray();
        if (derivatives.length != data.length) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, derivatives.length, data.length);
        }
        for (int i = 0; i < data.length; ++i) {
            data[i] = (CalculusFieldElement)((CalculusFieldElement)this.valueField.getZero()).add(derivatives[i]);
        }
        return new FieldDerivativeStructure(this, data);
    }

    FieldDerivativeStructure<T> build() {
        return new FieldDerivativeStructure(this);
    }

    private T[] buildArray() {
        return (CalculusFieldElement[])MathArrays.buildArray(this.valueField, (int)this.compiler.getSize());
    }

    public DSCompiler getCompiler() {
        return this.compiler;
    }

    void checkCompatibility(FDSFactory<T> factory) throws MathIllegalArgumentException {
        this.compiler.checkCompatibility(factory.compiler);
    }

    public static class DerivativeField<T extends CalculusFieldElement<T>>
    implements Field<FieldDerivativeStructure<T>> {
        private final FieldDerivativeStructure<T> zero;
        private final FieldDerivativeStructure<T> one;
        private final FieldDerivativeStructure<T> pi;

        DerivativeField(FieldDerivativeStructure<T> zero, FieldDerivativeStructure<T> one, FieldDerivativeStructure<T> pi) {
            this.zero = zero;
            this.one = one;
            this.pi = pi;
        }

        @Override
        public FieldDerivativeStructure<T> getZero() {
            return this.zero;
        }

        @Override
        public FieldDerivativeStructure<T> getOne() {
            return this.one;
        }

        public FieldDerivativeStructure<T> getPi() {
            return this.pi;
        }

        @Override
        public Class<FieldDerivativeStructure<T>> getRuntimeClass() {
            return this.zero.getClass();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof DerivativeField) {
                FDSFactory<T> lhsFactory = this.zero.getFactory();
                FDSFactory<T> rhsFactory = ((DerivativeField)other).zero.getFactory();
                return ((FDSFactory)lhsFactory).compiler == ((FDSFactory)rhsFactory).compiler && ((FDSFactory)lhsFactory).valueField.equals(((FDSFactory)rhsFactory).valueField);
            }
            return false;
        }

        public int hashCode() {
            DSCompiler compiler = this.zero.getFactory().getCompiler();
            return 0x58D35DE8 ^ compiler.getFreeParameters() << 16 & compiler.getOrder();
        }
    }
}

