/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils.units;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hipparchus.fraction.Fraction;
import org.hipparchus.util.FastMath;
import org.orekit.utils.units.Lexer;
import org.orekit.utils.units.PowerTerm;
import org.orekit.utils.units.Token;
import org.orekit.utils.units.TokenType;
import org.orekit.utils.units.Unit;

public class Parser {
    private Parser() {
    }

    public static List<PowerTerm> buildTermsList(String unitsSpecification) {
        if (Unit.NONE.getName().equals(unitsSpecification)) {
            return null;
        }
        Lexer lexer = new Lexer(unitsSpecification);
        List<PowerTerm> chain = Parser.chain(lexer);
        if (lexer.next() != null) {
            throw lexer.generateException();
        }
        return chain;
    }

    private static List<PowerTerm> chain(Lexer lexer) {
        ArrayList<PowerTerm> chain = new ArrayList<PowerTerm>();
        chain.addAll(Parser.operand(lexer));
        Token token = lexer.next();
        while (token != null) {
            if (Parser.checkType(token, TokenType.MULTIPLICATION)) {
                chain.addAll(Parser.operand(lexer));
            } else if (Parser.checkType(token, TokenType.DIVISION)) {
                chain.addAll(Parser.reciprocate(Parser.operand(lexer)));
            } else {
                lexer.pushBack();
                break;
            }
            token = lexer.next();
        }
        return chain;
    }

    private static List<PowerTerm> operand(Lexer lexer) {
        Token token1 = lexer.next();
        if (token1 == null) {
            throw lexer.generateException();
        }
        if (Parser.checkType(token1, TokenType.INTEGER)) {
            int scale = token1.getInt();
            Token token2 = lexer.next();
            lexer.pushBack();
            if (token2 == null || Parser.checkType(token2, TokenType.MULTIPLICATION) || Parser.checkType(token2, TokenType.DIVISION)) {
                return Collections.singletonList(new PowerTerm(scale, "1", Fraction.ONE));
            }
            return Parser.applyScale(Parser.term(lexer), scale);
        }
        lexer.pushBack();
        return Parser.term(lexer);
    }

    private static List<PowerTerm> term(Lexer lexer) {
        Token token = lexer.next();
        if (token.getType() == TokenType.SQUARE_ROOT) {
            return Parser.applyExponent(Parser.base(lexer), Fraction.ONE_HALF);
        }
        lexer.pushBack();
        return Parser.applyExponent(Parser.base(lexer), Parser.power(lexer));
    }

    private static Fraction power(Lexer lexer) {
        Token token = lexer.next();
        if (Parser.checkType(token, TokenType.POWER)) {
            return Parser.exponent(lexer);
        }
        lexer.pushBack();
        return null;
    }

    private static Fraction exponent(Lexer lexer) {
        Token token = lexer.next();
        if (Parser.checkType(token, TokenType.FRACTION)) {
            return token.getFraction();
        }
        if (Parser.checkType(token, TokenType.INTEGER)) {
            return new Fraction(token.getInt());
        }
        lexer.pushBack();
        Parser.accept(lexer, TokenType.OPEN);
        int num = Parser.accept(lexer, TokenType.INTEGER).getInt();
        int den = Parser.denominator(lexer);
        Parser.accept(lexer, TokenType.CLOSE);
        return new Fraction(num, den);
    }

    private static int denominator(Lexer lexer) {
        Token token = lexer.next();
        if (Parser.checkType(token, TokenType.DIVISION)) {
            return Parser.accept(lexer, TokenType.INTEGER).getInt();
        }
        lexer.pushBack();
        return 1;
    }

    private static List<PowerTerm> base(Lexer lexer) {
        Token token = lexer.next();
        if (Parser.checkType(token, TokenType.IDENTIFIER)) {
            return Collections.singletonList(new PowerTerm(1.0, token.getSubString(), Fraction.ONE));
        }
        lexer.pushBack();
        Parser.accept(lexer, TokenType.OPEN);
        List<PowerTerm> chain = Parser.chain(lexer);
        Parser.accept(lexer, TokenType.CLOSE);
        return chain;
    }

    private static List<PowerTerm> reciprocate(List<PowerTerm> base) {
        ArrayList<PowerTerm> reciprocal = new ArrayList<PowerTerm>(base.size());
        for (PowerTerm term : base) {
            reciprocal.add(new PowerTerm(1.0 / term.getScale(), term.getBase(), term.getExponent().negate()));
        }
        return reciprocal;
    }

    private static List<PowerTerm> applyScale(List<PowerTerm> base, int scale) {
        if (scale == 1) {
            return base;
        }
        ArrayList<PowerTerm> powered = new ArrayList<PowerTerm>(base.size());
        boolean first = true;
        for (PowerTerm term : base) {
            if (first) {
                powered.add(new PowerTerm((double)scale * term.getScale(), term.getBase(), term.getExponent()));
                first = false;
                continue;
            }
            powered.add(term);
        }
        return powered;
    }

    private static List<PowerTerm> applyExponent(List<PowerTerm> base, Fraction exponent) {
        if (exponent == null || exponent.equals((Object)Fraction.ONE)) {
            return base;
        }
        ArrayList<PowerTerm> powered = new ArrayList<PowerTerm>(base.size());
        for (PowerTerm term : base) {
            double poweredScale = exponent.isInteger() ? FastMath.pow((double)term.getScale(), (int)exponent.getNumerator()) : (Fraction.ONE_HALF.equals((Object)exponent) ? FastMath.sqrt((double)term.getScale()) : FastMath.pow((double)term.getScale(), (double)exponent.doubleValue()));
            powered.add(new PowerTerm(poweredScale, term.getBase(), exponent.multiply(term.getExponent())));
        }
        return powered;
    }

    private static Token accept(Lexer lexer, TokenType expected) {
        Token token = lexer.next();
        if (!Parser.checkType(token, expected)) {
            throw lexer.generateException();
        }
        return token;
    }

    private static boolean checkType(Token token, TokenType expected) {
        return token != null && token.getType() == expected;
    }
}

