/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitMessages;

public enum AngularDerivativesFilter {
    USE_R(0),
    USE_RR(1),
    USE_RRA(2);

    private final int maxOrder;

    private AngularDerivativesFilter(int maxOrder) {
        this.maxOrder = maxOrder;
    }

    public int getMaxOrder() {
        return this.maxOrder;
    }

    public static AngularDerivativesFilter getFilter(int order) throws IllegalArgumentException {
        for (AngularDerivativesFilter filter : AngularDerivativesFilter.values()) {
            if (filter.getMaxOrder() != order) continue;
            return filter;
        }
        throw new OrekitIllegalArgumentException(OrekitMessages.OUT_OF_RANGE_DERIVATION_ORDER, order);
    }
}

