/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.integration.AdditionalEquations;
import org.orekit.propagation.numerical.NumericalPropagator;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.AbsolutePVCoordinates;
import org.orekit.utils.DoubleArrayDictionary;
import org.orekit.utils.MultipleShooting;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public abstract class AbstractMultipleShooting
implements MultipleShooting {
    private List<SpacecraftState> patchedSpacecraftStates;
    @Deprecated
    private List<AdditionalEquations> additionalEquations;
    private final List<NumericalPropagator> propagatorList;
    private final double[] propagationTime;
    private final boolean[] freePatchPointMap;
    private final boolean[] freeEpochMap;
    private int nFree;
    private int nEpoch;
    private int nConstraints;
    private final Map<Integer, Double> mapConstraints;
    private boolean isClosedOrbit;
    private final double tolerance;
    private final int maxIter;
    private final String additionalName;

    @Deprecated
    protected AbstractMultipleShooting(List<SpacecraftState> initialGuessList, List<NumericalPropagator> propagatorList, List<AdditionalEquations> additionalEquations, double arcDuration, double tolerance, String additionalName) {
        this(initialGuessList, propagatorList, arcDuration, tolerance, 1, additionalName);
        this.additionalEquations = additionalEquations;
    }

    protected AbstractMultipleShooting(List<SpacecraftState> initialGuessList, List<NumericalPropagator> propagatorList, double arcDuration, double tolerance, int maxIter, String additionalName) {
        this.patchedSpacecraftStates = initialGuessList;
        this.propagatorList = propagatorList;
        this.additionalName = additionalName;
        int propagationNumber = initialGuessList.size() - 1;
        this.propagationTime = new double[propagationNumber];
        Arrays.fill(this.propagationTime, arcDuration);
        this.freePatchPointMap = new boolean[6 * initialGuessList.size()];
        Arrays.fill(this.freePatchPointMap, true);
        this.freeEpochMap = new boolean[initialGuessList.size()];
        Arrays.fill(this.freeEpochMap, true);
        this.freeEpochMap[0] = false;
        this.nEpoch = initialGuessList.size() - 1;
        this.nConstraints = 6 * propagationNumber;
        this.nFree = 6 * initialGuessList.size() + 1;
        this.tolerance = tolerance;
        this.maxIter = maxIter;
        this.mapConstraints = new HashMap<Integer, Double>();
    }

    protected SpacecraftState getPatchPoint(int i) {
        return this.patchedSpacecraftStates.get(i);
    }

    public void setPatchPointComponentFreedom(int patchNumber, int componentIndex, boolean isFree) {
        if (this.freePatchPointMap[6 * (patchNumber - 1) + componentIndex] != isFree) {
            this.nFree += isFree ? 1 : -1;
            this.freePatchPointMap[6 * (patchNumber - 1) + componentIndex] = isFree;
        }
    }

    public void addConstraint(int patchNumber, int componentIndex, double constraintValue) {
        int contraintIndex = (patchNumber - 1) * 6 + componentIndex;
        if (!this.mapConstraints.containsKey(contraintIndex)) {
            ++this.nConstraints;
        }
        this.mapConstraints.put(contraintIndex, constraintValue);
    }

    public void setEpochFreedom(int patchNumber, boolean isFree) {
        if (this.freeEpochMap[patchNumber - 1] != isFree) {
            this.freeEpochMap[patchNumber - 1] = isFree;
            int eps = isFree ? 1 : -1;
            this.nEpoch += eps;
        }
    }

    @Override
    public List<SpacecraftState> compute() {
        RealVector fx;
        if (this.nFree > this.nConstraints) {
            throw new OrekitException((Localizable)OrekitMessages.MULTIPLE_SHOOTING_UNDERCONSTRAINED, this.nFree, this.nConstraints);
        }
        int iter = 0;
        double fxNorm = 0.0;
        do {
            List<SpacecraftState> propagatedSP = this.propagatePatchedSpacecraftState();
            RealMatrix M = this.computeJacobianMatrix(propagatedSP);
            fx = MatrixUtils.createRealVector((double[])this.computeConstraint(propagatedSP));
            RealMatrix MMt = M.multiplyTransposed(M);
            RealVector dx = M.transposeMultiply(MatrixUtils.inverse((RealMatrix)MMt)).operate(fx);
            this.updateTrajectory(dx);
        } while ((fxNorm = fx.getNorm() / (double)fx.getDimension()) > this.tolerance && ++iter < this.maxIter);
        return this.patchedSpacecraftStates;
    }

    private RealMatrix computeJacobianMatrix(List<SpacecraftState> propagatedSP) {
        double[][] subF;
        int npoints = this.patchedSpacecraftStates.size();
        int epochConstraint = this.nEpoch == 0 ? 0 : npoints - 1;
        int nrows = this.getNumberOfConstraints() + epochConstraint;
        int ncolumns = this.getNumberOfFreeVariables() + this.nEpoch;
        RealMatrix M = MatrixUtils.createRealMatrix((int)nrows, (int)ncolumns);
        int index = 0;
        int indexEpoch = this.nFree;
        for (int i = 0; i < npoints - 1; ++i) {
            SpacecraftState finalState = propagatedSP.get(i);
            TimeStampedPVCoordinates pvf = finalState.getPVCoordinates();
            double[][] phi = this.getStateTransitionMatrix(finalState);
            for (int j = 0; j < 6; ++j) {
                if (!this.freePatchPointMap[6 * i + j]) continue;
                for (int k = 0; k < 6; ++k) {
                    M.setEntry(6 * i + k, index, phi[k][j]);
                }
                if (i > 0) {
                    M.setEntry(6 * (i - 1) + j, index, -1.0);
                }
                ++index;
            }
            double[][] pvfArray = new double[][]{{pvf.getVelocity().getX()}, {pvf.getVelocity().getY()}, {pvf.getVelocity().getZ()}, {pvf.getAcceleration().getX()}, {pvf.getAcceleration().getY()}, {pvf.getAcceleration().getZ()}};
            M.setSubMatrix((double[][])pvfArray, 6 * i, this.nFree - 1);
            if (!this.freeEpochMap[i]) continue;
            double[] derivatives = finalState.getAdditionalState("derivatives");
            double[][] subC = new double[6][1];
            for (int j = 0; j < 6; ++j) {
                subC[j][0] = -derivatives[derivatives.length - 6 + j];
            }
            M.setSubMatrix(subC, 6 * i, indexEpoch);
            ++indexEpoch;
        }
        for (int j = 0; j < 6; ++j) {
            if (!this.freePatchPointMap[6 * (npoints - 1) + j]) continue;
            M.setEntry(6 * (npoints - 2) + j, index, -1.0);
            ++index;
        }
        if (this.nEpoch > 0) {
            double[][] subDE = this.computeEpochJacobianMatrix(propagatedSP);
            M.setSubMatrix(subDE, 6 * (npoints - 1), this.nFree - 1);
        }
        if ((subF = this.computeAdditionalJacobianMatrix(propagatedSP)).length > 0) {
            M.setSubMatrix(subF, 6 * (npoints - 1) + epochConstraint, 0);
        }
        return M;
    }

    private double[] computeConstraint(List<SpacecraftState> propagatedSP) {
        int npoints = this.patchedSpacecraftStates.size();
        double[] additionalConstraints = this.computeAdditionalConstraints(propagatedSP);
        boolean epoch = this.getNumberOfFreeEpoch() > 0;
        int nrows = epoch ? this.getNumberOfConstraints() + npoints - 1 : this.getNumberOfConstraints();
        double[] fx = new double[nrows];
        for (int i = 0; i < npoints - 1; ++i) {
            AbsolutePVCoordinates absPvi = this.patchedSpacecraftStates.get(i + 1).getAbsPVA();
            AbsolutePVCoordinates absPvf = propagatedSP.get(i).getAbsPVA();
            double[] ecartPos = absPvf.getPosition().subtract((Vector)absPvi.getPosition()).toArray();
            double[] ecartVel = absPvf.getVelocity().subtract((Vector)absPvi.getVelocity()).toArray();
            for (int j = 0; j < 3; ++j) {
                fx[6 * i + j] = ecartPos[j];
                fx[6 * i + 3 + j] = ecartVel[j];
            }
        }
        int index = 6 * (npoints - 1);
        if (epoch) {
            for (int i = 0; i < npoints - 1; ++i) {
                double deltaEpoch = this.patchedSpacecraftStates.get(i + 1).getDate().durationFrom(this.patchedSpacecraftStates.get(i).getDate());
                fx[index] = deltaEpoch - this.propagationTime[i];
                ++index;
            }
        }
        for (int i = 0; i < additionalConstraints.length; ++i) {
            fx[index] = additionalConstraints[i];
            ++index;
        }
        return fx;
    }

    private void updateTrajectory(RealVector dx) {
        int n = this.getNumberOfFreeVariables();
        boolean epochFree = this.getNumberOfFreeEpoch() > 0;
        double deltaT = dx.getEntry(n - 1);
        for (int i = 0; i < this.propagationTime.length; ++i) {
            this.propagationTime[i] = this.propagationTime[i] - deltaT;
        }
        int index = 0;
        int indexEpoch = 0;
        for (int i = 0; i < this.patchedSpacecraftStates.size(); ++i) {
            double[] deltaPV = new double[6];
            for (int j = 0; j < 6; ++j) {
                if (!this.freePatchPointMap[6 * i + j]) continue;
                deltaPV[j] = dx.getEntry(index);
                ++index;
            }
            Vector3D deltaP = new Vector3D(deltaPV[0], deltaPV[1], deltaPV[2]);
            Vector3D deltaV = new Vector3D(deltaPV[3], deltaPV[4], deltaPV[5]);
            AbsolutePVCoordinates currentAPV = this.patchedSpacecraftStates.get(i).getAbsPVA();
            Vector3D position = currentAPV.getPosition().subtract((Vector)deltaP);
            Vector3D velocity = currentAPV.getVelocity().subtract((Vector)deltaV);
            PVCoordinates pv = new PVCoordinates(position, velocity);
            AbsoluteDate epoch = currentAPV.getDate();
            if (epochFree) {
                if (this.freeEpochMap[i]) {
                    double deltaEpoch = dx.getEntry(n + indexEpoch);
                    epoch = epoch.shiftedBy(-deltaEpoch);
                    ++indexEpoch;
                }
            } else if (i > 0) {
                epoch = this.patchedSpacecraftStates.get(i - 1).getDate().shiftedBy(this.propagationTime[i - 1]);
            }
            AbsolutePVCoordinates updatedAPV = new AbsolutePVCoordinates(currentAPV.getFrame(), epoch, pv);
            int iAttitude = i < this.getPropagatorList().size() ? i : this.getPropagatorList().size() - 1;
            AttitudeProvider attitudeProvider = this.getPropagatorList().get(iAttitude).getAttitudeProvider();
            Attitude attitude = attitudeProvider.getAttitude(updatedAPV, epoch, currentAPV.getFrame());
            this.patchedSpacecraftStates.set(i, new SpacecraftState(updatedAPV, attitude));
        }
    }

    private List<SpacecraftState> propagatePatchedSpacecraftState() {
        int n = this.patchedSpacecraftStates.size() - 1;
        ArrayList<SpacecraftState> propagatedSP = new ArrayList<SpacecraftState>(n);
        for (int i = 0; i < n; ++i) {
            SpacecraftState augmentedInitialState = this.getAugmentedInitialState(i);
            this.propagatorList.get(i).setInitialState(augmentedInitialState);
            double integrationTime = this.propagationTime[i];
            SpacecraftState finalState = this.propagatorList.get(i).propagate(augmentedInitialState.getDate().shiftedBy(integrationTime));
            propagatedSP.add(finalState);
        }
        return propagatedSP;
    }

    private double[][] getStateTransitionMatrix(SpacecraftState s) {
        DoubleArrayDictionary dictionary = s.getAdditionalStatesValues();
        int dim = 6;
        double[][] phiM = new double[6][6];
        for (DoubleArrayDictionary.Entry entry : dictionary.getData()) {
            String name = entry.getKey();
            if (!this.additionalName.equals(name)) continue;
            double[] stm = entry.getValue();
            for (int i = 0; i < 6; ++i) {
                for (int j = 0; j < 6; ++j) {
                    phiM[i][j] = stm[6 * i + j];
                }
            }
        }
        return phiM;
    }

    protected double[][] computeEpochJacobianMatrix(List<SpacecraftState> propagatedSP) {
        boolean[] map = this.getFreeEpochMap();
        int nFreeEpoch = this.getNumberOfFreeEpoch();
        int ncolumns = 1 + nFreeEpoch;
        int nrows = this.patchedSpacecraftStates.size() - 1;
        double[][] M = new double[nrows][ncolumns];
        int index = 1;
        for (int i = 0; i < nrows; ++i) {
            M[i][0] = -1.0;
            if (map[i]) {
                M[i][index] = -1.0;
                ++index;
            }
            if (!map[i + 1]) continue;
            M[i][index] = 1.0;
        }
        return M;
    }

    protected void updateAdditionalConstraints(int startIndex, double[] fxAdditional) {
        int iter = startIndex;
        for (Map.Entry<Integer, Double> entry : this.getConstraintsMap().entrySet()) {
            int key = entry.getKey();
            double value = entry.getValue();
            int np = key / 6;
            int nc = key % 6;
            AbsolutePVCoordinates absPv = this.getPatchedSpacecraftState().get(np).getAbsPVA();
            fxAdditional[iter] = nc < 3 ? absPv.getPosition().toArray()[nc] - value : absPv.getVelocity().toArray()[nc - 3] - value;
            ++iter;
        }
    }

    protected abstract double[] computeAdditionalConstraints(List<SpacecraftState> var1);

    protected abstract double[][] computeAdditionalJacobianMatrix(List<SpacecraftState> var1);

    @Deprecated
    protected SpacecraftState getAugmentedInitialState(SpacecraftState initialState, AdditionalEquations additionalEquations2) {
        throw new UnsupportedOperationException();
    }

    protected SpacecraftState getAugmentedInitialState(int i) {
        return this.getAugmentedInitialState(this.patchedSpacecraftStates.get(i), this.additionalEquations.get(i));
    }

    public void setClosedOrbitConstraint(boolean isClosed) {
        if (this.isClosedOrbit != isClosed) {
            this.nConstraints += isClosed ? 6 : -6;
            this.isClosedOrbit = isClosed;
        }
    }

    protected int getNumberOfFreeVariables() {
        return this.nFree;
    }

    protected int getNumberOfFreeEpoch() {
        return this.nEpoch;
    }

    protected int getNumberOfConstraints() {
        return this.nConstraints;
    }

    protected boolean[] getFreePatchPointMap() {
        return this.freePatchPointMap;
    }

    protected boolean[] getFreeEpochMap() {
        return this.freeEpochMap;
    }

    protected Map<Integer, Double> getConstraintsMap() {
        return this.mapConstraints;
    }

    protected List<SpacecraftState> getPatchedSpacecraftState() {
        return this.patchedSpacecraftStates;
    }

    protected List<NumericalPropagator> getPropagatorList() {
        return this.propagatorList;
    }

    protected boolean isClosedOrbit() {
        return this.isClosedOrbit;
    }
}

