/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.orekit.frames.EOPHistory;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.time.UTCScale;

public class UT1Scale
implements TimeScale {
    private static final long serialVersionUID = 20131209L;
    private final UTCScale utc;
    private final EOPHistory eopHistory;

    protected UT1Scale(EOPHistory eopHistory, UTCScale utc) {
        this.eopHistory = eopHistory;
        this.utc = utc;
    }

    public UTCScale getUTCScale() {
        return this.utc;
    }

    public EOPHistory getEOPHistory() {
        return this.eopHistory;
    }

    @Override
    public double offsetFromTAI(AbsoluteDate date) {
        double dtu1 = this.eopHistory == null ? 0.0 : this.eopHistory.getUT1MinusUTC(date);
        double utcMinusTai = this.utc.offsetFromTAI(date);
        return utcMinusTai + dtu1;
    }

    @Override
    public <T extends CalculusFieldElement<T>> T offsetFromTAI(FieldAbsoluteDate<T> date) {
        Object dtu1 = this.eopHistory == null ? (CalculusFieldElement)date.getField().getZero() : this.eopHistory.getUT1MinusUTC(date);
        T utcMinusTai = this.utc.offsetFromTAI(date);
        return (T)((CalculusFieldElement)utcMinusTai.add((FieldElement)dtu1));
    }

    @Override
    public String getName() {
        return "UT1";
    }

    public String toString() {
        return this.getName();
    }
}

