/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitMessages;

public class TimeComponents
implements Serializable,
Comparable<TimeComponents> {
    public static final TimeComponents H00 = new TimeComponents(0, 0, 0.0);
    public static final TimeComponents H12 = new TimeComponents(12, 0, 0.0);
    private static final long serialVersionUID = 20160331L;
    private static final DecimalFormatSymbols US_SYMBOLS = new DecimalFormatSymbols(Locale.US);
    private static final Pattern ISO8601_FORMATS = Pattern.compile("^(\\d\\d):?(\\d\\d):?(\\d\\d(?:[.,]\\d+)?)?(?:Z|([-+]\\d\\d(?::?\\d\\d)?))?$");
    private final int hour;
    private final int minute;
    private final double second;
    private final int minutesFromUTC;

    public TimeComponents(int hour, int minute, double second) throws IllegalArgumentException {
        this(hour, minute, second, 0);
    }

    public TimeComponents(int hour, int minute, double second, int minutesFromUTC) throws IllegalArgumentException {
        if (hour < 0 || hour > 23 || minute < 0 || minute > 59 || second < 0.0 || second >= 61.0) {
            throw new OrekitIllegalArgumentException(OrekitMessages.NON_EXISTENT_HMS_TIME, hour, minute, second);
        }
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        this.minutesFromUTC = minutesFromUTC;
    }

    public TimeComponents(double secondInDay) throws OrekitIllegalArgumentException {
        this(0, secondInDay);
    }

    public TimeComponents(int secondInDayA, double secondInDayB) throws OrekitIllegalArgumentException {
        this(86400.0 - (double)secondInDayA - secondInDayB > 0.0 ? secondInDayA : secondInDayA - 1, secondInDayB, 86400.0 - (double)secondInDayA - secondInDayB > 0.0 ? 0.0 : 1.0, 86400.0 - (double)secondInDayA - secondInDayB > 0.0 ? 60 : 61);
    }

    private TimeComponents(int secondInDayA, double secondInDayB, double leap, int minuteDuration) throws OrekitIllegalArgumentException {
        int carry = (int)FastMath.floor((double)secondInDayB);
        int wholeSeconds = secondInDayA + carry;
        double fractional = secondInDayB - (double)carry;
        if (wholeSeconds < 0 || (double)wholeSeconds >= 86400.0) {
            throw new OrekitIllegalArgumentException(OrekitMessages.OUT_OF_RANGE_SECONDS_NUMBER_DETAIL, (double)secondInDayA + secondInDayB, 0, 86400.0);
        }
        int maxExtraSeconds = minuteDuration - 60;
        if (leap * (double)maxExtraSeconds < 0.0 || FastMath.abs((double)leap) > (double)FastMath.abs((int)maxExtraSeconds)) {
            throw new OrekitIllegalArgumentException(OrekitMessages.OUT_OF_RANGE_SECONDS_NUMBER_DETAIL, leap, 0, maxExtraSeconds);
        }
        this.hour = wholeSeconds / 3600;
        this.minute = (wholeSeconds -= 3600 * this.hour) / 60;
        double naiveSecond = (double)(wholeSeconds -= 60 * this.minute) + (leap + fractional);
        if (naiveSecond < 0.0) {
            throw new OrekitIllegalArgumentException(OrekitMessages.OUT_OF_RANGE_SECONDS_NUMBER_DETAIL, naiveSecond, 0, minuteDuration);
        }
        this.second = naiveSecond < (double)minuteDuration || Double.isNaN(naiveSecond) ? naiveSecond : FastMath.nextDown((double)minuteDuration);
        this.minutesFromUTC = 0;
    }

    public static TimeComponents fromSeconds(int secondInDayA, double secondInDayB, double leap, int minuteDuration) {
        return new TimeComponents(secondInDayA, secondInDayB, leap, minuteDuration);
    }

    public static TimeComponents parseTime(String string) {
        Matcher timeMatcher = ISO8601_FORMATS.matcher(string);
        if (timeMatcher.matches()) {
            int minutesFromUTC;
            int hour = Integer.parseInt(timeMatcher.group(1));
            int minute = Integer.parseInt(timeMatcher.group(2));
            double second = timeMatcher.group(3) == null ? 0.0 : Double.parseDouble(timeMatcher.group(3).replace(',', '.'));
            String offset = timeMatcher.group(4);
            if (offset == null) {
                minutesFromUTC = 0;
            } else {
                int sign = offset.codePointAt(0) == 45 ? -1 : 1;
                int hourOffset = Integer.parseInt(offset.substring(1, 3));
                int minutesOffset = offset.length() <= 3 ? 0 : Integer.parseInt(offset.substring(offset.length() - 2));
                minutesFromUTC = sign * (minutesOffset + 60 * hourOffset);
            }
            return new TimeComponents(hour, minute, second, minutesFromUTC);
        }
        throw new OrekitIllegalArgumentException(OrekitMessages.NON_EXISTENT_TIME, string);
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public double getSecond() {
        return this.second;
    }

    public int getMinutesFromUTC() {
        return this.minutesFromUTC;
    }

    public double getSecondsInLocalDay() {
        return this.second + (double)(60 * this.minute) + (double)(3600 * this.hour);
    }

    public double getSecondsInUTCDay() {
        return this.second + (double)(60 * (this.minute - this.minutesFromUTC)) + (double)(3600 * this.hour);
    }

    String toStringWithoutUtcOffset(DecimalFormat secondsFormat) {
        return String.format("%02d:%02d:%s", this.hour, this.minute, secondsFormat.format(this.second));
    }

    public String toStringWithoutUtcOffset() {
        DecimalFormat secondsFormat = new DecimalFormat("00.000###########", US_SYMBOLS);
        return this.toStringWithoutUtcOffset(secondsFormat);
    }

    public String formatUtcOffset() {
        int hourOffset = FastMath.abs((int)this.minutesFromUTC) / 60;
        int minuteOffset = FastMath.abs((int)this.minutesFromUTC) % 60;
        return (this.minutesFromUTC < 0 ? (char)'-' : '+') + String.format("%02d:%02d", hourOffset, minuteOffset);
    }

    public String toString() {
        return this.toStringWithoutUtcOffset() + this.formatUtcOffset();
    }

    @Override
    public int compareTo(TimeComponents other) {
        return Double.compare(this.getSecondsInUTCDay(), other.getSecondsInUTCDay());
    }

    public boolean equals(Object other) {
        try {
            TimeComponents otherTime = (TimeComponents)other;
            return otherTime != null && this.hour == otherTime.hour && this.minute == otherTime.minute && this.second == otherTime.second && this.minutesFromUTC == otherTime.minutesFromUTC;
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.second);
        return this.hour << 16 ^ this.minute - this.minutesFromUTC << 8 ^ (int)(bits ^ bits >>> 32);
    }
}

