/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import java.util.ArrayList;
import java.util.List;
import org.hipparchus.util.FastMath;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DatesSelector;
import org.orekit.time.TimeScale;

public class BurstSelector
implements DatesSelector {
    private final int maxBurstSize;
    private final double highRateStep;
    private final double burstPeriod;
    private final TimeScale alignmentTimeScale;
    private AbsoluteDate first;
    private AbsoluteDate last;
    private int index;

    public BurstSelector(int maxBurstSize, double highRateStep, double burstPeriod, TimeScale alignmentTimeScale) {
        this.maxBurstSize = maxBurstSize;
        this.highRateStep = highRateStep;
        this.burstPeriod = burstPeriod;
        this.alignmentTimeScale = alignmentTimeScale;
        this.last = null;
        this.first = null;
        this.index = 0;
    }

    @Override
    public List<AbsoluteDate> selectDates(AbsoluteDate start, AbsoluteDate end) {
        AbsoluteDate next;
        boolean reset;
        int increment = end.durationFrom(start) > 0.0 ? 1 : -1;
        int firstIndex = increment > 0 ? 0 : this.maxBurstSize - 1;
        int lastIndex = this.maxBurstSize - 1 - firstIndex;
        double signedHighRateStep = FastMath.copySign((double)this.highRateStep, (double)increment);
        double signedBurstPeriod = FastMath.copySign((double)this.burstPeriod, (double)increment);
        ArrayList<AbsoluteDate> selected = new ArrayList<AbsoluteDate>();
        boolean bl = reset = this.first == null || (double)increment * start.durationFrom(this.first) > this.burstPeriod;
        if (reset) {
            this.first = null;
            this.index = firstIndex;
        }
        AbsoluteDate absoluteDate = next = reset ? start : this.last.shiftedBy(signedHighRateStep);
        while ((double)increment * next.durationFrom(end) <= 0.0) {
            if (this.index == lastIndex + increment) {
                next = this.first.shiftedBy(signedBurstPeriod);
                this.first = null;
                this.index = firstIndex;
                if ((double)increment * next.durationFrom(end) > 0.0) break;
            }
            if (this.first == null && this.alignmentTimeScale != null) {
                double offset = (double)firstIndex * this.highRateStep;
                double t = next.getComponents(this.alignmentTimeScale).getTime().getSecondsInLocalDay() - offset;
                double dt = this.burstPeriod * (double)FastMath.round((double)(t / this.burstPeriod)) - t;
                next = next.shiftedBy(dt);
                while (this.index != lastIndex && (double)increment * next.durationFrom(start) < 0.0) {
                    next = next.shiftedBy(signedHighRateStep);
                    this.index += increment;
                }
                if ((double)increment * next.durationFrom(start) < 0.0) {
                    next = next.shiftedBy(signedBurstPeriod - (double)(this.maxBurstSize - 1) * signedHighRateStep);
                    this.index = firstIndex;
                }
            }
            if ((double)increment * next.durationFrom(start) >= 0.0) {
                if (!((double)increment * next.durationFrom(end) <= 0.0)) break;
                if (this.first == null) {
                    this.first = next.shiftedBy(-signedHighRateStep * (double)this.index);
                }
                selected.add(next);
            }
            this.last = next;
            this.index += increment;
            next = this.last.shiftedBy(signedHighRateStep);
        }
        return selected;
    }
}

