/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.forces;

import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;
import org.hipparchus.util.Precision;
import org.orekit.forces.radiation.IsotropicRadiationSingleCoefficient;
import org.orekit.forces.radiation.RadiationSensitive;
import org.orekit.forces.radiation.SolarRadiationPressure;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.semianalytical.dsst.forces.AbstractGaussianContribution;
import org.orekit.propagation.semianalytical.dsst.utilities.AuxiliaryElements;
import org.orekit.propagation.semianalytical.dsst.utilities.FieldAuxiliaryElements;
import org.orekit.utils.ExtendedPVCoordinatesProvider;
import org.orekit.utils.ParameterDriver;

public class DSSTSolarRadiationPressure
extends AbstractGaussianContribution {
    private static final double D_REF = 1.4959787E11;
    private static final double P_REF = 4.56E-6;
    private static final double GAUSS_THRESHOLD = 1.0E-15;
    private static final double S_ZERO = 1.0E-6;
    private static final String PREFIX = "DSST-SRP-";
    private final ExtendedPVCoordinatesProvider sun;
    private final double ae;
    private final RadiationSensitive spacecraft;

    public DSSTSolarRadiationPressure(double cr, double area, ExtendedPVCoordinatesProvider sun, double equatorialRadius, double mu) {
        this(1.4959787E11, 4.56E-6, cr, area, sun, equatorialRadius, mu);
    }

    public DSSTSolarRadiationPressure(ExtendedPVCoordinatesProvider sun, double equatorialRadius, RadiationSensitive spacecraft, double mu) {
        this(1.4959787E11, 4.56E-6, sun, equatorialRadius, spacecraft, mu);
    }

    public DSSTSolarRadiationPressure(double dRef, double pRef, double cr, double area, ExtendedPVCoordinatesProvider sun, double equatorialRadius, double mu) {
        this(dRef, pRef, sun, equatorialRadius, new IsotropicRadiationSingleCoefficient(area, cr), mu);
    }

    public DSSTSolarRadiationPressure(double dRef, double pRef, ExtendedPVCoordinatesProvider sun, double equatorialRadius, RadiationSensitive spacecraft, double mu) {
        super(PREFIX, 1.0E-15, new SolarRadiationPressure(dRef, pRef, sun, equatorialRadius, spacecraft), mu);
        this.sun = sun;
        this.ae = equatorialRadius;
        this.spacecraft = spacecraft;
    }

    public RadiationSensitive getSpacecraft() {
        return this.spacecraft;
    }

    @Override
    public EventDetector[] getEventsDetectors() {
        return null;
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldEventDetector<T>[] getFieldEventsDetectors(Field<T> field) {
        return null;
    }

    @Override
    protected List<ParameterDriver> getParametersDriversWithoutMu() {
        return this.spacecraft.getRadiationParametersDrivers();
    }

    @Override
    protected double[] getLLimits(SpacecraftState state, AuxiliaryElements auxiliaryElements) {
        double[] ll = new double[]{-Math.PI + MathUtils.normalizeAngle((double)state.getLv(), (double)0.0), Math.PI + MathUtils.normalizeAngle((double)state.getLv(), (double)0.0)};
        Vector3D sunDir = this.sun.getPVCoordinates(state.getDate(), state.getFrame()).getPosition().normalize();
        double alpha = sunDir.dotProduct((Vector)auxiliaryElements.getVectorF());
        double beta = sunDir.dotProduct((Vector)auxiliaryElements.getVectorG());
        double gamma = sunDir.dotProduct((Vector)auxiliaryElements.getVectorW());
        if (FastMath.abs((double)(gamma * auxiliaryElements.getSma() * (1.0 - auxiliaryElements.getEcc()))) < this.ae) {
            double[] roots;
            double bet2 = beta * beta;
            double h2 = auxiliaryElements.getH() * auxiliaryElements.getH();
            double k2 = auxiliaryElements.getK() * auxiliaryElements.getK();
            double m = this.ae / (auxiliaryElements.getSma() * auxiliaryElements.getB());
            double m2 = m * m;
            double m4 = m2 * m2;
            double bb = alpha * beta + m2 * auxiliaryElements.getH() * auxiliaryElements.getK();
            double b2 = bb * bb;
            double cc = alpha * alpha - bet2 + m2 * (k2 - h2);
            double dd = 1.0 - bet2 - m2 * (1.0 + h2);
            double[] a = new double[]{4.0 * b2 + cc * cc, 8.0 * bb * m2 * auxiliaryElements.getH() + 4.0 * cc * m2 * auxiliaryElements.getK(), -4.0 * b2 + 4.0 * m4 * h2 - 2.0 * cc * dd + 4.0 * m4 * k2, -8.0 * bb * m2 * auxiliaryElements.getH() - 4.0 * dd * m2 * auxiliaryElements.getK(), -4.0 * m4 * h2 + dd * dd};
            int nbRoots = this.realQuarticRoots(a, roots = new double[4]);
            if (nbRoots > 0) {
                boolean entryFound = false;
                boolean exitFound = false;
                for (int i = 0; i < nbRoots; ++i) {
                    double cosL = roots[i];
                    double sL = FastMath.sqrt((double)((1.0 - cosL) * (1.0 + cosL)));
                    for (int j = -1; j <= 1; j += 2) {
                        double range;
                        double S;
                        double sinL = (double)j * sL;
                        double cPhi = alpha * cosL + beta * sinL;
                        if (!(cPhi < 0.0) || !(FastMath.abs((double)(S = 1.0 - m2 * (range = 1.0 + auxiliaryElements.getK() * cosL + auxiliaryElements.getH() * sinL) * range - cPhi * cPhi)) < 1.0E-6)) continue;
                        double dSdL = m2 * range * (auxiliaryElements.getK() * sinL - auxiliaryElements.getH() * cosL) + cPhi * (alpha * sinL - beta * cosL);
                        if (dSdL > 0.0) {
                            exitFound = true;
                            ll[0] = FastMath.atan2((double)sinL, (double)cosL);
                            continue;
                        }
                        entryFound = true;
                        ll[1] = FastMath.atan2((double)sinL, (double)cosL);
                    }
                }
                if (entryFound != exitFound) {
                    ll[0] = -Math.PI;
                    ll[1] = Math.PI;
                }
                if (ll[0] > ll[1]) {
                    if (ll[1] < 0.0) {
                        ll[1] = ll[1] + Math.PI * 2;
                    } else {
                        ll[0] = ll[0] - Math.PI * 2;
                    }
                }
            }
        }
        return ll;
    }

    @Override
    protected <T extends CalculusFieldElement<T>> T[] getLLimits(FieldSpacecraftState<T> state, FieldAuxiliaryElements<T> auxiliaryElements) {
        Field<T> field = state.getDate().getField();
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        CalculusFieldElement one = (CalculusFieldElement)field.getOne();
        CalculusFieldElement pi = (CalculusFieldElement)one.getPi();
        CalculusFieldElement[] ll = (CalculusFieldElement[])MathArrays.buildArray(field, (int)2);
        ll[0] = (CalculusFieldElement)MathUtils.normalizeAngle(state.getLv(), (CalculusFieldElement)zero).subtract((FieldElement)pi);
        ll[1] = (CalculusFieldElement)MathUtils.normalizeAngle(state.getLv(), (CalculusFieldElement)zero).add((FieldElement)pi);
        FieldVector3D sunDir = this.sun.getPVCoordinates(state.getDate(), state.getFrame()).getPosition().normalize();
        CalculusFieldElement alpha = sunDir.dotProduct(auxiliaryElements.getVectorF());
        CalculusFieldElement beta = sunDir.dotProduct(auxiliaryElements.getVectorG());
        CalculusFieldElement gamma = sunDir.dotProduct(auxiliaryElements.getVectorW());
        if (FastMath.abs((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)gamma.multiply(auxiliaryElements.getSma())).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)auxiliaryElements.getEcc().negate()).add((FieldElement)one))))).getReal() < this.ae) {
            CalculusFieldElement bet2 = (CalculusFieldElement)beta.multiply((FieldElement)beta);
            CalculusFieldElement h2 = (CalculusFieldElement)auxiliaryElements.getH().multiply(auxiliaryElements.getH());
            CalculusFieldElement k2 = (CalculusFieldElement)auxiliaryElements.getK().multiply(auxiliaryElements.getK());
            CalculusFieldElement m = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)auxiliaryElements.getSma().multiply(auxiliaryElements.getB())).divide(this.ae)).reciprocal();
            CalculusFieldElement m2 = (CalculusFieldElement)m.multiply((FieldElement)m);
            CalculusFieldElement m4 = (CalculusFieldElement)m2.multiply((FieldElement)m2);
            CalculusFieldElement bb = (CalculusFieldElement)((CalculusFieldElement)alpha.multiply((FieldElement)beta)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)m2.multiply(auxiliaryElements.getH())).multiply(auxiliaryElements.getK())));
            CalculusFieldElement b2 = (CalculusFieldElement)bb.multiply((FieldElement)bb);
            CalculusFieldElement cc = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)alpha.multiply((FieldElement)alpha)).subtract((FieldElement)bet2)).add((FieldElement)((CalculusFieldElement)m2.multiply((FieldElement)((CalculusFieldElement)k2.subtract((FieldElement)h2)))));
            CalculusFieldElement dd = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)bet2.add((FieldElement)((CalculusFieldElement)m2.multiply((FieldElement)((CalculusFieldElement)h2.add(1.0)))))).negate()).add((FieldElement)one);
            CalculusFieldElement[] a = (CalculusFieldElement[])MathArrays.buildArray(field, (int)5);
            a[0] = (CalculusFieldElement)((CalculusFieldElement)b2.multiply(4.0)).add((FieldElement)((CalculusFieldElement)cc.multiply((FieldElement)cc)));
            a[1] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)bb.multiply(8.0)).multiply((FieldElement)m2)).multiply(auxiliaryElements.getH())).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)cc.multiply(4.0)).multiply((FieldElement)m2)).multiply(auxiliaryElements.getK())));
            a[2] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)m4.multiply((FieldElement)h2)).multiply(4.0)).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)cc.multiply((FieldElement)dd)).multiply(2.0)))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)m4.multiply((FieldElement)k2)).multiply(4.0)))).subtract((FieldElement)((CalculusFieldElement)b2.multiply(4.0)));
            a[3] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)auxiliaryElements.getH().multiply((FieldElement)m2)).multiply((FieldElement)bb)).multiply(8.0)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)auxiliaryElements.getK().multiply((FieldElement)m2)).multiply((FieldElement)dd)).multiply(4.0)))).negate();
            a[4] = (CalculusFieldElement)((CalculusFieldElement)dd.multiply((FieldElement)dd)).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)m4.multiply((FieldElement)h2)).multiply(4.0)));
            CalculusFieldElement[] roots = (CalculusFieldElement[])MathArrays.buildArray(field, (int)4);
            int nbRoots = this.realQuarticRoots(a, roots, field);
            if (nbRoots > 0) {
                boolean entryFound = false;
                boolean exitFound = false;
                for (int i = 0; i < nbRoots; ++i) {
                    CalculusFieldElement cosL = roots[i];
                    CalculusFieldElement sL = FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)cosL.negate()).add((FieldElement)one)).multiply((FieldElement)((CalculusFieldElement)cosL.add((FieldElement)one)))));
                    for (int j = -1; j <= 1; j += 2) {
                        CalculusFieldElement range;
                        CalculusFieldElement S;
                        CalculusFieldElement sinL = (CalculusFieldElement)sL.multiply(j);
                        CalculusFieldElement cPhi = (CalculusFieldElement)((CalculusFieldElement)cosL.multiply((FieldElement)alpha)).add((FieldElement)((CalculusFieldElement)sinL.multiply((FieldElement)beta)));
                        if (!(cPhi.getReal() < 0.0) || !(FastMath.abs((CalculusFieldElement)(S = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)(range = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)cosL.multiply(auxiliaryElements.getK())).add((FieldElement)((CalculusFieldElement)sinL.multiply(auxiliaryElements.getH())))).add((FieldElement)one)).multiply((FieldElement)range)).multiply((FieldElement)m2)).add((FieldElement)((CalculusFieldElement)cPhi.multiply((FieldElement)cPhi)))).negate()).add(1.0))).getReal() < 1.0E-6)) continue;
                        CalculusFieldElement dSdL = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)m2.multiply((FieldElement)range)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)auxiliaryElements.getK().multiply((FieldElement)sinL)).subtract((FieldElement)((CalculusFieldElement)auxiliaryElements.getH().multiply((FieldElement)cosL)))))).add((FieldElement)((CalculusFieldElement)cPhi.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)alpha.multiply((FieldElement)sinL)).subtract((FieldElement)((CalculusFieldElement)beta.multiply((FieldElement)cosL)))))));
                        if (dSdL.getReal() > 0.0) {
                            exitFound = true;
                            ll[0] = FastMath.atan2((CalculusFieldElement)sinL, (CalculusFieldElement)cosL);
                            continue;
                        }
                        entryFound = true;
                        ll[1] = FastMath.atan2((CalculusFieldElement)sinL, (CalculusFieldElement)cosL);
                    }
                }
                if (entryFound != exitFound) {
                    ll[0] = (CalculusFieldElement)pi.negate();
                    ll[1] = pi;
                }
                if (ll[0].getReal() > ll[1].getReal()) {
                    if (ll[1].getReal() < 0.0) {
                        ll[1] = (CalculusFieldElement)ll[1].add((FieldElement)((CalculusFieldElement)pi.multiply(2.0)));
                    } else {
                        ll[0] = (CalculusFieldElement)ll[0].subtract((FieldElement)((CalculusFieldElement)pi.multiply(2.0)));
                    }
                }
            }
        }
        return ll;
    }

    public double getEquatorialRadius() {
        return this.ae;
    }

    private int realQuarticRoots(double[] a, double[] y) {
        if (Precision.equals((double)a[0], (double)0.0)) {
            double[] aa = new double[a.length - 1];
            System.arraycopy(a, 1, aa, 0, aa.length);
            return this.realCubicRoots(aa, y);
        }
        double b = a[1] / a[0];
        double c = a[2] / a[0];
        double d = a[3] / a[0];
        double e = a[4] / a[0];
        double bh = b * 0.5;
        double[] z3 = new double[3];
        int i3 = this.realCubicRoots(new double[]{1.0, -c, b * d - 4.0 * e, e * (4.0 * c - b * b) - d * d}, z3);
        if (i3 == 0) {
            return 0;
        }
        double z = z3[0];
        double zh = z * 0.5;
        double p = FastMath.max((double)(z + bh * bh - c), (double)0.0);
        double q = FastMath.max((double)(zh * zh - e), (double)0.0);
        double r = bh * z - d;
        double pp = FastMath.sqrt((double)p);
        double qq = FastMath.copySign((double)FastMath.sqrt((double)q), (double)r);
        double[] y1 = new double[2];
        int n1 = this.realQuadraticRoots(new double[]{1.0, bh - pp, zh - qq}, y1);
        double[] y2 = new double[2];
        int n2 = this.realQuadraticRoots(new double[]{1.0, bh + pp, zh + qq}, y2);
        if (n1 == 2) {
            if (n2 == 2) {
                y[0] = y1[0];
                y[1] = y1[1];
                y[2] = y2[0];
                y[3] = y2[1];
                return 4;
            }
            y[0] = y1[0];
            y[1] = y1[1];
            return 2;
        }
        if (n2 == 2) {
            y[0] = y2[0];
            y[1] = y2[1];
            return 2;
        }
        return 0;
    }

    private <T extends CalculusFieldElement<T>> int realQuarticRoots(T[] a, T[] y, Field<T> field) {
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        if (Precision.equals((double)a[0].getReal(), (double)0.0)) {
            CalculusFieldElement[] aa = (CalculusFieldElement[])MathArrays.buildArray(field, (int)(a.length - 1));
            System.arraycopy(a, 1, aa, 0, aa.length);
            return this.realCubicRoots(aa, (CalculusFieldElement[])y, (Field)field);
        }
        CalculusFieldElement b = (CalculusFieldElement)a[1].divide(a[0]);
        CalculusFieldElement c = (CalculusFieldElement)a[2].divide(a[0]);
        CalculusFieldElement d = (CalculusFieldElement)a[3].divide(a[0]);
        CalculusFieldElement e = (CalculusFieldElement)a[4].divide(a[0]);
        CalculusFieldElement bh = (CalculusFieldElement)b.multiply(0.5);
        CalculusFieldElement[] z3 = (CalculusFieldElement[])MathArrays.buildArray(field, (int)3);
        CalculusFieldElement[] i = (CalculusFieldElement[])MathArrays.buildArray(field, (int)4);
        i[0] = (CalculusFieldElement)zero.add(1.0);
        i[1] = (CalculusFieldElement)c.negate();
        i[2] = (CalculusFieldElement)((CalculusFieldElement)b.multiply((FieldElement)d)).subtract((FieldElement)((CalculusFieldElement)e.multiply(4.0)));
        i[3] = (CalculusFieldElement)((CalculusFieldElement)e.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)c.multiply(4.0)).subtract((FieldElement)((CalculusFieldElement)b.multiply((FieldElement)b)))))).subtract((FieldElement)((CalculusFieldElement)d.multiply((FieldElement)d)));
        int i3 = this.realCubicRoots(i, z3, field);
        if (i3 == 0) {
            return 0;
        }
        CalculusFieldElement z = z3[0];
        CalculusFieldElement zh = (CalculusFieldElement)z.multiply(0.5);
        CalculusFieldElement p = FastMath.max((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)z.add((FieldElement)((CalculusFieldElement)bh.multiply((FieldElement)bh)))).subtract((FieldElement)c)), (CalculusFieldElement)zero);
        CalculusFieldElement q = FastMath.max((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)zh.multiply((FieldElement)zh)).subtract((FieldElement)e)), (CalculusFieldElement)zero);
        CalculusFieldElement r = (CalculusFieldElement)((CalculusFieldElement)bh.multiply((FieldElement)z)).subtract((FieldElement)d);
        CalculusFieldElement pp = FastMath.sqrt((CalculusFieldElement)p);
        CalculusFieldElement qq = FastMath.copySign((CalculusFieldElement)FastMath.sqrt((CalculusFieldElement)q), (CalculusFieldElement)r);
        CalculusFieldElement[] y1 = (CalculusFieldElement[])MathArrays.buildArray(field, (int)2);
        CalculusFieldElement[] n = (CalculusFieldElement[])MathArrays.buildArray(field, (int)3);
        n[0] = (CalculusFieldElement)zero.add(1.0);
        n[1] = (CalculusFieldElement)bh.subtract((FieldElement)pp);
        n[2] = (CalculusFieldElement)zh.subtract((FieldElement)qq);
        int n1 = this.realQuadraticRoots(n, y1);
        CalculusFieldElement[] y2 = (CalculusFieldElement[])MathArrays.buildArray(field, (int)2);
        CalculusFieldElement[] nn = (CalculusFieldElement[])MathArrays.buildArray(field, (int)3);
        nn[0] = (CalculusFieldElement)zero.add(1.0);
        nn[1] = (CalculusFieldElement)bh.add((FieldElement)pp);
        nn[2] = (CalculusFieldElement)zh.add((FieldElement)qq);
        int n2 = this.realQuadraticRoots(nn, y2);
        if (n1 == 2) {
            if (n2 == 2) {
                y[0] = y1[0];
                y[1] = y1[1];
                y[2] = y2[0];
                y[3] = y2[1];
                return 4;
            }
            y[0] = y1[0];
            y[1] = y1[1];
            return 2;
        }
        if (n2 == 2) {
            y[0] = y2[0];
            y[1] = y2[1];
            return 2;
        }
        return 0;
    }

    private int realCubicRoots(double[] a, double[] y) {
        if (Precision.equals((double)a[0], (double)0.0)) {
            double[] aa = new double[a.length - 1];
            System.arraycopy(a, 1, aa, 0, aa.length);
            return this.realQuadraticRoots(aa, y);
        }
        double b = -a[1] / (3.0 * a[0]);
        double b2 = b * b;
        double c = a[2] / a[0];
        double p = b2 - c / 3.0;
        double d = a[3] / a[0];
        double q = b * (b2 - c * 0.5) - d * 0.5;
        double disc = p * p * p - q * q;
        if (disc < 0.0) {
            double alpha = q + FastMath.copySign((double)FastMath.sqrt((double)(-disc)), (double)q);
            double cbrtAl = FastMath.cbrt((double)alpha);
            double cbrtBe = p / cbrtAl;
            y[0] = p < 0.0 ? b + 2.0 * q / (cbrtAl * cbrtAl + cbrtBe * cbrtBe - p) : (p > 0.0 ? b + cbrtAl + cbrtBe : b + cbrtAl);
            return 1;
        }
        if (disc > 0.0) {
            double phi = FastMath.atan2((double)FastMath.sqrt((double)disc), (double)q) / 3.0;
            double sqP = 2.0 * FastMath.sqrt((double)p);
            y[0] = b + sqP * FastMath.cos((double)phi);
            y[1] = b - sqP * FastMath.cos((double)(1.0471975511965976 + phi));
            y[2] = b - sqP * FastMath.cos((double)(1.0471975511965976 - phi));
            return 3;
        }
        double cbrtQ = FastMath.cbrt((double)q);
        double root1 = b + 2.0 * cbrtQ;
        double root2 = b - cbrtQ;
        if (q < 0.0) {
            y[0] = root2;
            y[1] = root2;
            y[2] = root1;
        } else {
            y[0] = root1;
            y[1] = root2;
            y[2] = root2;
        }
        return 3;
    }

    private <T extends CalculusFieldElement<T>> int realCubicRoots(T[] a, T[] y, Field<T> field) {
        if (Precision.equals((double)a[0].getReal(), (double)0.0)) {
            CalculusFieldElement[] aa = (CalculusFieldElement[])MathArrays.buildArray(field, (int)(a.length - 1));
            System.arraycopy(a, 1, aa, 0, aa.length);
            return this.realQuadraticRoots(aa, (CalculusFieldElement[])y);
        }
        CalculusFieldElement b = (CalculusFieldElement)((CalculusFieldElement)a[1].divide((FieldElement)((CalculusFieldElement)a[0].multiply(3.0)))).negate();
        CalculusFieldElement c = (CalculusFieldElement)a[2].divide(a[0]);
        CalculusFieldElement d = (CalculusFieldElement)a[3].divide(a[0]);
        CalculusFieldElement b2 = (CalculusFieldElement)b.multiply((FieldElement)b);
        CalculusFieldElement p = (CalculusFieldElement)b2.subtract((FieldElement)((CalculusFieldElement)c.divide(3.0)));
        CalculusFieldElement q = (CalculusFieldElement)((CalculusFieldElement)b.multiply((FieldElement)((CalculusFieldElement)b2.subtract((FieldElement)((CalculusFieldElement)c.multiply(0.5)))))).subtract((FieldElement)((CalculusFieldElement)d.multiply(0.5)));
        CalculusFieldElement disc = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)p.multiply((FieldElement)p)).multiply((FieldElement)p)).subtract((FieldElement)((CalculusFieldElement)q.multiply((FieldElement)q)));
        if (disc.getReal() < 0.0) {
            CalculusFieldElement alpha = (CalculusFieldElement)FastMath.copySign((CalculusFieldElement)FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)disc.negate())), (CalculusFieldElement)q).add((FieldElement)q);
            CalculusFieldElement cbrtAl = FastMath.cbrt((CalculusFieldElement)alpha);
            CalculusFieldElement cbrtBe = (CalculusFieldElement)p.divide((FieldElement)cbrtAl);
            y[0] = p.getReal() < 0.0 ? (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)q.divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)cbrtAl.multiply((FieldElement)cbrtAl)).add((FieldElement)((CalculusFieldElement)cbrtBe.multiply((FieldElement)cbrtBe)))).subtract((FieldElement)p)))).multiply(2.0)).add((FieldElement)b) : (p.getReal() > 0.0 ? (CalculusFieldElement)((CalculusFieldElement)b.add((FieldElement)cbrtAl)).add((FieldElement)cbrtBe) : (CalculusFieldElement)b.add((FieldElement)cbrtAl));
            return 1;
        }
        if (disc.getReal() > 0.0) {
            CalculusFieldElement phi = (CalculusFieldElement)FastMath.atan2((CalculusFieldElement)FastMath.sqrt((CalculusFieldElement)disc), (CalculusFieldElement)q).divide(3.0);
            CalculusFieldElement sqP = (CalculusFieldElement)FastMath.sqrt((CalculusFieldElement)p).multiply(2.0);
            y[0] = (CalculusFieldElement)b.add((FieldElement)((CalculusFieldElement)sqP.multiply((FieldElement)FastMath.cos((CalculusFieldElement)phi))));
            y[1] = (CalculusFieldElement)b.subtract((FieldElement)((CalculusFieldElement)sqP.multiply((FieldElement)FastMath.cos((CalculusFieldElement)((CalculusFieldElement)phi.add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)b.getPi()).divide(3.0))))))));
            y[2] = (CalculusFieldElement)b.subtract((FieldElement)((CalculusFieldElement)sqP.multiply((FieldElement)FastMath.cos((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)phi.negate()).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)b.getPi()).divide(3.0))))))));
            return 3;
        }
        CalculusFieldElement cbrtQ = FastMath.cbrt((CalculusFieldElement)q);
        CalculusFieldElement root1 = (CalculusFieldElement)b.add((FieldElement)((CalculusFieldElement)cbrtQ.multiply(2.0)));
        CalculusFieldElement root2 = (CalculusFieldElement)b.subtract((FieldElement)cbrtQ);
        if (q.getReal() < 0.0) {
            y[0] = root2;
            y[1] = root2;
            y[2] = root1;
        } else {
            y[0] = root1;
            y[1] = root2;
            y[2] = root2;
        }
        return 3;
    }

    private int realQuadraticRoots(double[] a, double[] y) {
        if (Precision.equals((double)a[0], (double)0.0)) {
            if (Precision.equals((double)a[1], (double)0.0)) {
                return 0;
            }
            y[0] = -a[2] / a[1];
            return 1;
        }
        double b = -0.5 * a[1] / a[0];
        double c = a[2] / a[0];
        double d = b * b - c;
        if (d < 0.0) {
            return 0;
        }
        if (d > 0.0) {
            double y0 = b + FastMath.copySign((double)FastMath.sqrt((double)d), (double)b);
            double y1 = c / y0;
            y[0] = FastMath.max((double)y0, (double)y1);
            y[1] = FastMath.min((double)y0, (double)y1);
            return 2;
        }
        y[0] = b;
        y[1] = b;
        return 2;
    }

    private <T extends CalculusFieldElement<T>> int realQuadraticRoots(T[] a, T[] y) {
        if (Precision.equals((double)a[0].getReal(), (double)0.0)) {
            if (Precision.equals((double)a[1].getReal(), (double)0.0)) {
                return 0;
            }
            y[0] = (CalculusFieldElement)((CalculusFieldElement)a[2].divide(a[1])).negate();
            return 1;
        }
        CalculusFieldElement b = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)a[1].divide(a[0])).multiply(0.5)).negate();
        CalculusFieldElement c = (CalculusFieldElement)a[2].divide(a[0]);
        CalculusFieldElement d = (CalculusFieldElement)((CalculusFieldElement)b.multiply((FieldElement)b)).subtract((FieldElement)c);
        if (d.getReal() < 0.0) {
            return 0;
        }
        if (d.getReal() > 0.0) {
            CalculusFieldElement y0 = (CalculusFieldElement)b.add((FieldElement)FastMath.copySign((CalculusFieldElement)FastMath.sqrt((CalculusFieldElement)d), (CalculusFieldElement)b));
            CalculusFieldElement y1 = (CalculusFieldElement)c.divide((FieldElement)y0);
            y[0] = FastMath.max((CalculusFieldElement)y0, (CalculusFieldElement)y1);
            y[1] = FastMath.min((CalculusFieldElement)y0, (CalculusFieldElement)y1);
            return 2;
        }
        y[0] = b;
        y[1] = b;
        return 2;
    }
}

