/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.numerical;

import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.integration.AdditionalDerivativesProvider;
import org.orekit.propagation.numerical.StateTransitionMatrixGenerator;

class IntegrableJacobianColumnGenerator
implements AdditionalDerivativesProvider,
StateTransitionMatrixGenerator.PartialsObserver {
    private final String stmName;
    private final String columnName;
    private final double[] pDot;

    IntegrableJacobianColumnGenerator(StateTransitionMatrixGenerator stmGenerator, String columnName) {
        this.stmName = stmGenerator.getName();
        this.columnName = columnName;
        this.pDot = new double[this.getDimension()];
        stmGenerator.addObserver(columnName, this);
    }

    @Override
    public String getName() {
        return this.columnName;
    }

    @Override
    public int getDimension() {
        return 6;
    }

    @Override
    public boolean yield(SpacecraftState state) {
        return !state.hasAdditionalStateDerivative(this.stmName);
    }

    @Override
    public void partialsComputed(SpacecraftState state, double[] factor, double[] accelerationPartials) {
        double[] p = state.getAdditionalState(this.getName());
        StateTransitionMatrixGenerator.multiplyMatrix(factor, p, this.pDot, 1);
        this.pDot[3] = this.pDot[3] + accelerationPartials[0];
        this.pDot[4] = this.pDot[4] + accelerationPartials[1];
        this.pDot[5] = this.pDot[5] + accelerationPartials[2];
    }

    @Override
    public double[] derivatives(SpacecraftState s) {
        return this.pDot;
    }
}

