/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.numerical;

import org.hipparchus.ode.nonstiff.ClassicalRungeKuttaIntegrator;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.InertialProvider;
import org.orekit.data.DataContext;
import org.orekit.frames.Frame;
import org.orekit.propagation.analytical.gnss.data.GLONASSOrbitalElements;
import org.orekit.propagation.numerical.GLONASSNumericalPropagator;

public class GLONASSNumericalPropagatorBuilder {
    private final GLONASSOrbitalElements orbit;
    private final ClassicalRungeKuttaIntegrator integrator;
    private final boolean isAccAvailable;
    private AttitudeProvider attitudeProvider;
    private double mass;
    private Frame eci;
    private DataContext dataContext;

    @DefaultDataContext
    public GLONASSNumericalPropagatorBuilder(ClassicalRungeKuttaIntegrator integrator, GLONASSOrbitalElements glonassOrbElt, boolean isAccAvailable) {
        this(integrator, glonassOrbElt, isAccAvailable, DataContext.getDefault());
    }

    public GLONASSNumericalPropagatorBuilder(ClassicalRungeKuttaIntegrator integrator, GLONASSOrbitalElements glonassOrbElt, boolean isAccAvailable, DataContext context) {
        this.isAccAvailable = isAccAvailable;
        this.integrator = integrator;
        this.orbit = glonassOrbElt;
        this.mass = 1000.0;
        this.dataContext = context;
        this.eci = this.dataContext.getFrames().getEME2000();
        this.attitudeProvider = InertialProvider.of(this.eci);
    }

    public GLONASSNumericalPropagatorBuilder attitudeProvider(AttitudeProvider userProvider) {
        this.attitudeProvider = userProvider;
        return this;
    }

    public GLONASSNumericalPropagatorBuilder mass(double userMass) {
        this.mass = userMass;
        return this;
    }

    public GLONASSNumericalPropagatorBuilder eci(Frame inertial) {
        this.eci = inertial;
        return this;
    }

    public GLONASSNumericalPropagator build() {
        return new GLONASSNumericalPropagator(this.integrator, this.orbit, this.eci, this.attitudeProvider, this.mass, this.dataContext, this.isAccAvailable);
    }
}

