/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.integration;

import org.hipparchus.CalculusFieldElement;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.frames.Frame;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.PropagationType;
import org.orekit.time.FieldAbsoluteDate;

public abstract class FieldStateMapper<T extends CalculusFieldElement<T>> {
    private final FieldAbsoluteDate<T> referenceDate;
    private final OrbitType orbitType;
    private final PositionAngle angleType;
    private final AttitudeProvider attitudeProvider;
    private final T mu;
    private final Frame frame;

    protected FieldStateMapper(FieldAbsoluteDate<T> referenceDate, T mu, OrbitType orbitType, PositionAngle positionAngleType, AttitudeProvider attitudeProvider, Frame frame) {
        this.referenceDate = referenceDate;
        this.mu = mu;
        this.orbitType = orbitType;
        this.angleType = positionAngleType;
        this.attitudeProvider = attitudeProvider;
        this.frame = frame;
    }

    public FieldAbsoluteDate<T> getReferenceDate() {
        return this.referenceDate;
    }

    public OrbitType getOrbitType() {
        return this.orbitType;
    }

    public void setPositionAngleType() {
    }

    public PositionAngle getPositionAngleType() {
        return this.angleType;
    }

    public T getMu() {
        return this.mu;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public AttitudeProvider getAttitudeProvider() {
        return this.attitudeProvider;
    }

    public FieldAbsoluteDate<T> mapDoubleToDate(T t) {
        return this.referenceDate.shiftedBy(t);
    }

    public FieldAbsoluteDate<T> mapDoubleToDate(T t, FieldAbsoluteDate<T> date) {
        if (date.durationFrom(this.referenceDate).getReal() == t.getReal()) {
            return date;
        }
        return this.mapDoubleToDate(t);
    }

    public T mapDateToDouble(FieldAbsoluteDate<T> date) {
        return date.durationFrom(this.referenceDate);
    }

    public FieldSpacecraftState<T> mapArrayToState(T t, T[] y, T[] yDot, PropagationType type) {
        return this.mapArrayToState(this.mapDoubleToDate(t), (CalculusFieldElement[])y, (CalculusFieldElement[])yDot, type);
    }

    public abstract FieldSpacecraftState<T> mapArrayToState(FieldAbsoluteDate<T> var1, T[] var2, T[] var3, PropagationType var4);

    public abstract void mapStateToArray(FieldSpacecraftState<T> var1, T[] var2, T[] var3);
}

