/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.util.FastMath;
import org.hipparchus.util.Precision;

enum Transformer {
    UNINITIALIZED{

        @Override
        protected double transformed(double g) {
            return 0.0;
        }
    }
    ,
    PLUS{

        @Override
        protected double transformed(double g) {
            return g;
        }
    }
    ,
    MINUS{

        @Override
        protected double transformed(double g) {
            return -g;
        }
    }
    ,
    MIN{

        @Override
        protected double transformed(double g) {
            return FastMath.min((double)(-Precision.SAFE_MIN), (double)FastMath.min((double)(-g), (double)g));
        }
    }
    ,
    MAX{

        @Override
        protected double transformed(double g) {
            return FastMath.max((double)Precision.SAFE_MIN, (double)FastMath.max((double)(-g), (double)g));
        }
    };


    protected abstract double transformed(double var1);
}

