/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import java.util.Arrays;
import org.hipparchus.ode.events.Action;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.EnablingPredicate;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.Transformer;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.time.AbsoluteDate;

public class EventEnablingPredicateFilter<T extends EventDetector>
extends AbstractDetector<EventEnablingPredicateFilter<T>> {
    private static final int HISTORY_SIZE = 100;
    private final T rawDetector;
    private final EnablingPredicate<? super T> enabler;
    private final Transformer[] transformers;
    private final AbsoluteDate[] updates;
    private boolean forward;
    private AbsoluteDate extremeT;
    private double extremeG;

    public EventEnablingPredicateFilter(T rawDetector, EnablingPredicate<? super T> enabler) {
        this(rawDetector.getMaxCheckInterval(), rawDetector.getThreshold(), rawDetector.getMaxIterationCount(), new LocalHandler(), (T)rawDetector, enabler);
    }

    private EventEnablingPredicateFilter(double maxCheck, double threshold, int maxIter, EventHandler<? super EventEnablingPredicateFilter<T>> handler, T rawDetector, EnablingPredicate<? super T> enabler) {
        super(maxCheck, threshold, maxIter, handler);
        this.rawDetector = rawDetector;
        this.enabler = enabler;
        this.transformers = new Transformer[100];
        this.updates = new AbsoluteDate[100];
    }

    @Override
    protected EventEnablingPredicateFilter<T> create(double newMaxCheck, double newThreshold, int newMaxIter, EventHandler<? super EventEnablingPredicateFilter<T>> newHandler) {
        return new EventEnablingPredicateFilter<T>(newMaxCheck, newThreshold, newMaxIter, newHandler, this.rawDetector, this.enabler);
    }

    public EventDetector getDetector() {
        return this.rawDetector;
    }

    @Override
    public void init(SpacecraftState s0, AbsoluteDate t) {
        super.init(s0, t);
        this.rawDetector.init(s0, t);
        this.forward = t.compareTo(s0.getDate()) >= 0;
        this.extremeT = this.forward ? AbsoluteDate.PAST_INFINITY : AbsoluteDate.FUTURE_INFINITY;
        this.extremeG = Double.NaN;
        Arrays.fill((Object[])this.transformers, (Object)Transformer.UNINITIALIZED);
        Arrays.fill(this.updates, this.extremeT);
    }

    @Override
    public double g(SpacecraftState s) {
        double rawG = this.rawDetector.g(s);
        boolean isEnabled = this.enabler.eventIsEnabled(s, this.rawDetector, rawG);
        if (Double.isNaN(this.extremeG)) {
            this.extremeG = rawG;
        }
        if (this.forward) {
            int last = this.transformers.length - 1;
            if (this.extremeT.compareTo(s.getDate()) < 0) {
                Transformer previous = this.transformers[last];
                Transformer next = this.selectTransformer(previous, this.extremeG, isEnabled);
                if (next != previous) {
                    System.arraycopy(this.updates, 1, this.updates, 0, last);
                    System.arraycopy(this.transformers, 1, this.transformers, 0, last);
                    this.updates[last] = this.extremeT;
                    this.transformers[last] = next;
                }
                this.extremeT = s.getDate();
                this.extremeG = rawG;
                return next.transformed(rawG);
            }
            for (int i = last; i > 0; --i) {
                if (this.updates[i].compareTo(s.getDate()) > 0) continue;
                return this.transformers[i].transformed(rawG);
            }
            return this.transformers[0].transformed(rawG);
        }
        if (s.getDate().compareTo(this.extremeT) < 0) {
            Transformer previous = this.transformers[0];
            Transformer next = this.selectTransformer(previous, this.extremeG, isEnabled);
            if (next != previous) {
                System.arraycopy(this.updates, 0, this.updates, 1, this.updates.length - 1);
                System.arraycopy(this.transformers, 0, this.transformers, 1, this.transformers.length - 1);
                this.updates[0] = this.extremeT;
                this.transformers[0] = next;
            }
            this.extremeT = s.getDate();
            this.extremeG = rawG;
            return next.transformed(rawG);
        }
        for (int i = 0; i < this.updates.length - 1; ++i) {
            if (s.getDate().compareTo(this.updates[i]) > 0) continue;
            return this.transformers[i].transformed(rawG);
        }
        return this.transformers[this.updates.length - 1].transformed(rawG);
    }

    private Transformer selectTransformer(Transformer previous, double previousG, boolean isEnabled) {
        if (isEnabled) {
            switch (previous) {
                case UNINITIALIZED: {
                    return Transformer.PLUS;
                }
                case MIN: {
                    return previousG >= 0.0 ? Transformer.MINUS : Transformer.PLUS;
                }
                case MAX: {
                    return previousG >= 0.0 ? Transformer.PLUS : Transformer.MINUS;
                }
            }
            return previous;
        }
        switch (previous) {
            case UNINITIALIZED: {
                return Transformer.MAX;
            }
            case PLUS: {
                return previousG >= 0.0 ? Transformer.MAX : Transformer.MIN;
            }
            case MINUS: {
                return previousG >= 0.0 ? Transformer.MIN : Transformer.MAX;
            }
        }
        return previous;
    }

    private static class LocalHandler<T extends EventDetector>
    implements EventHandler<EventEnablingPredicateFilter<T>> {
        private LocalHandler() {
        }

        @Override
        public Action eventOccurred(SpacecraftState s, EventEnablingPredicateFilter<T> ef, boolean increasing) {
            Transformer transformer = ((EventEnablingPredicateFilter)ef).forward ? ((EventEnablingPredicateFilter)ef).transformers[((EventEnablingPredicateFilter)ef).transformers.length - 1] : ((EventEnablingPredicateFilter)ef).transformers[0];
            return ((EventEnablingPredicateFilter)ef).rawDetector.eventOccurred(s, transformer == Transformer.PLUS ? increasing : !increasing);
        }

        @Override
        public SpacecraftState resetState(EventEnablingPredicateFilter<T> ef, SpacecraftState oldState) {
            return ((EventEnablingPredicateFilter)ef).rawDetector.resetState(oldState);
        }
    }
}

