/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.conversion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hipparchus.ode.ODEIntegrator;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.InertialProvider;
import org.orekit.estimation.leastsquares.BatchLSModel;
import org.orekit.estimation.leastsquares.ModelObserver;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.estimation.sequential.CovarianceMatrixProvider;
import org.orekit.estimation.sequential.KalmanModel;
import org.orekit.forces.ForceModel;
import org.orekit.forces.gravity.NewtonianAttraction;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.conversion.AbstractPropagatorBuilder;
import org.orekit.propagation.conversion.ODEIntegratorBuilder;
import org.orekit.propagation.conversion.OrbitDeterminationPropagatorBuilder;
import org.orekit.propagation.integration.AdditionalDerivativesProvider;
import org.orekit.propagation.integration.AdditionalEquations;
import org.orekit.propagation.integration.AdditionalEquationsAdapter;
import org.orekit.propagation.numerical.NumericalPropagator;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterDriversList;

public class NumericalPropagatorBuilder
extends AbstractPropagatorBuilder
implements OrbitDeterminationPropagatorBuilder {
    private final ODEIntegratorBuilder builder;
    private final List<ForceModel> forceModels;
    private double mass;

    public NumericalPropagatorBuilder(Orbit referenceOrbit, ODEIntegratorBuilder builder, PositionAngle positionAngle, double positionScale) {
        this(referenceOrbit, builder, positionAngle, positionScale, InertialProvider.of(referenceOrbit.getFrame()));
    }

    public NumericalPropagatorBuilder(Orbit referenceOrbit, ODEIntegratorBuilder builder, PositionAngle positionAngle, double positionScale, AttitudeProvider attitudeProvider) {
        super(referenceOrbit, positionAngle, positionScale, true, attitudeProvider);
        this.builder = builder;
        this.forceModels = new ArrayList<ForceModel>();
        this.mass = 1000.0;
    }

    public NumericalPropagatorBuilder copy() {
        NumericalPropagatorBuilder copyBuilder = new NumericalPropagatorBuilder(this.createInitialOrbit(), this.builder, this.getPositionAngle(), this.getPositionScale(), this.getAttitudeProvider());
        copyBuilder.setMass(this.mass);
        for (ForceModel model : this.forceModels) {
            copyBuilder.addForceModel(model);
        }
        return copyBuilder;
    }

    public ODEIntegratorBuilder getIntegratorBuilder() {
        return this.builder;
    }

    public List<ForceModel> getAllForceModels() {
        return Collections.unmodifiableList(this.forceModels);
    }

    public void addForceModel(ForceModel model) {
        if (model instanceof NewtonianAttraction) {
            if (this.hasNewtonianAttraction()) {
                this.forceModels.set(this.forceModels.size() - 1, model);
            } else {
                this.forceModels.add(model);
            }
        } else if (this.hasNewtonianAttraction()) {
            this.forceModels.add(this.forceModels.size() - 1, model);
        } else {
            this.forceModels.add(model);
        }
        for (ParameterDriver driver : model.getParametersDrivers()) {
            this.addSupportedParameter(driver);
        }
    }

    public double getMass() {
        return this.mass;
    }

    public void setMass(double mass) {
        this.mass = mass;
    }

    @Override
    public NumericalPropagator buildPropagator(double[] normalizedParameters) {
        this.setParameters(normalizedParameters);
        Orbit orbit = this.createInitialOrbit();
        Attitude attitude = this.getAttitudeProvider().getAttitude(orbit, orbit.getDate(), this.getFrame());
        SpacecraftState state = new SpacecraftState(orbit, attitude, this.mass);
        NumericalPropagator propagator = new NumericalPropagator((ODEIntegrator)this.builder.buildIntegrator(orbit, this.getOrbitType()), this.getAttitudeProvider());
        propagator.setOrbitType(this.getOrbitType());
        propagator.setPositionAngleType(this.getPositionAngle());
        if (!this.hasNewtonianAttraction()) {
            this.addForceModel(new NewtonianAttraction(orbit.getMu()));
        }
        for (ForceModel model : this.forceModels) {
            propagator.addForceModel(model);
        }
        propagator.resetInitialState(state);
        for (AdditionalDerivativesProvider provider : this.getAdditionalDerivativesProviders()) {
            propagator.addAdditionalDerivativesProvider(provider);
        }
        for (AdditionalEquations equations : this.getAdditionalEquations()) {
            propagator.addAdditionalDerivativesProvider(new AdditionalEquationsAdapter(equations, propagator::getInitialState));
        }
        return propagator;
    }

    @Override
    public BatchLSModel buildLSModel(OrbitDeterminationPropagatorBuilder[] builders, List<ObservedMeasurement<?>> measurements, ParameterDriversList estimatedMeasurementsParameters, ModelObserver observer) {
        return new BatchLSModel(builders, measurements, estimatedMeasurementsParameters, observer);
    }

    @Override
    public KalmanModel buildKalmanModel(List<OrbitDeterminationPropagatorBuilder> propagatorBuilders, List<CovarianceMatrixProvider> covarianceMatricesProviders, ParameterDriversList estimatedMeasurementsParameters, CovarianceMatrixProvider measurementProcessNoiseMatrix) {
        return new KalmanModel(propagatorBuilders, covarianceMatricesProviders, estimatedMeasurementsParameters, measurementProcessNoiseMatrix);
    }

    private boolean hasNewtonianAttraction() {
        int last = this.forceModels.size() - 1;
        return last >= 0 && this.forceModels.get(last) instanceof NewtonianAttraction;
    }
}

