/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical.tle;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;
import org.hipparchus.util.SinCos;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.data.DataContext;
import org.orekit.frames.Frame;
import org.orekit.propagation.analytical.tle.FieldSDP4;
import org.orekit.propagation.analytical.tle.FieldTLE;
import org.orekit.time.DateTimeComponents;

public class FieldDeepSDP4<T extends CalculusFieldElement<T>>
extends FieldSDP4<T> {
    private static final double SECULAR_INTEGRATION_STEP = 720.0;
    private double thgr;
    private T xnq;
    private T omegaq;
    private double zcosil;
    private double zsinil;
    private double zsinhl;
    private double zcoshl;
    private double zmol;
    private double zcosgl;
    private double zsingl;
    private double zmos;
    private T savtsn;
    private T ee2;
    private T e3;
    private T xi2;
    private T xi3;
    private T xl2;
    private T xl3;
    private T xl4;
    private T xgh2;
    private T xgh3;
    private T xgh4;
    private T xh2;
    private T xh3;
    private T d2201;
    private T d2211;
    private T d3210;
    private T d3222;
    private T d4410;
    private T d4422;
    private T d5220;
    private T d5232;
    private T d5421;
    private T d5433;
    private T xlamo;
    private T sse;
    private T ssi;
    private T ssl;
    private T ssh;
    private T ssg;
    private T se2;
    private T si2;
    private T sl2;
    private T sgh2;
    private T sh2;
    private T se3;
    private T si3;
    private T sl3;
    private T sgh3;
    private T sh3;
    private T sl4;
    private T sgh4;
    private T del1;
    private T del2;
    private T del3;
    private T xfact;
    private T xli;
    private T xni;
    private T atime;
    private T pe;
    private T pinc;
    private T pl;
    private T pgh;
    private T ph;
    private T[] derivs;
    private boolean resonant;
    private boolean synchronous;
    private boolean isDundeeCompliant = true;

    @DefaultDataContext
    public FieldDeepSDP4(FieldTLE<T> initialTLE, AttitudeProvider attitudeProvider, T mass, T[] parameters) {
        this(initialTLE, attitudeProvider, (CalculusFieldElement)mass, DataContext.getDefault().getFrames().getTEME(), (CalculusFieldElement[])parameters);
    }

    public FieldDeepSDP4(FieldTLE<T> initialTLE, AttitudeProvider attitudeProvider, T mass, Frame teme, T[] parameters) {
        super(initialTLE, attitudeProvider, mass, teme, parameters);
    }

    @Override
    protected void luniSolarTermsComputation() {
        CalculusFieldElement zero = (CalculusFieldElement)this.tle.getPerigeeArgument().getField().getZero();
        CalculusFieldElement pi = (CalculusFieldElement)zero.getPi();
        FieldSinCos scg = FastMath.sinCos(this.tle.getPerigeeArgument());
        CalculusFieldElement sing = (CalculusFieldElement)scg.sin();
        CalculusFieldElement cosg = (CalculusFieldElement)scg.cos();
        FieldSinCos scq = FastMath.sinCos(this.tle.getRaan());
        CalculusFieldElement sinq = (CalculusFieldElement)scq.sin();
        CalculusFieldElement cosq = (CalculusFieldElement)scq.cos();
        CalculusFieldElement aqnv = (CalculusFieldElement)this.a0dp.reciprocal();
        double daysSince1900 = this.tle.getDate().getComponents(this.utc).offsetFrom(DateTimeComponents.JULIAN_EPOCH) / 86400.0 - 2415020.0;
        double cc = 2.9864797E-6;
        double ze = 0.01675;
        double zn = 1.19459E-5;
        CalculusFieldElement zsinh = sinq;
        CalculusFieldElement zcosh = cosq;
        this.thgr = this.thetaG(this.tle.getDate());
        this.xnq = this.xn0dp;
        this.omegaq = this.tle.getPerigeeArgument();
        double xnodce = 4.523602 - 9.2422029E-4 * daysSince1900;
        SinCos scTem = FastMath.sinCos((double)xnodce);
        double stem = scTem.sin();
        double ctem = scTem.cos();
        double c_minus_gam = 0.228027132 * daysSince1900 - 1.1151842;
        double gam = 5.8351514 + 0.001944368 * daysSince1900;
        this.zcosil = 0.91375164 - 0.03568096 * ctem;
        this.zsinil = FastMath.sqrt((double)(1.0 - this.zcosil * this.zcosil));
        this.zsinhl = 0.089683511 * stem / this.zsinil;
        this.zcoshl = FastMath.sqrt((double)(1.0 - this.zsinhl * this.zsinhl));
        this.zmol = MathUtils.normalizeAngle((double)c_minus_gam, (double)pi.getReal());
        double zx = 0.39785416 * stem / this.zsinil;
        double zy = this.zcoshl * ctem + 0.91744867 * this.zsinhl * stem;
        zx = FastMath.atan2((double)zx, (double)zy) + gam - xnodce;
        SinCos scZx = FastMath.sinCos((double)zx);
        this.zcosgl = scZx.cos();
        this.zsingl = scZx.sin();
        this.zmos = MathUtils.normalizeAngle((double)(6.2565837 + 0.017201977 * daysSince1900), (double)pi.getReal());
        this.savtsn = (CalculusFieldElement)zero.add(1.0E20);
        CalculusFieldElement zcosi = (CalculusFieldElement)zero.add(0.91744867);
        CalculusFieldElement zsini = (CalculusFieldElement)zero.add(0.39785416);
        CalculusFieldElement zsing = (CalculusFieldElement)zero.add(-0.98088458);
        CalculusFieldElement zcosg = (CalculusFieldElement)zero.add(0.1945905);
        CalculusFieldElement se = zero;
        CalculusFieldElement sgh = zero;
        CalculusFieldElement sh = zero;
        CalculusFieldElement si = zero;
        CalculusFieldElement sl = zero;
        for (int iteration = 0; iteration < 2; ++iteration) {
            CalculusFieldElement a1 = (CalculusFieldElement)((CalculusFieldElement)zcosh.multiply((FieldElement)zcosg)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)zsinh.multiply((FieldElement)zsing)).multiply((FieldElement)zcosi)));
            CalculusFieldElement a3 = (CalculusFieldElement)((CalculusFieldElement)zcosh.multiply((FieldElement)((CalculusFieldElement)zsing.negate()))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)zsinh.multiply((FieldElement)zcosg)).multiply((FieldElement)zcosi)));
            CalculusFieldElement a7 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)zsinh.negate()).multiply((FieldElement)zcosg)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)zcosh.multiply((FieldElement)zcosi)).multiply((FieldElement)zsing)));
            CalculusFieldElement a8 = (CalculusFieldElement)zsing.multiply((FieldElement)zsini);
            CalculusFieldElement a9 = (CalculusFieldElement)((CalculusFieldElement)zsinh.multiply((FieldElement)zsing)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)zcosh.multiply((FieldElement)zcosi)).multiply((FieldElement)zcosg)));
            CalculusFieldElement a10 = (CalculusFieldElement)zcosg.multiply((FieldElement)zsini);
            CalculusFieldElement a2 = (CalculusFieldElement)((CalculusFieldElement)this.cosi0.multiply((FieldElement)a7)).add((FieldElement)((CalculusFieldElement)this.sini0.multiply((FieldElement)a8)));
            CalculusFieldElement a4 = (CalculusFieldElement)((CalculusFieldElement)this.cosi0.multiply((FieldElement)a9)).add((FieldElement)((CalculusFieldElement)this.sini0.multiply((FieldElement)a10)));
            CalculusFieldElement a5 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.sini0.negate()).multiply((FieldElement)a7)).add((FieldElement)((CalculusFieldElement)this.cosi0.multiply((FieldElement)a8)));
            CalculusFieldElement a6 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.sini0.negate()).multiply((FieldElement)a9)).add((FieldElement)((CalculusFieldElement)this.cosi0.multiply((FieldElement)a10)));
            CalculusFieldElement x1 = (CalculusFieldElement)((CalculusFieldElement)a1.multiply((FieldElement)cosg)).add((FieldElement)((CalculusFieldElement)a2.multiply((FieldElement)sing)));
            CalculusFieldElement x2 = (CalculusFieldElement)((CalculusFieldElement)a3.multiply((FieldElement)cosg)).add((FieldElement)((CalculusFieldElement)a4.multiply((FieldElement)sing)));
            CalculusFieldElement x3 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)a1.negate()).multiply((FieldElement)sing)).add((FieldElement)((CalculusFieldElement)a2.multiply((FieldElement)cosg)));
            CalculusFieldElement x4 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)a3.negate()).multiply((FieldElement)sing)).add((FieldElement)((CalculusFieldElement)a4.multiply((FieldElement)cosg)));
            CalculusFieldElement x5 = (CalculusFieldElement)a5.multiply((FieldElement)sing);
            CalculusFieldElement x6 = (CalculusFieldElement)a6.multiply((FieldElement)sing);
            CalculusFieldElement x7 = (CalculusFieldElement)a5.multiply((FieldElement)cosg);
            CalculusFieldElement x8 = (CalculusFieldElement)a6.multiply((FieldElement)cosg);
            CalculusFieldElement z31 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)x1.multiply((FieldElement)x1)).multiply(12)).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)x3.multiply((FieldElement)x3)).multiply(3)));
            CalculusFieldElement z32 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)x1.multiply((FieldElement)x2)).multiply(24)).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)x3.multiply((FieldElement)x4)).multiply(6)));
            CalculusFieldElement z33 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)x2.multiply((FieldElement)x2)).multiply(12)).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)x4.multiply((FieldElement)x4)).multiply(3)));
            CalculusFieldElement z11 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)a1.multiply(-6)).multiply((FieldElement)a5)).add((FieldElement)((CalculusFieldElement)this.e0sq.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)x1.multiply((FieldElement)x7)).multiply(-24)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)x3.multiply((FieldElement)x5)).multiply(-6)))))));
            CalculusFieldElement z12 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)a1.multiply((FieldElement)a6)).add((FieldElement)((CalculusFieldElement)a3.multiply((FieldElement)a5)))).multiply(-6)).add((FieldElement)((CalculusFieldElement)this.e0sq.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)x2.multiply((FieldElement)x7)).add((FieldElement)((CalculusFieldElement)x1.multiply((FieldElement)x8)))).multiply(-24)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)x3.multiply((FieldElement)x6)).add((FieldElement)((CalculusFieldElement)x4.multiply((FieldElement)x5)))).multiply(-6)))))));
            CalculusFieldElement z13 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)a3.multiply((FieldElement)a6)).multiply(-6)).add((FieldElement)((CalculusFieldElement)this.e0sq.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)x2.multiply((FieldElement)x8)).multiply(-24)).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)x4.multiply((FieldElement)x6)).multiply(6)))))));
            CalculusFieldElement z21 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)a2.multiply((FieldElement)a5)).multiply(6)).add((FieldElement)((CalculusFieldElement)this.e0sq.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)x1.multiply((FieldElement)x5)).multiply(24)).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)x3.multiply((FieldElement)x7)).multiply(6)))))));
            CalculusFieldElement z22 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)a4.multiply((FieldElement)a5)).add((FieldElement)((CalculusFieldElement)a2.multiply((FieldElement)a6)))).multiply(6)).add((FieldElement)((CalculusFieldElement)this.e0sq.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)x2.multiply((FieldElement)x5)).add((FieldElement)((CalculusFieldElement)x1.multiply((FieldElement)x6)))).multiply(24)).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)x4.multiply((FieldElement)x7)).add((FieldElement)((CalculusFieldElement)x3.multiply((FieldElement)x8)))).multiply(6)))))));
            CalculusFieldElement z23 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)a4.multiply((FieldElement)a6)).multiply(6)).add((FieldElement)((CalculusFieldElement)this.e0sq.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)x2.multiply((FieldElement)x6)).multiply(24)).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)x4.multiply((FieldElement)x8)).multiply(6)))))));
            CalculusFieldElement s3 = (CalculusFieldElement)((CalculusFieldElement)this.xnq.reciprocal()).multiply(cc);
            CalculusFieldElement s2 = (CalculusFieldElement)((CalculusFieldElement)this.beta0.reciprocal()).multiply((FieldElement)((CalculusFieldElement)s3.multiply(-0.5)));
            CalculusFieldElement s4 = (CalculusFieldElement)s3.multiply((FieldElement)this.beta0);
            CalculusFieldElement s1 = (CalculusFieldElement)((CalculusFieldElement)this.tle.getE().multiply((FieldElement)s4)).multiply(-15);
            CalculusFieldElement s5 = (CalculusFieldElement)((CalculusFieldElement)x1.multiply((FieldElement)x3)).add((FieldElement)((CalculusFieldElement)x2.multiply((FieldElement)x4)));
            CalculusFieldElement s6 = (CalculusFieldElement)((CalculusFieldElement)x2.multiply((FieldElement)x3)).add((FieldElement)((CalculusFieldElement)x1.multiply((FieldElement)x4)));
            CalculusFieldElement s7 = (CalculusFieldElement)((CalculusFieldElement)x2.multiply((FieldElement)x4)).subtract((FieldElement)((CalculusFieldElement)x1.multiply((FieldElement)x3)));
            CalculusFieldElement z1 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)a1.multiply((FieldElement)a1)).add((FieldElement)((CalculusFieldElement)a2.multiply((FieldElement)a2)))).multiply(3)).add((FieldElement)((CalculusFieldElement)z31.multiply((FieldElement)this.e0sq)));
            CalculusFieldElement z2 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)a1.multiply((FieldElement)a3)).add((FieldElement)((CalculusFieldElement)a2.multiply((FieldElement)a4)))).multiply(6)).add((FieldElement)((CalculusFieldElement)z32.multiply((FieldElement)this.e0sq)));
            CalculusFieldElement z3 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)a3.multiply((FieldElement)a3)).add((FieldElement)((CalculusFieldElement)a4.multiply((FieldElement)a4)))).multiply(3)).add((FieldElement)((CalculusFieldElement)z33.multiply((FieldElement)this.e0sq)));
            z1 = (CalculusFieldElement)((CalculusFieldElement)z1.add((FieldElement)z1)).add((FieldElement)((CalculusFieldElement)this.beta02.multiply((FieldElement)z31)));
            z2 = (CalculusFieldElement)((CalculusFieldElement)z2.add((FieldElement)z2)).add((FieldElement)((CalculusFieldElement)this.beta02.multiply((FieldElement)z32)));
            z3 = (CalculusFieldElement)((CalculusFieldElement)z3.add((FieldElement)z3)).add((FieldElement)((CalculusFieldElement)this.beta02.multiply((FieldElement)z33)));
            se = (CalculusFieldElement)((CalculusFieldElement)s1.multiply(zn)).multiply((FieldElement)s5);
            si = (CalculusFieldElement)((CalculusFieldElement)s2.multiply(zn)).multiply((FieldElement)((CalculusFieldElement)z11.add((FieldElement)z13)));
            sl = (CalculusFieldElement)((CalculusFieldElement)s3.multiply(-zn)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)z1.add((FieldElement)z3)).subtract(14.0)).subtract((FieldElement)((CalculusFieldElement)this.e0sq.multiply(6)))));
            sgh = (CalculusFieldElement)((CalculusFieldElement)s4.multiply(zn)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)z31.add((FieldElement)z33)).subtract(6.0)));
            sh = this.tle.getI().getReal() < ((CalculusFieldElement)pi.divide(60.0)).getReal() ? zero : (CalculusFieldElement)((CalculusFieldElement)s2.multiply(-zn)).multiply((FieldElement)((CalculusFieldElement)z21.add((FieldElement)z23)));
            this.ee2 = (CalculusFieldElement)((CalculusFieldElement)s1.multiply((FieldElement)s6)).multiply(2);
            this.e3 = (CalculusFieldElement)((CalculusFieldElement)s1.multiply((FieldElement)s7)).multiply(2);
            this.xi2 = (CalculusFieldElement)((CalculusFieldElement)s2.multiply((FieldElement)z12)).multiply(2);
            this.xi3 = (CalculusFieldElement)((CalculusFieldElement)s2.multiply((FieldElement)((CalculusFieldElement)z13.subtract((FieldElement)z11)))).multiply(2);
            this.xl2 = (CalculusFieldElement)((CalculusFieldElement)s3.multiply((FieldElement)z2)).multiply(-2);
            this.xl3 = (CalculusFieldElement)((CalculusFieldElement)s3.multiply((FieldElement)((CalculusFieldElement)z3.subtract((FieldElement)z1)))).multiply(-2);
            this.xl4 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)s3.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.e0sq.multiply(-9)).add(-21.0)))).multiply(ze)).multiply(-2);
            this.xgh2 = (CalculusFieldElement)((CalculusFieldElement)s4.multiply((FieldElement)z32)).multiply(2);
            this.xgh3 = (CalculusFieldElement)((CalculusFieldElement)s4.multiply((FieldElement)((CalculusFieldElement)z33.subtract((FieldElement)z31)))).multiply(2);
            this.xgh4 = (CalculusFieldElement)((CalculusFieldElement)s4.multiply(ze)).multiply(-18);
            this.xh2 = (CalculusFieldElement)((CalculusFieldElement)s2.multiply((FieldElement)z22)).multiply(-2);
            this.xh3 = (CalculusFieldElement)((CalculusFieldElement)s2.multiply((FieldElement)((CalculusFieldElement)z23.subtract((FieldElement)z21)))).multiply(-2);
            if (iteration != 0) continue;
            this.sse = se;
            this.ssi = si;
            this.ssl = sl;
            this.ssh = this.tle.getI().getReal() < ((CalculusFieldElement)pi.divide(60.0)).getReal() ? zero : (CalculusFieldElement)sh.divide((FieldElement)this.sini0);
            this.ssg = (CalculusFieldElement)sgh.subtract((FieldElement)((CalculusFieldElement)this.cosi0.multiply(this.ssh)));
            this.se2 = this.ee2;
            this.si2 = this.xi2;
            this.sl2 = this.xl2;
            this.sgh2 = this.xgh2;
            this.sh2 = this.xh2;
            this.se3 = this.e3;
            this.si3 = this.xi3;
            this.sl3 = this.xl3;
            this.sgh3 = this.xgh3;
            this.sh3 = this.xh3;
            this.sl4 = this.xl4;
            this.sgh4 = this.xgh4;
            zcosg = (CalculusFieldElement)zero.add(this.zcosgl);
            zsing = (CalculusFieldElement)zero.add(this.zsingl);
            zcosi = (CalculusFieldElement)zero.add(this.zcosil);
            zsini = (CalculusFieldElement)zero.add(this.zsinil);
            zcosh = (CalculusFieldElement)((CalculusFieldElement)cosq.multiply(this.zcoshl)).add((FieldElement)((CalculusFieldElement)sinq.multiply(this.zsinhl)));
            zsinh = (CalculusFieldElement)((CalculusFieldElement)sinq.multiply(this.zcoshl)).subtract((FieldElement)((CalculusFieldElement)cosq.multiply(this.zsinhl)));
            zn = 1.5835218E-4;
            cc = 4.7968065E-7;
            ze = 0.0549;
        }
        this.sse = (CalculusFieldElement)this.sse.add((FieldElement)se);
        this.ssi = (CalculusFieldElement)this.ssi.add((FieldElement)si);
        this.ssl = (CalculusFieldElement)this.ssl.add((FieldElement)sl);
        this.ssg = (CalculusFieldElement)((CalculusFieldElement)this.ssg.add((FieldElement)sgh)).subtract((FieldElement)(this.tle.getI().getReal() < ((CalculusFieldElement)pi.divide(60.0)).getReal() ? zero : (CalculusFieldElement)((CalculusFieldElement)this.cosi0.divide((FieldElement)this.sini0)).multiply((FieldElement)sh)));
        this.ssh = (CalculusFieldElement)this.ssh.add((FieldElement)(this.tle.getI().getReal() < ((CalculusFieldElement)pi.divide(60.0)).getReal() ? zero : (CalculusFieldElement)sh.divide((FieldElement)this.sini0)));
        CalculusFieldElement bfact = zero;
        if (this.xnq.getReal() >= 0.00826 && this.xnq.getReal() <= 0.00924 && this.tle.getE().getReal() >= 0.5) {
            CalculusFieldElement g532;
            CalculusFieldElement g521;
            CalculusFieldElement g533;
            CalculusFieldElement g520;
            CalculusFieldElement g422;
            CalculusFieldElement g410;
            CalculusFieldElement g322;
            CalculusFieldElement g310;
            CalculusFieldElement g211;
            CalculusFieldElement g201 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.tle.getE().subtract(0.64)).negate()).multiply(0.44)).add(-0.306);
            CalculusFieldElement eoc = (CalculusFieldElement)this.tle.getE().multiply((FieldElement)this.e0sq);
            CalculusFieldElement sini2 = (CalculusFieldElement)this.sini0.multiply((FieldElement)this.sini0);
            CalculusFieldElement f220 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.cosi0.multiply(2)).add((FieldElement)this.theta2)).add(1.0)).multiply(0.75);
            CalculusFieldElement f221 = (CalculusFieldElement)sini2.multiply(1.5);
            CalculusFieldElement f321 = (CalculusFieldElement)((CalculusFieldElement)this.sini0.multiply(1.875)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.cosi0.multiply(2)).negate()).subtract((FieldElement)((CalculusFieldElement)this.theta2.multiply(3)))).add(1.0)));
            CalculusFieldElement f322 = (CalculusFieldElement)((CalculusFieldElement)this.sini0.multiply(-1.875)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.cosi0.multiply(2)).subtract((FieldElement)((CalculusFieldElement)this.theta2.multiply(3)))).add(1.0)));
            CalculusFieldElement f441 = (CalculusFieldElement)((CalculusFieldElement)sini2.multiply((FieldElement)f220)).multiply(35);
            CalculusFieldElement f442 = (CalculusFieldElement)((CalculusFieldElement)sini2.multiply((FieldElement)sini2)).multiply(39.375);
            CalculusFieldElement f522 = (CalculusFieldElement)((CalculusFieldElement)this.sini0.multiply(9.84375)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sini2.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.cosi0.multiply(-2)).add((FieldElement)((CalculusFieldElement)this.theta2.multiply(-5)))).add(1.0)))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.cosi0.multiply(4.0)).add((FieldElement)((CalculusFieldElement)this.theta2.multiply(6.0)))).add(-2.0)).multiply(0.33333333)))));
            CalculusFieldElement f523 = (CalculusFieldElement)this.sini0.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sini2.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.cosi0.multiply(-4)).add((FieldElement)((CalculusFieldElement)this.theta2.multiply(10)))).add(-2.0)))).multiply(4.92187512)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.cosi0.multiply(2)).subtract((FieldElement)((CalculusFieldElement)this.theta2.multiply(3)))).add(1.0)).multiply(6.56250012)))));
            CalculusFieldElement f542 = (CalculusFieldElement)((CalculusFieldElement)this.sini0.multiply(29.53125)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.cosi0.multiply(-8)).add(2.0)).add((FieldElement)((CalculusFieldElement)this.theta2.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.cosi0.multiply(8)).add((FieldElement)((CalculusFieldElement)this.theta2.multiply(10)))).add(-12.0)))))));
            CalculusFieldElement f543 = (CalculusFieldElement)((CalculusFieldElement)this.sini0.multiply(29.53125)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.cosi0.multiply(-8)).add(-2.0)).add((FieldElement)((CalculusFieldElement)this.theta2.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.cosi0.multiply(8)).subtract((FieldElement)((CalculusFieldElement)this.theta2.multiply(10)))).add(12.0)))))));
            this.resonant = true;
            this.synchronous = false;
            if (this.tle.getE().getReal() <= 0.65) {
                g211 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.tle.getE().multiply(-13.247)).add((FieldElement)((CalculusFieldElement)this.e0sq.multiply(16.29)))).add(3.616);
                g310 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.tle.getE().multiply(117.39)).add((FieldElement)((CalculusFieldElement)this.e0sq.multiply(-228.419)))).add((FieldElement)((CalculusFieldElement)eoc.multiply(156.591)))).add(-19.302);
                g322 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.tle.getE().multiply(109.7927)).add((FieldElement)((CalculusFieldElement)this.e0sq.multiply(-214.6334)))).add((FieldElement)((CalculusFieldElement)eoc.multiply(146.5816)))).add(-18.9068);
                g410 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.tle.getE().multiply(242.694)).add((FieldElement)((CalculusFieldElement)this.e0sq.multiply(-471.094)))).add((FieldElement)((CalculusFieldElement)eoc.multiply(313.953)))).add(-41.122);
                g422 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.tle.getE().multiply(841.88)).add((FieldElement)((CalculusFieldElement)this.e0sq.multiply(-1629.014)))).add((FieldElement)((CalculusFieldElement)eoc.multiply(1083.435)))).add(-146.407);
                g520 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.tle.getE().multiply(3017.977)).add((FieldElement)((CalculusFieldElement)this.e0sq.multiply(-5740.032)))).add((FieldElement)((CalculusFieldElement)eoc.multiply(3708.276)))).add(-532.114);
            } else {
                g211 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.tle.getE().multiply(331.819)).add((FieldElement)((CalculusFieldElement)this.e0sq.multiply(-508.738)))).add((FieldElement)((CalculusFieldElement)eoc.multiply(266.724)))).add(-72.099);
                g310 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.tle.getE().multiply(1582.851)).add((FieldElement)((CalculusFieldElement)this.e0sq.multiply(-2415.925)))).add((FieldElement)((CalculusFieldElement)eoc.multiply(1246.113)))).add(-346.844);
                g322 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.tle.getE().multiply(1554.908)).add((FieldElement)((CalculusFieldElement)this.e0sq.multiply(-2366.899)))).add((FieldElement)((CalculusFieldElement)eoc.multiply(1215.972)))).add(-342.585);
                g410 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.tle.getE().multiply(4758.686)).add((FieldElement)((CalculusFieldElement)this.e0sq.multiply(-7193.992)))).add((FieldElement)((CalculusFieldElement)eoc.multiply(3651.957)))).add(-1052.797);
                g422 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.tle.getE().multiply(16178.11)).add((FieldElement)((CalculusFieldElement)this.e0sq.multiply(-24462.77)))).add((FieldElement)((CalculusFieldElement)eoc.multiply(12422.52)))).add(-3581.69);
                g520 = this.tle.getE().getReal() <= 0.715 ? (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.tle.getE().multiply(-4664.75)).add((FieldElement)((CalculusFieldElement)this.e0sq.multiply(3763.64)))).add(1464.74) : (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.tle.getE().multiply(29936.92)).add((FieldElement)((CalculusFieldElement)this.e0sq.multiply(-54087.36)))).add((FieldElement)((CalculusFieldElement)eoc.multiply(31324.56)))).add(-5149.66);
            }
            if (this.tle.getE().getReal() < 0.7) {
                g533 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.tle.getE().multiply(4988.61)).add((FieldElement)((CalculusFieldElement)this.e0sq.multiply(-9064.77)))).add((FieldElement)((CalculusFieldElement)eoc.multiply(5542.21)))).add(-919.2277);
                g521 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.tle.getE().multiply(4568.6173)).add((FieldElement)((CalculusFieldElement)this.e0sq.multiply(-8491.4146)))).add((FieldElement)((CalculusFieldElement)eoc.multiply(5337.524)))).add(-822.71072);
                g532 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.tle.getE().multiply(4690.25)).add((FieldElement)((CalculusFieldElement)this.e0sq.multiply(-8624.77)))).add((FieldElement)((CalculusFieldElement)eoc.multiply(5341.4)))).add(-853.666);
            } else {
                g533 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.tle.getE().multiply(161616.52)).add((FieldElement)((CalculusFieldElement)this.e0sq.multiply(-229838.2)))).add((FieldElement)((CalculusFieldElement)eoc.multiply(109377.94)))).add(-37995.78);
                g521 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.tle.getE().multiply(218913.95)).add((FieldElement)((CalculusFieldElement)this.e0sq.multiply(-309468.16)))).add((FieldElement)((CalculusFieldElement)eoc.multiply(146349.42)))).add(-51752.104);
                g532 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.tle.getE().multiply(170470.89)).add((FieldElement)((CalculusFieldElement)this.e0sq.multiply(-242699.48)))).add((FieldElement)((CalculusFieldElement)eoc.multiply(115605.82)))).add(-40023.88);
            }
            CalculusFieldElement temp1 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.xnq.multiply(this.xnq)).multiply((FieldElement)aqnv)).multiply((FieldElement)aqnv)).multiply(3);
            CalculusFieldElement temp = (CalculusFieldElement)temp1.multiply(1.7891679E-6);
            this.d2201 = (CalculusFieldElement)((CalculusFieldElement)temp.multiply((FieldElement)f220)).multiply((FieldElement)g201);
            this.d2211 = (CalculusFieldElement)((CalculusFieldElement)temp.multiply((FieldElement)f221)).multiply((FieldElement)g211);
            temp1 = (CalculusFieldElement)temp1.multiply((FieldElement)aqnv);
            temp = (CalculusFieldElement)temp1.multiply(3.7393792E-7);
            this.d3210 = (CalculusFieldElement)((CalculusFieldElement)temp.multiply((FieldElement)f321)).multiply((FieldElement)g310);
            this.d3222 = (CalculusFieldElement)((CalculusFieldElement)temp.multiply((FieldElement)f322)).multiply((FieldElement)g322);
            temp1 = (CalculusFieldElement)temp1.multiply((FieldElement)aqnv);
            temp = (CalculusFieldElement)temp1.multiply(1.47273906E-8);
            this.d4410 = (CalculusFieldElement)((CalculusFieldElement)temp.multiply((FieldElement)f441)).multiply((FieldElement)g410);
            this.d4422 = (CalculusFieldElement)((CalculusFieldElement)temp.multiply((FieldElement)f442)).multiply((FieldElement)g422);
            temp1 = (CalculusFieldElement)temp1.multiply((FieldElement)aqnv);
            temp = (CalculusFieldElement)temp1.multiply(1.1428639E-7);
            this.d5220 = (CalculusFieldElement)((CalculusFieldElement)temp.multiply((FieldElement)f522)).multiply((FieldElement)g520);
            this.d5232 = (CalculusFieldElement)((CalculusFieldElement)temp.multiply((FieldElement)f523)).multiply((FieldElement)g532);
            temp = (CalculusFieldElement)temp1.multiply(4.3531606E-9);
            this.d5421 = (CalculusFieldElement)((CalculusFieldElement)temp.multiply((FieldElement)f542)).multiply((FieldElement)g521);
            this.d5433 = (CalculusFieldElement)((CalculusFieldElement)temp.multiply((FieldElement)f543)).multiply((FieldElement)g533);
            this.xlamo = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.tle.getMeanAnomaly().add(this.tle.getRaan())).add(this.tle.getRaan())).subtract(this.thgr + this.thgr);
            bfact = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.xmdot.add((FieldElement)this.xnodot)).add((FieldElement)this.xnodot)).subtract(0.0087505382);
            bfact = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)bfact.add(this.ssl)).add(this.ssh)).add(this.ssh);
        } else if (this.xnq.getReal() < 0.0052359877 && this.xnq.getReal() > 0.0034906585) {
            CalculusFieldElement cosio_plus_1 = (CalculusFieldElement)this.cosi0.add(1.0);
            CalculusFieldElement g200 = (CalculusFieldElement)((CalculusFieldElement)this.e0sq.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.e0sq.multiply(0.8125)).add(-2.5)))).add(1.0);
            CalculusFieldElement g300 = (CalculusFieldElement)((CalculusFieldElement)this.e0sq.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.e0sq.multiply(6.60937)).add(-6.0)))).add(1.0);
            CalculusFieldElement f311 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.sini0.multiply(0.9375)).multiply((FieldElement)((CalculusFieldElement)this.sini0.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.cosi0.multiply(3)).add(1.0)))))).subtract((FieldElement)((CalculusFieldElement)cosio_plus_1.multiply(0.75)));
            CalculusFieldElement g310 = (CalculusFieldElement)((CalculusFieldElement)this.e0sq.multiply(2)).add(1.0);
            CalculusFieldElement f220 = (CalculusFieldElement)((CalculusFieldElement)cosio_plus_1.multiply((FieldElement)cosio_plus_1)).multiply(0.75);
            CalculusFieldElement f330 = (CalculusFieldElement)((CalculusFieldElement)f220.multiply((FieldElement)cosio_plus_1)).multiply(2.5);
            this.resonant = true;
            this.synchronous = true;
            this.del1 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.xnq.multiply(this.xnq)).multiply((FieldElement)aqnv)).multiply((FieldElement)aqnv)).multiply(3);
            this.del2 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.del1.multiply((FieldElement)f220)).multiply((FieldElement)g200)).multiply(3.5783358E-6);
            this.del3 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.del1.multiply((FieldElement)f330)).multiply((FieldElement)g300)).multiply((FieldElement)aqnv)).multiply(6.6369045E-7);
            this.del1 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.del1.multiply((FieldElement)f311)).multiply((FieldElement)g310)).multiply(2.1460748E-6)).multiply((FieldElement)aqnv);
            this.xlamo = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.tle.getMeanAnomaly().add(this.tle.getRaan())).add(this.tle.getPerigeeArgument())).subtract(this.thgr);
            bfact = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.xmdot.add((FieldElement)this.omgdot)).add((FieldElement)this.xnodot)).subtract(0.0043752691);
            bfact = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)bfact.add(this.ssl)).add(this.ssg)).add(this.ssh);
        } else {
            this.resonant = false;
            this.synchronous = false;
        }
        if (this.resonant) {
            this.xfact = (CalculusFieldElement)bfact.subtract(this.xnq);
            this.xli = this.xlamo;
            this.xni = this.xnq;
            this.atime = zero;
        }
        this.derivs = (CalculusFieldElement[])MathArrays.buildArray((Field)this.xnq.getField(), (int)2);
    }

    @Override
    protected void deepSecularEffects(T t) {
        this.xll = (CalculusFieldElement)this.xll.add((FieldElement)((CalculusFieldElement)this.ssl.multiply(t)));
        this.omgadf = (CalculusFieldElement)this.omgadf.add((FieldElement)((CalculusFieldElement)this.ssg.multiply(t)));
        this.xnode = (CalculusFieldElement)this.xnode.add((FieldElement)((CalculusFieldElement)this.ssh.multiply(t)));
        this.em = (CalculusFieldElement)this.tle.getE().add((FieldElement)((CalculusFieldElement)this.sse.multiply(t)));
        this.xinc = (CalculusFieldElement)this.tle.getI().add((FieldElement)((CalculusFieldElement)this.ssi.multiply(t)));
        if (this.resonant) {
            if (FastMath.abs(t).getReal() < FastMath.abs((CalculusFieldElement)((CalculusFieldElement)t.subtract(this.atime))).getReal() || this.isDundeeCompliant) {
                this.atime = (CalculusFieldElement)t.getField().getZero();
                this.xni = this.xnq;
                this.xli = this.xlamo;
            }
            boolean lastIntegrationStep = false;
            while (!lastIntegrationStep) {
                double delt = ((CalculusFieldElement)t.subtract(this.atime)).getReal();
                if (delt > 720.0) {
                    delt = 720.0;
                } else if (delt < -720.0) {
                    delt = -720.0;
                } else {
                    lastIntegrationStep = true;
                }
                this.computeSecularDerivs();
                CalculusFieldElement xldot = (CalculusFieldElement)this.xni.add(this.xfact);
                CalculusFieldElement xlpow = (CalculusFieldElement)((CalculusFieldElement)t.getField().getZero()).add(1.0);
                this.xli = (CalculusFieldElement)this.xli.add((FieldElement)((CalculusFieldElement)xldot.multiply(delt)));
                this.xni = (CalculusFieldElement)this.xni.add((FieldElement)((CalculusFieldElement)this.derivs[0].multiply(delt)));
                double delt_factor = delt;
                xlpow = (CalculusFieldElement)xlpow.multiply((FieldElement)xldot);
                this.derivs[1] = (CalculusFieldElement)this.derivs[1].multiply((FieldElement)xlpow);
                this.xli = (CalculusFieldElement)this.xli.add((FieldElement)((CalculusFieldElement)this.derivs[0].multiply(delt_factor *= delt / 2.0)));
                this.xni = (CalculusFieldElement)this.xni.add((FieldElement)((CalculusFieldElement)this.derivs[1].multiply(delt_factor)));
                this.atime = (CalculusFieldElement)this.atime.add(delt);
            }
            this.xn = this.xni;
            CalculusFieldElement temp = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.xnode.negate()).add(this.thgr)).add((FieldElement)((CalculusFieldElement)t.multiply(0.0043752691)));
            this.xll = (CalculusFieldElement)((CalculusFieldElement)this.xli.add((FieldElement)temp)).add((FieldElement)(this.synchronous ? (CalculusFieldElement)this.omgadf.negate() : temp));
        }
    }

    @Override
    protected void deepPeriodicEffects(T t) {
        if (FastMath.abs((double)((CalculusFieldElement)this.savtsn.subtract(t)).getReal()) >= 30.0 || this.isDundeeCompliant) {
            this.savtsn = t;
            CalculusFieldElement zm = (CalculusFieldElement)((CalculusFieldElement)t.multiply(1.19459E-5)).add(this.zmos);
            CalculusFieldElement zf = (CalculusFieldElement)zm.add((FieldElement)((CalculusFieldElement)FastMath.sin((CalculusFieldElement)zm).multiply(0.0335)));
            FieldSinCos sczf = FastMath.sinCos((CalculusFieldElement)zf);
            CalculusFieldElement sinzf = (CalculusFieldElement)sczf.sin();
            CalculusFieldElement f2 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sinzf.multiply((FieldElement)sinzf)).multiply(0.5)).subtract(0.25);
            CalculusFieldElement f3 = (CalculusFieldElement)((CalculusFieldElement)sinzf.multiply((FieldElement)((CalculusFieldElement)sczf.cos()))).multiply(-0.5);
            CalculusFieldElement ses = (CalculusFieldElement)((CalculusFieldElement)this.se2.multiply((FieldElement)f2)).add((FieldElement)((CalculusFieldElement)this.se3.multiply((FieldElement)f3)));
            CalculusFieldElement sis = (CalculusFieldElement)((CalculusFieldElement)this.si2.multiply((FieldElement)f2)).add((FieldElement)((CalculusFieldElement)this.si3.multiply((FieldElement)f3)));
            CalculusFieldElement sls = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.sl2.multiply((FieldElement)f2)).add((FieldElement)((CalculusFieldElement)this.sl3.multiply((FieldElement)f3)))).add((FieldElement)((CalculusFieldElement)this.sl4.multiply((FieldElement)sinzf)));
            CalculusFieldElement sghs = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.sgh2.multiply((FieldElement)f2)).add((FieldElement)((CalculusFieldElement)this.sgh3.multiply((FieldElement)f3)))).add((FieldElement)((CalculusFieldElement)this.sgh4.multiply((FieldElement)sinzf)));
            CalculusFieldElement shs = (CalculusFieldElement)((CalculusFieldElement)this.sh2.multiply((FieldElement)f2)).add((FieldElement)((CalculusFieldElement)this.sh3.multiply((FieldElement)f3)));
            zm = (CalculusFieldElement)((CalculusFieldElement)t.multiply(1.5835218E-4)).add(this.zmol);
            zf = (CalculusFieldElement)zm.add((FieldElement)((CalculusFieldElement)FastMath.sin((CalculusFieldElement)zm).multiply(0.1098)));
            sczf = FastMath.sinCos((CalculusFieldElement)zf);
            sinzf = (CalculusFieldElement)sczf.sin();
            f2 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sinzf.multiply((FieldElement)sinzf)).multiply(0.5)).subtract(0.25);
            f3 = (CalculusFieldElement)((CalculusFieldElement)sinzf.multiply((FieldElement)((CalculusFieldElement)sczf.cos()))).multiply(-0.5);
            CalculusFieldElement sel = (CalculusFieldElement)((CalculusFieldElement)this.ee2.multiply((FieldElement)f2)).add((FieldElement)((CalculusFieldElement)this.e3.multiply((FieldElement)f3)));
            CalculusFieldElement sil = (CalculusFieldElement)((CalculusFieldElement)this.xi2.multiply((FieldElement)f2)).add((FieldElement)((CalculusFieldElement)this.xi3.multiply((FieldElement)f3)));
            CalculusFieldElement sll = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.xl2.multiply((FieldElement)f2)).add((FieldElement)((CalculusFieldElement)this.xl3.multiply((FieldElement)f3)))).add((FieldElement)((CalculusFieldElement)this.xl4.multiply((FieldElement)sinzf)));
            CalculusFieldElement sghl = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.xgh2.multiply((FieldElement)f2)).add((FieldElement)((CalculusFieldElement)this.xgh3.multiply((FieldElement)f3)))).add((FieldElement)((CalculusFieldElement)this.xgh4.multiply((FieldElement)sinzf)));
            CalculusFieldElement sh1 = (CalculusFieldElement)((CalculusFieldElement)this.xh2.multiply((FieldElement)f2)).add((FieldElement)((CalculusFieldElement)this.xh3.multiply((FieldElement)f3)));
            this.pe = (CalculusFieldElement)ses.add((FieldElement)sel);
            this.pinc = (CalculusFieldElement)sis.add((FieldElement)sil);
            this.pl = (CalculusFieldElement)sls.add((FieldElement)sll);
            this.pgh = (CalculusFieldElement)sghs.add((FieldElement)sghl);
            this.ph = (CalculusFieldElement)shs.add((FieldElement)sh1);
        }
        this.xinc = (CalculusFieldElement)this.xinc.add(this.pinc);
        FieldSinCos scis = FastMath.sinCos((CalculusFieldElement)this.xinc);
        CalculusFieldElement sinis = (CalculusFieldElement)scis.sin();
        CalculusFieldElement cosis = (CalculusFieldElement)scis.cos();
        this.em = (CalculusFieldElement)this.em.add(this.pe);
        this.xll = (CalculusFieldElement)this.xll.add(this.pl);
        this.omgadf = (CalculusFieldElement)this.omgadf.add(this.pgh);
        this.xinc = MathUtils.normalizeAngle((CalculusFieldElement)this.xinc, (CalculusFieldElement)((CalculusFieldElement)t.getField().getZero()));
        if (FastMath.abs((CalculusFieldElement)this.xinc).getReal() >= 0.2) {
            CalculusFieldElement temp_val = (CalculusFieldElement)this.ph.divide((FieldElement)sinis);
            this.omgadf = (CalculusFieldElement)this.omgadf.subtract((FieldElement)((CalculusFieldElement)cosis.multiply((FieldElement)temp_val)));
            this.xnode = (CalculusFieldElement)this.xnode.add((FieldElement)temp_val);
        } else {
            FieldSinCos scok = FastMath.sinCos((CalculusFieldElement)this.xnode);
            CalculusFieldElement sinok = (CalculusFieldElement)scok.sin();
            CalculusFieldElement cosok = (CalculusFieldElement)scok.cos();
            CalculusFieldElement alfdp = (CalculusFieldElement)((CalculusFieldElement)this.ph.multiply((FieldElement)cosok)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.pinc.multiply((FieldElement)cosis)).add((FieldElement)sinis)).multiply((FieldElement)sinok)));
            CalculusFieldElement betdp = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.ph.negate()).multiply((FieldElement)sinok)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.pinc.multiply((FieldElement)cosis)).add((FieldElement)sinis)).multiply((FieldElement)cosok)));
            CalculusFieldElement delta_xnode = MathUtils.normalizeAngle((CalculusFieldElement)((CalculusFieldElement)FastMath.atan2((CalculusFieldElement)alfdp, (CalculusFieldElement)betdp).subtract((FieldElement)this.xnode)), (CalculusFieldElement)((CalculusFieldElement)t.getField().getZero()));
            CalculusFieldElement dls = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.xnode.negate()).multiply((FieldElement)sinis)).multiply(this.pinc);
            this.omgadf = (CalculusFieldElement)this.omgadf.add((FieldElement)((CalculusFieldElement)dls.subtract((FieldElement)((CalculusFieldElement)cosis.multiply((FieldElement)delta_xnode)))));
            this.xnode = (CalculusFieldElement)this.xnode.add((FieldElement)delta_xnode);
        }
    }

    private void computeSecularDerivs() {
        FieldSinCos sc_li = FastMath.sinCos(this.xli);
        CalculusFieldElement sin_li = (CalculusFieldElement)sc_li.sin();
        CalculusFieldElement cos_li = (CalculusFieldElement)sc_li.cos();
        CalculusFieldElement sin_2li = (CalculusFieldElement)((CalculusFieldElement)sin_li.multiply((FieldElement)cos_li)).multiply(2.0);
        CalculusFieldElement cos_2li = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)cos_li.multiply((FieldElement)cos_li)).multiply(2.0)).subtract(1.0);
        if (this.synchronous) {
            CalculusFieldElement sin_3li = (CalculusFieldElement)((CalculusFieldElement)sin_2li.multiply((FieldElement)cos_li)).add((FieldElement)((CalculusFieldElement)cos_2li.multiply((FieldElement)sin_li)));
            CalculusFieldElement cos_3li = (CalculusFieldElement)((CalculusFieldElement)cos_2li.multiply((FieldElement)cos_li)).subtract((FieldElement)((CalculusFieldElement)sin_2li.multiply((FieldElement)sin_li)));
            CalculusFieldElement term1a = (CalculusFieldElement)this.del1.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sin_li.multiply(0.9913913426848859)).subtract((FieldElement)((CalculusFieldElement)cos_li.multiply(0.130932065016401)))));
            CalculusFieldElement term2a = (CalculusFieldElement)this.del2.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sin_2li.multiply(0.8705163875297294)).subtract((FieldElement)((CalculusFieldElement)cos_2li.multiply(-0.49213943048915526)))));
            CalculusFieldElement term3a = (CalculusFieldElement)this.del3.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sin_3li.multiply(0.43258117585763334)).subtract((FieldElement)((CalculusFieldElement)cos_3li.multiply(0.9015949901666642)))));
            CalculusFieldElement term1b = (CalculusFieldElement)this.del1.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)cos_li.multiply(0.9913913426848859)).add((FieldElement)((CalculusFieldElement)sin_li.multiply(0.130932065016401)))));
            CalculusFieldElement term2b = (CalculusFieldElement)((CalculusFieldElement)this.del2.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)cos_2li.multiply(0.8705163875297294)).add((FieldElement)((CalculusFieldElement)sin_2li.multiply(-0.49213943048915526)))))).multiply(2.0);
            CalculusFieldElement term3b = (CalculusFieldElement)((CalculusFieldElement)this.del3.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)cos_3li.multiply(0.43258117585763334)).add((FieldElement)((CalculusFieldElement)sin_3li.multiply(0.9015949901666642)))))).multiply(3.0);
            this.derivs[0] = (CalculusFieldElement)((CalculusFieldElement)term1a.add((FieldElement)term2a)).add((FieldElement)term3a);
            this.derivs[1] = (CalculusFieldElement)((CalculusFieldElement)term1b.add((FieldElement)term2b)).add((FieldElement)term3b);
        } else {
            CalculusFieldElement xomi = (CalculusFieldElement)this.omegaq.add((FieldElement)((CalculusFieldElement)this.omgdot.multiply(this.atime)));
            FieldSinCos sc_omi = FastMath.sinCos((CalculusFieldElement)xomi);
            CalculusFieldElement sin_omi = (CalculusFieldElement)sc_omi.sin();
            CalculusFieldElement cos_omi = (CalculusFieldElement)sc_omi.cos();
            CalculusFieldElement sin_li_m_omi = (CalculusFieldElement)((CalculusFieldElement)sin_li.multiply((FieldElement)cos_omi)).subtract((FieldElement)((CalculusFieldElement)sin_omi.multiply((FieldElement)cos_li)));
            CalculusFieldElement sin_li_p_omi = (CalculusFieldElement)((CalculusFieldElement)sin_li.multiply((FieldElement)cos_omi)).add((FieldElement)((CalculusFieldElement)sin_omi.multiply((FieldElement)cos_li)));
            CalculusFieldElement cos_li_m_omi = (CalculusFieldElement)((CalculusFieldElement)cos_li.multiply((FieldElement)cos_omi)).add((FieldElement)((CalculusFieldElement)sin_omi.multiply((FieldElement)sin_li)));
            CalculusFieldElement cos_li_p_omi = (CalculusFieldElement)((CalculusFieldElement)cos_li.multiply((FieldElement)cos_omi)).subtract((FieldElement)((CalculusFieldElement)sin_omi.multiply((FieldElement)sin_li)));
            CalculusFieldElement sin_2omi = (CalculusFieldElement)((CalculusFieldElement)sin_omi.multiply((FieldElement)cos_omi)).multiply(2.0);
            CalculusFieldElement cos_2omi = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)cos_omi.multiply((FieldElement)cos_omi)).multiply(2.0)).subtract(1.0);
            CalculusFieldElement sin_2li_m_omi = (CalculusFieldElement)((CalculusFieldElement)sin_2li.multiply((FieldElement)cos_omi)).subtract((FieldElement)((CalculusFieldElement)sin_omi.multiply((FieldElement)cos_2li)));
            CalculusFieldElement sin_2li_p_omi = (CalculusFieldElement)((CalculusFieldElement)sin_2li.multiply((FieldElement)cos_omi)).add((FieldElement)((CalculusFieldElement)sin_omi.multiply((FieldElement)cos_2li)));
            CalculusFieldElement cos_2li_m_omi = (CalculusFieldElement)((CalculusFieldElement)cos_2li.multiply((FieldElement)cos_omi)).add((FieldElement)((CalculusFieldElement)sin_omi.multiply((FieldElement)sin_2li)));
            CalculusFieldElement cos_2li_p_omi = (CalculusFieldElement)((CalculusFieldElement)cos_2li.multiply((FieldElement)cos_omi)).subtract((FieldElement)((CalculusFieldElement)sin_omi.multiply((FieldElement)sin_2li)));
            CalculusFieldElement sin_2li_p_2omi = (CalculusFieldElement)((CalculusFieldElement)sin_2li.multiply((FieldElement)cos_2omi)).add((FieldElement)((CalculusFieldElement)sin_2omi.multiply((FieldElement)cos_2li)));
            CalculusFieldElement cos_2li_p_2omi = (CalculusFieldElement)((CalculusFieldElement)cos_2li.multiply((FieldElement)cos_2omi)).subtract((FieldElement)((CalculusFieldElement)sin_2omi.multiply((FieldElement)sin_2li)));
            CalculusFieldElement sin_2omi_p_li = (CalculusFieldElement)((CalculusFieldElement)sin_li.multiply((FieldElement)cos_2omi)).add((FieldElement)((CalculusFieldElement)sin_2omi.multiply((FieldElement)cos_li)));
            CalculusFieldElement cos_2omi_p_li = (CalculusFieldElement)((CalculusFieldElement)cos_li.multiply((FieldElement)cos_2omi)).subtract((FieldElement)((CalculusFieldElement)sin_2omi.multiply((FieldElement)sin_li)));
            CalculusFieldElement term1a = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.d2201.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sin_2omi_p_li.multiply(0.8705163875297294)).subtract((FieldElement)((CalculusFieldElement)cos_2omi_p_li.multiply(-0.49213943048915526)))))).add((FieldElement)((CalculusFieldElement)this.d2211.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sin_li.multiply(0.8705163875297294)).subtract((FieldElement)((CalculusFieldElement)cos_li.multiply(-0.49213943048915526)))))))).add((FieldElement)((CalculusFieldElement)this.d3210.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sin_li_p_omi.multiply(0.5797219018700115)).subtract((FieldElement)((CalculusFieldElement)cos_li_p_omi.multiply(0.8148144061638924)))))))).add((FieldElement)((CalculusFieldElement)this.d3222.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sin_li_m_omi.multiply(0.5797219018700115)).subtract((FieldElement)((CalculusFieldElement)cos_li_m_omi.multiply(0.8148144061638924)))))))).add((FieldElement)((CalculusFieldElement)this.d5220.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sin_li_p_omi.multiply(0.496848311798842)).subtract((FieldElement)((CalculusFieldElement)cos_li_p_omi.multiply(0.8678374012812773)))))))).add((FieldElement)((CalculusFieldElement)this.d5232.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sin_li_m_omi.multiply(0.496848311798842)).subtract((FieldElement)((CalculusFieldElement)cos_li_m_omi.multiply(0.8678374012812773)))))));
            CalculusFieldElement term2a = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.d4410.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sin_2li_p_2omi.multiply(-0.22866241528815548)).subtract((FieldElement)((CalculusFieldElement)cos_2li_p_2omi.multiply(0.9735057780180799)))))).add((FieldElement)((CalculusFieldElement)this.d4422.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sin_2li.multiply(-0.22866241528815548)).subtract((FieldElement)((CalculusFieldElement)cos_2li.multiply(0.9735057780180799)))))))).add((FieldElement)((CalculusFieldElement)this.d5421.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sin_2li_p_omi.multiply(-0.29695209575316894)).subtract((FieldElement)((CalculusFieldElement)cos_2li_p_omi.multiply(-0.9548923776153)))))))).add((FieldElement)((CalculusFieldElement)this.d5433.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sin_2li_m_omi.multiply(-0.29695209575316894)).subtract((FieldElement)((CalculusFieldElement)cos_2li_m_omi.multiply(-0.9548923776153)))))));
            CalculusFieldElement term1b = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.d2201.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)cos_2omi_p_li.multiply(0.8705163875297294)).add((FieldElement)((CalculusFieldElement)sin_2omi_p_li.multiply(-0.49213943048915526)))))).add((FieldElement)((CalculusFieldElement)this.d2211.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)cos_li.multiply(0.8705163875297294)).add((FieldElement)((CalculusFieldElement)sin_li.multiply(-0.49213943048915526)))))))).add((FieldElement)((CalculusFieldElement)this.d3210.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)cos_li_p_omi.multiply(0.5797219018700115)).add((FieldElement)((CalculusFieldElement)sin_li_p_omi.multiply(0.8148144061638924)))))))).add((FieldElement)((CalculusFieldElement)this.d3222.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)cos_li_m_omi.multiply(0.5797219018700115)).add((FieldElement)((CalculusFieldElement)sin_li_m_omi.multiply(0.8148144061638924)))))))).add((FieldElement)((CalculusFieldElement)this.d5220.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)cos_li_p_omi.multiply(0.496848311798842)).add((FieldElement)((CalculusFieldElement)sin_li_p_omi.multiply(0.8678374012812773)))))))).add((FieldElement)((CalculusFieldElement)this.d5232.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)cos_li_m_omi.multiply(0.496848311798842)).add((FieldElement)((CalculusFieldElement)sin_li_m_omi.multiply(0.8678374012812773)))))));
            CalculusFieldElement term2b = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.d4410.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)cos_2li_p_2omi.multiply(-0.22866241528815548)).add((FieldElement)((CalculusFieldElement)sin_2li_p_2omi.multiply(0.9735057780180799)))))).add((FieldElement)((CalculusFieldElement)this.d4422.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)cos_2li.multiply(-0.22866241528815548)).add((FieldElement)((CalculusFieldElement)sin_2li.multiply(0.9735057780180799)))))))).add((FieldElement)((CalculusFieldElement)this.d5421.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)cos_2li_p_omi.multiply(-0.29695209575316894)).add((FieldElement)((CalculusFieldElement)sin_2li_p_omi.multiply(-0.9548923776153)))))))).add((FieldElement)((CalculusFieldElement)this.d5433.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)cos_2li_m_omi.multiply(-0.29695209575316894)).add((FieldElement)((CalculusFieldElement)sin_2li_m_omi.multiply(-0.9548923776153)))))))).multiply(2.0);
            this.derivs[0] = (CalculusFieldElement)term1a.add((FieldElement)term2a);
            this.derivs[1] = (CalculusFieldElement)term1b.add((FieldElement)term2b);
        }
    }
}

