/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical;

import java.util.Collections;
import java.util.List;
import org.hipparchus.analysis.differentiation.Gradient;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.analytical.AbstractAnalyticalGradientConverter;
import org.orekit.propagation.analytical.EcksteinHechlerPropagator;
import org.orekit.propagation.analytical.FieldEcksteinHechlerPropagator;
import org.orekit.utils.ParameterDriver;

class EcksteinHechlerGradientConverter
extends AbstractAnalyticalGradientConverter {
    public static final int FREE_STATE_PARAMETERS = 6;
    private final EcksteinHechlerPropagator propagator;

    EcksteinHechlerGradientConverter(EcksteinHechlerPropagator propagator) {
        super(propagator, propagator.getMu(), 6);
        this.propagator = propagator;
    }

    public FieldEcksteinHechlerPropagator<Gradient> getPropagator(FieldSpacecraftState<Gradient> state, Gradient[] parameters) {
        Gradient zero = state.getA().getField().getZero();
        double[] ck0 = this.propagator.getCk0();
        double radius = this.propagator.getReferenceRadius();
        AttitudeProvider provider = this.propagator.getAttitudeProvider();
        Gradient mu = zero.add(this.propagator.getMu());
        return new FieldEcksteinHechlerPropagator<Gradient>(state.getOrbit(), provider, radius, mu, ck0[2], ck0[3], ck0[4], ck0[5], ck0[6]);
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }
}

