/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation;

import java.util.List;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.orekit.propagation.MatricesHarvester;
import org.orekit.propagation.SpacecraftState;
import org.orekit.utils.DoubleArrayDictionary;

public abstract class AbstractMatricesHarvester
implements MatricesHarvester {
    public static final int STATE_DIMENSION = 6;
    private static final double[][] IDENTITY = new double[][]{{1.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
    private final RealMatrix initialStm;
    private final DoubleArrayDictionary initialJacobianColumns;
    private final String stmName;

    protected AbstractMatricesHarvester(String stmName, RealMatrix initialStm, DoubleArrayDictionary initialJacobianColumns) {
        this.stmName = stmName;
        this.initialStm = initialStm == null ? MatrixUtils.createRealIdentityMatrix((int)6) : initialStm;
        this.initialJacobianColumns = initialJacobianColumns == null ? new DoubleArrayDictionary() : initialJacobianColumns;
    }

    public String getStmName() {
        return this.stmName;
    }

    public RealMatrix getInitialStateTransitionMatrix() {
        return this.initialStm;
    }

    public double[] getInitialJacobianColumn(String columnName) {
        DoubleArrayDictionary.Entry entry = this.initialJacobianColumns.getEntry(columnName);
        return entry == null ? new double[6] : entry.getValue();
    }

    protected double[][] getConversionJacobian(SpacecraftState state) {
        return IDENTITY;
    }

    @Override
    public void setReferenceState(SpacecraftState reference) {
    }

    @Override
    public RealMatrix getStateTransitionMatrix(SpacecraftState state) {
        if (!state.hasAdditionalState(this.stmName)) {
            return null;
        }
        double[][] dYdC = this.getConversionJacobian(state);
        double[] p = state.getAdditionalState(this.stmName);
        RealMatrix dYdY0 = MatrixUtils.createRealMatrix((int)6, (int)6);
        for (int i = 0; i < 6; ++i) {
            double[] rowC = dYdC[i];
            for (int j = 0; j < 6; ++j) {
                double sum = 0.0;
                int pIndex = j;
                for (int k = 0; k < 6; ++k) {
                    sum += rowC[k] * p[pIndex];
                    pIndex += 6;
                }
                dYdY0.setEntry(i, j, sum);
            }
        }
        return dYdY0;
    }

    @Override
    public RealMatrix getParametersJacobian(SpacecraftState state) {
        List<String> columnsNames = this.getJacobiansColumnsNames();
        if (columnsNames == null || columnsNames.isEmpty()) {
            return null;
        }
        double[][] dYdC = this.getConversionJacobian(state);
        RealMatrix dYdP = MatrixUtils.createRealMatrix((int)6, (int)columnsNames.size());
        for (int j = 0; j < columnsNames.size(); ++j) {
            double[] p = state.getAdditionalState(columnsNames.get(j));
            for (int i = 0; i < 6; ++i) {
                double[] dYdCi = dYdC[i];
                double sum = 0.0;
                for (int k = 0; k < 6; ++k) {
                    sum += dYdCi[k] * p[k];
                }
                dYdP.setEntry(i, j, sum);
            }
        }
        return dYdP;
    }

    public abstract void freezeColumnsNames();
}

