/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.orbits;

import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.SinCos;
import org.orekit.bodies.CR3BPSystem;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.orbits.LibrationOrbitFamily;
import org.orekit.utils.LagrangianPoints;
import org.orekit.utils.PVCoordinates;

public class RichardsonExpansion {
    private final double gamma;
    private final double mu;
    private final double dDim;
    private final double wp;
    private final double k;
    private final double a21;
    private final double a22;
    private final double a23;
    private final double a24;
    private final double b21;
    private final double b22;
    private final double d21;
    private final double a31;
    private final double a32;
    private final double b31;
    private final double b32;
    private final double d31;
    private final double d32;
    private final double s1;
    private final double s2;
    private final double l1;
    private final double l2;
    private final double delta;
    private double orbitalPeriod;
    private LagrangianPoints point;
    private CR3BPSystem cr3bpSystem;

    public RichardsonExpansion(CR3BPSystem cr3bpSystem, LagrangianPoints point) {
        this.point = point;
        this.cr3bpSystem = cr3bpSystem;
        this.mu = cr3bpSystem.getMassRatio();
        this.dDim = cr3bpSystem.getDdim();
        this.gamma = cr3bpSystem.getGamma(point);
        double c2 = this.getCn(2.0);
        double c3 = this.getCn(3.0);
        double c4 = this.getCn(4.0);
        this.wp = FastMath.sqrt((double)(0.5 * (2.0 - c2 + FastMath.sqrt((double)(9.0 * c2 * c2 - 8.0 * c2)))));
        double ld = FastMath.sqrt((double)(0.5 * (2.0 - c2 + FastMath.sqrt((double)(9.0 * c2 * c2 - 8.0 * c2)))));
        this.k = (this.wp * this.wp + 1.0 + 2.0 * c2) / (2.0 * this.wp);
        double d1 = 3.0 * ld * ld * (this.k * (6.0 * ld * ld - 1.0) - 2.0 * ld) / this.k;
        double d2 = 8.0 * ld * ld * (this.k * (11.0 * ld * ld - 1.0) - 2.0 * ld) / this.k;
        this.a21 = 3.0 * c3 * (this.k * this.k - 2.0) / (4.0 * (1.0 + 2.0 * c2));
        this.a22 = 3.0 * c3 / (4.0 * (1.0 + 2.0 * c2));
        this.a23 = -3.0 * c3 * ld * (3.0 * this.k * this.k * this.k * ld - 6.0 * this.k * (this.k - ld) + 4.0) / (4.0 * this.k * d1);
        this.a24 = -3.0 * c3 * ld * (2.0 + 3.0 * this.k * ld) / (4.0 * this.k * d1);
        this.b21 = -3.0 * c3 * ld * (3.0 * this.k * ld - 4.0) / (2.0 * d1);
        this.b22 = 3.0 * c3 * ld / d1;
        this.d21 = -c3 / (2.0 * ld * ld);
        this.a31 = -9.0 * ld * (4.0 * c3 * (this.k * this.a23 - this.b21) + this.k * c4 * (4.0 + this.k * this.k)) / (4.0 * d2) + (9.0 * ld * ld + 1.0 - c2) / (2.0 * d2) * (2.0 * c3 * (2.0 * this.a23 - this.k * this.b21) + c4 * (2.0 + 3.0 * this.k * this.k));
        this.a32 = -9.0 * ld * (4.0 * c3 * (this.k * this.a24 - this.b22) + this.k * c4) / (4.0 * d2) - 3.0 * (9.0 * ld * ld + 1.0 - c2) * (c3 * (this.k * this.b22 + this.d21 - 2.0 * this.a24) - c4) / (2.0 * d2);
        this.b31 = 24.0 * ld * (3.0 * c3 * (this.k * this.b21 - 2.0 * this.a23) - c4 * (2.0 + 3.0 * this.k * this.k)) / (8.0 * d2) + 3.0 * ((9.0 * ld * ld + 1.0 + 2.0 * c2) * (4.0 * c3 * (this.k * this.a23 - this.b21) + this.k * c4 * (4.0 + this.k * this.k))) / (8.0 * d2);
        this.b32 = 9.0 * ld * (c3 * (this.k * this.b22 + this.d21 - 2.0 * this.a24) - c4) / d2 + 3.0 * ((9.0 * ld * ld + 1.0 + 2.0 * c2) * (4.0 * c3 * (this.k * this.a24 - this.b22) + this.k * c4)) / (8.0 * d2);
        this.d31 = 3.0 / (64.0 * ld * ld) * (4.0 * c3 * this.a24 + c4);
        this.d32 = 3.0 / (64.0 * ld * ld) * (4.0 * c3 * (this.a23 - this.d21) + c4 * (4.0 + this.k * this.k));
        this.s1 = (3.0 * c3 * (2.0 * this.a21 * (this.k * this.k - 2.0) - this.a23 * (this.k * this.k + 2.0) - 2.0 * this.k * this.b21) / 2.0 - 3.0 * c4 * (3.0 * this.k * this.k * this.k * this.k - 8.0 * this.k * this.k + 8.0) / 8.0) / (2.0 * ld * (ld * (1.0 + this.k * this.k) - 2.0 * this.k));
        this.s2 = (3.0 * c3 * (2.0 * this.a22 * (this.k * this.k - 2.0) + this.a24 * (this.k * this.k + 2.0) + 2.0 * this.k * this.b22 + 5.0 * this.d21) / 2.0 + 3.0 * c4 * (12.0 - this.k * this.k) / 8.0) / (2.0 * ld * (ld * (1.0 + this.k * this.k) - 2.0 * this.k));
        this.l1 = -3.0 * c3 * (2.0 * this.a21 + this.a23 + 5.0 * this.d21) / 2.0 - 3.0 * c4 * (12.0 - this.k * this.k) / 8.0 + 2.0 * ld * ld * this.s1;
        this.l2 = 3.0 * c3 * (this.a24 - 2.0 * this.a22) / 2.0 + 9.0 * c4 / 8.0 + 2.0 * ld * ld * this.s2;
        this.delta = this.wp * this.wp - c2;
    }

    private double getCn(double order) {
        double cn;
        double gamma3 = this.gamma * this.gamma * this.gamma;
        switch (this.point) {
            case L1: {
                cn = 1.0 / gamma3 * (this.mu + FastMath.pow((double)-1.0, (double)order) * (1.0 - this.mu) * FastMath.pow((double)this.gamma, (double)(order + 1.0)) / FastMath.pow((double)(1.0 - this.gamma), (double)(order + 1.0)));
                break;
            }
            case L2: {
                cn = 1.0 / gamma3 * (FastMath.pow((double)-1.0, (double)order) * this.mu + FastMath.pow((double)-1.0, (double)order) * (1.0 - this.mu) * FastMath.pow((double)this.gamma, (double)(order + 1.0)) / FastMath.pow((double)(1.0 + this.gamma), (double)(order + 1.0)));
                break;
            }
            default: {
                throw new OrekitException((Localizable)OrekitMessages.CANNOT_COMPUTE_LAGRANGIAN, new Object[]{this.point});
            }
        }
        return cn;
    }

    public PVCoordinates computeHaloFirstGuess(double azr, LibrationOrbitFamily type, double t, double phi) {
        double az = azr / (this.gamma * this.dDim);
        double ax = FastMath.sqrt((double)((this.delta + this.l2 * az * az) / -this.l1));
        double nu = 1.0 + this.s1 * ax * ax + this.s2 * az * az;
        double tau = nu * t;
        double tau1 = this.wp * tau + phi;
        double m = type == LibrationOrbitFamily.NORTHERN ? 1.0 : 3.0;
        double dm = 2.0 - m;
        SinCos scTau1 = FastMath.sinCos((double)tau1);
        SinCos sc2Tau1 = SinCos.sum((SinCos)scTau1, (SinCos)scTau1);
        SinCos sc3Tau1 = SinCos.sum((SinCos)scTau1, (SinCos)sc2Tau1);
        double firstx = this.a21 * ax * ax + this.a22 * az * az - ax * scTau1.cos() + (this.a23 * ax * ax - this.a24 * az * az) * sc2Tau1.cos() + (this.a31 * ax * ax * ax - this.a32 * ax * az * az) * sc3Tau1.cos();
        double firsty = this.k * ax * scTau1.sin() + (this.b21 * ax * ax - this.b22 * az * az) * sc2Tau1.sin() + (this.b31 * ax * ax * ax - this.b32 * ax * az * az) * sc3Tau1.sin();
        double firstz = dm * az * scTau1.cos() + dm * this.d21 * ax * az * (sc2Tau1.cos() - 3.0) + dm * (this.d32 * az * ax * ax - this.d31 * az * az * az) * sc3Tau1.cos();
        double vx = ax * this.wp * nu * scTau1.sin() - 2.0 * (this.a23 * ax * ax - this.a24 * az * az) * this.wp * nu * sc2Tau1.sin() - 3.0 * (this.a31 * ax * ax * ax - this.a32 * ax * az * az) * this.wp * nu * sc3Tau1.sin();
        double vy = this.k * ax * this.wp * nu * scTau1.cos() + 2.0 * this.wp * nu * (this.b21 * ax * ax - this.b22 * az * az) * sc2Tau1.cos() + 3.0 * this.wp * nu * (this.b31 * ax * ax * ax - this.b32 * ax * az * az) * sc3Tau1.cos();
        double vz = -dm * az * this.wp * nu * scTau1.sin() - 2.0 * dm * this.d21 * ax * az * this.wp * nu * sc2Tau1.sin() - 3.0 * dm * (this.d32 * az * ax * ax - this.d31 * az * az * az) * this.wp * nu * sc3Tau1.sin();
        return this.point == LagrangianPoints.L1 ? new PVCoordinates(new Vector3D(firstx * this.gamma + 1.0 - this.mu - this.gamma, firsty * this.gamma, firstz * this.gamma), new Vector3D(vx * this.gamma, vy * this.gamma, vz * this.gamma)) : new PVCoordinates(new Vector3D(firstx * this.gamma + 1.0 - this.mu + this.gamma, firsty * this.gamma, firstz * this.gamma), new Vector3D(vx * this.gamma, vy * this.gamma, vz * this.gamma));
    }

    public PVCoordinates computeLyapunovFirstGuess(double ayr, double t, double phi) {
        double az = 0.0;
        double ay = ayr / (this.gamma * this.dDim);
        double ax = ay / this.k;
        double nu = 1.0 + this.s1 * ax * ax + this.s2 * 0.0 * 0.0;
        double tau = nu * t;
        double tau1 = this.wp * tau + phi;
        double firstx = -ax * FastMath.cos((double)tau1);
        double firsty = 0.0;
        double firstz = 0.0;
        double vx = 0.0;
        double vy = this.k * ax * this.wp * nu * FastMath.cos((double)tau1);
        double vz = 0.0;
        return this.point == LagrangianPoints.L1 ? new PVCoordinates(new Vector3D(firstx * this.gamma + 1.0 - this.mu - this.gamma, 0.0 * this.gamma, 0.0 * this.gamma), new Vector3D(0.0 * this.gamma, vy * this.gamma, 0.0 * this.gamma)) : new PVCoordinates(new Vector3D(firstx * this.gamma + 1.0 - this.mu + this.gamma, 0.0 * this.gamma, 0.0 * this.gamma), new Vector3D(0.0 * this.gamma, vy * this.gamma, 0.0 * this.gamma));
    }

    public double getHaloOrbitalPeriod(double azr) {
        double az = azr / (this.gamma * this.dDim);
        double ax = FastMath.sqrt((double)((this.delta + this.l2 * az * az) / -this.l1));
        double nu = 1.0 + this.s1 * ax * ax + this.s2 * az * az;
        this.orbitalPeriod = FastMath.abs((double)(Math.PI * 2 / (this.wp * nu)));
        return this.orbitalPeriod;
    }

    public double getLyapunovOrbitalPeriod(double axr) {
        double az = 0.0;
        double ax = axr / (this.gamma * this.dDim);
        double nu = 1.0 + this.s1 * ax * ax + this.s2 * 0.0 * 0.0;
        this.orbitalPeriod = FastMath.abs((double)(Math.PI * 2 / (this.wp * nu)));
        return this.orbitalPeriod;
    }

    public CR3BPSystem getCr3bpSystem() {
        return this.cr3bpSystem;
    }

    public LagrangianPoints getLagrangianPoint() {
        return this.point;
    }
}

