/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.weather;

import org.hipparchus.util.FastMath;
import org.hipparchus.util.SinCos;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.frames.Frame;
import org.orekit.models.earth.Geoid;
import org.orekit.models.earth.ReferenceEllipsoid;
import org.orekit.models.earth.weather.WeatherModel;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateTimeComponents;
import org.orekit.utils.LegendrePolynomials;

public class GlobalPressureTemperatureModel
implements WeatherModel {
    private static final double TEMPERATURE_GRADIENT = -0.0065;
    private final double latitude;
    private final double longitude;
    private double temperature;
    private double pressure;
    private final Frame bodyFrame;
    private final DataContext dataContext;

    @DefaultDataContext
    public GlobalPressureTemperatureModel(double latitude, double longitude, Frame bodyFrame) {
        this(latitude, longitude, bodyFrame, DataContext.getDefault());
    }

    public GlobalPressureTemperatureModel(double latitude, double longitude, Frame bodyFrame, DataContext dataContext) {
        this.bodyFrame = bodyFrame;
        this.latitude = latitude;
        this.longitude = longitude;
        this.temperature = Double.NaN;
        this.pressure = Double.NaN;
        this.dataContext = dataContext;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public double getPressure() {
        return this.pressure;
    }

    @Override
    @DefaultDataContext
    public void weatherParameters(double height, AbsoluteDate date) {
        DateTimeComponents dtc = date.getComponents(this.dataContext.getTimeScales().getUTC());
        int dofyear = dtc.getDate().getDayOfYear();
        int t0 = 28;
        double coef = (double)(dofyear + 1 - 28) / 365.25 * 2.0 * Math.PI;
        double cosCoef = FastMath.cos((double)coef);
        int degree = 9;
        int order = 9;
        LegendrePolynomials p = new LegendrePolynomials(9, 9, FastMath.sin((double)this.latitude));
        Geoid geoid = new Geoid(this.dataContext.getGravityFields().getNormalizedProvider(9, 9), ReferenceEllipsoid.getWgs84(this.bodyFrame));
        double correctedheight = FastMath.max((double)0.0, (double)(height - geoid.getUndulation(this.latitude, this.longitude, date)));
        double meanT0 = 0.0;
        double amplitudeT0 = 0.0;
        double meanP0 = 0.0;
        double amplitudeP0 = 0.0;
        ABCoefficients abCoef = new ABCoefficients();
        int j = 0;
        for (int n = 0; n <= 9; ++n) {
            for (int m = 0; m <= n; ++m) {
                SinCos sc = FastMath.sinCos((double)((double)m * this.longitude));
                double pCosmLambda = p.getPnm(n, m) * sc.cos();
                double pSinmLambda = p.getPnm(n, m) * sc.sin();
                meanT0 += abCoef.getAnmTemperatureMean(j) * pCosmLambda + abCoef.getBnmTemperatureMean(j) * pSinmLambda;
                amplitudeT0 += abCoef.getAnmTemperatureAmpl(j) * pCosmLambda + abCoef.getBnmTemperatureAmpl(j) * pSinmLambda;
                meanP0 += abCoef.getAnmPressureMean(j) * pCosmLambda + abCoef.getBnmPressureMean(j) * pSinmLambda;
                amplitudeP0 += abCoef.getAnmPressureAmpl(j) * pCosmLambda + abCoef.getBnmPressureAmpl(j) * pSinmLambda;
                ++j;
            }
        }
        double temp0 = meanT0 + amplitudeT0 * cosCoef;
        double pres0 = meanP0 + amplitudeP0 * cosCoef;
        double degrees = temp0 + -0.0065 * correctedheight;
        this.temperature = degrees + 273.15;
        this.pressure = pres0 * FastMath.pow((double)(1.0 - correctedheight * 2.26E-5), (double)5.225);
    }

    private static class ABCoefficients {
        private static final double[] A_PRESSURE_MEAN = new double[]{1010.8, 8.4886, 1.4799, -13.897, 0.0037516, -0.14936, 12.232, -0.76615, -0.067699, 0.0081002, -15.874, 0.36614, -0.067807, -0.0036309, 5.9966E-4, 4.8163, -0.37363, -0.072071, 0.0019998, -6.2385E-4, -3.7916E-4, 4.7609, -0.39534, 0.0086667, 0.011569, 0.0011441, -1.4193E-4, -8.5723E-5, 0.65008, -0.50889, -0.015754, -0.0028305, 5.7458E-4, 3.2577E-5, -9.6052E-6, -2.7974E-6, 1.353, -0.27271, -3.0276E-4, 0.0036286, -2.0398E-4, 1.5846E-5, -7.7787E-6, 1.121E-6, 9.902E-8, 0.55046, -0.27312, 0.0032532, -0.0024277, 1.1596E-4, 2.6421E-7, -1.3263E-6, 2.7322E-7, 1.4058E-7, 4.9414E-9};
        private static final double[] B_PRESSURE_MEAN = new double[]{0.0, 0.0, -1.2878, 0.0, 0.70444, 0.33222, 0.0, -0.29636, 0.0072248, 0.0079655, 0.0, 1.0854, 0.011145, -0.036513, 0.0031527, 0.0, -0.48434, 0.052023, -0.013091, 0.0018515, 1.5422E-4, 0.0, 0.68298, 0.0025261, -9.9703E-4, -0.0010829, 1.7688E-4, -3.1418E-5, 0.0, -0.37018, 0.043234, 0.0072559, 3.1516E-4, 2.0024E-5, -8.0581E-6, -2.3653E-6, 0.0, 0.10298, -0.015086, 0.0056186, 3.2613E-5, 4.0567E-5, -1.3925E-6, -3.6219E-7, -2.0176E-8, 0.0, -0.18364, 0.018508, 7.5016E-4, -9.6139E-5, -3.1995E-6, 1.3868E-7, -1.9486E-7, 3.0165E-10, -6.4376E-10};
        private static final double[] A_PRESSURE_AMPLITUDE = new double[]{-0.10444, 0.16618, -0.063974, 1.0922, 0.57472, -0.30277, -3.5087, 0.0071264, -0.1403, 0.03705, 0.40208, -0.30431, -0.13292, 0.0046746, -1.5902E-4, 2.8624, -0.39315, -0.064371, 0.016444, -0.0023403, 4.2127E-5, 1.9945, -0.60907, -0.035386, -0.001091, -1.2799E-4, 4.097E-5, 2.2131E-5, -0.53292, -0.29765, -0.032877, 0.0017691, 5.9692E-5, 3.1725E-5, 2.0741E-5, -3.7622E-7, 2.6372, -0.31165, 0.016439, 2.1633E-4, 1.7485E-4, 2.1587E-5, 6.1064E-6, -1.3755E-8, -7.8748E-8, -0.59152, -0.17676, 0.0081807, 0.0010445, 2.3432E-4, 9.3421E-6, 2.8104E-6, -1.5788E-7, -3.0648E-8, 2.6421E-10};
        private static final double[] B_PRESSURE_AMPLITUDE = new double[]{0.0, 0.0, 0.9334, 0.0, 0.82346, 0.22082, 0.0, 0.96177, -0.01565, 0.0012708, 0.0, -0.39913, 0.02802, 0.028334, 8.598E-4, 0.0, 0.30545, -0.021691, 6.4067E-4, -3.6528E-5, -1.1166E-4, 0.0, -0.076974, -0.018986, 0.0056896, -2.4159E-4, -2.3033E-4, -9.6783E-6, 0.0, -0.10218, -0.013916, -0.0041025, -5.134E-5, -7.0114E-5, -3.3152E-7, 1.6901E-6, 0.0, -0.012422, 0.0025072, 0.0011205, -1.3034E-4, -2.3971E-5, -2.6622E-6, 5.7852E-7, 4.5847E-8, 0.0, 0.044777, -0.0030421, 2.6062E-5, -7.2421E-5, 1.9119E-6, 3.9236E-7, 2.239E-7, 2.9765E-9, -4.6452E-9};
        private static final double[] A_TEMPERATURE_MEAN = new double[]{16.257, 2.1224, 0.92569, -25.974, 1.451, 0.092468, -0.53192, 0.21094, -0.06921, -0.03406, -4.6569, 0.26385, -0.036093, 0.010198, -0.0018783, 0.74983, 0.11741, 0.03994, 0.0051348, 0.0059111, 8.6133E-6, 0.63057, 0.15203, 0.039702, 0.0046334, 2.4406E-4, 1.5189E-4, 1.9581E-7, 0.54414, 0.35722, 0.052763, 0.0041147, -2.7239E-4, -5.9957E-5, 1.6394E-6, -7.3045E-7, -2.9394, 0.055579, 0.018852, 0.0034272, -2.3193E-5, -2.9349E-5, 3.6397E-7, 2.049E-6, -6.4719E-8, -0.52225, 0.20799, 0.0013477, 3.1613E-4, -2.2285E-4, -1.8137E-5, -1.5177E-7, 6.1343E-7, 7.8566E-8, 1.0749E-9};
        private static final double[] B_TEMPERATURE_MEAN = new double[]{0.0, 0.0, 1.021, 0.0, 0.60194, 0.12292, 0.0, -0.42184, 0.1823, 0.042329, 0.0, 0.093312, 0.095346, -0.0019724, 0.0058776, 0.0, -0.2094, 0.034199, -0.0057672, -0.002159, 5.6815E-4, 0.0, 0.22858, 0.012283, -0.0093679, -0.0014233, -1.5962E-4, 4.016E-5, 0.0, 0.036353, -9.4263E-4, -0.0036762, 5.8608E-5, -2.6391E-5, 3.2095E-6, -1.1605E-6, 0.0, 0.16306, 0.013293, -0.0011395, 5.1097E-5, 3.3977E-5, 7.6449E-6, -1.7602E-7, -7.6558E-8, 0.0, -0.045415, -0.018027, 3.6561E-4, -1.1274E-4, 1.3047E-5, 2.0001E-6, -1.5152E-7, -2.7807E-8, 7.7491E-9};
        private static final double[] A_TEMPERATURE_AMPLITUDE = new double[]{-1.8654, -9.0041, -0.12974, -3.6053, 0.020284, 0.21872, -1.3015, 0.40355, 0.22216, -0.0040605, 1.9623, 0.42887, 0.21437, -0.010061, -0.0011368, -0.069235, 0.56758, 0.11917, -0.0070765, 3.0017E-4, 3.0601E-4, 1.6559, 0.20722, 0.060013, 1.7023E-4, -9.2424E-4, 1.1269E-5, -6.9911E-6, -2.0886, -0.067879, -8.5922E-4, -0.0016087, -4.5549E-5, 3.3178E-5, -6.1715E-6, -1.4446E-6, -0.3721, 0.15775, -0.0017827, -4.4396E-4, 2.2844E-4, -1.1215E-5, -2.112E-6, -9.6421E-7, -1.417E-8, 0.7872, -0.044238, -0.001512, -9.4119E-4, 4.0645E-6, -4.9253E-6, -1.8656E-6, -4.0736E-7, -4.9594E-8, 1.6134E-9};
        private static final double[] B_TEMPERATURE_AMPLITUDE = new double[]{0.0, 0.0, -0.89895, 0.0, -1.079, -0.12699, 0.0, -0.59033, 0.034865, -0.032614, 0.0, -0.02431, 0.015607, -0.029833, -0.0059048, 0.0, 0.28383, 0.040509, -0.018834, -0.0012654, -1.3794E-4, 0.0, 0.13306, 0.03496, -0.0036799, -3.5626E-4, 1.4814E-4, 3.7932E-6, 0.0, 0.20801, 0.006564, -0.0034893, -2.7395E-4, 7.4296E-5, -7.9927E-6, -1.0277E-6, 0.0, 0.036515, -0.0074319, -6.2873E-4, 8.2461E-5, 3.1095E-5, -5.386E-7, -1.2055E-7, -1.1517E-7, 0.0, 0.031404, 0.01558, -0.0011428, 3.3529E-5, 1.0387E-5, -1.9378E-6, -2.7327E-7, 7.5833E-9, -9.2323E-9};

        ABCoefficients() {
        }

        public double getAnmPressureMean(int index) {
            return A_PRESSURE_MEAN[index];
        }

        public double getBnmPressureMean(int index) {
            return B_PRESSURE_MEAN[index];
        }

        public double getAnmPressureAmpl(int index) {
            return A_PRESSURE_AMPLITUDE[index];
        }

        public double getBnmPressureAmpl(int index) {
            return B_PRESSURE_AMPLITUDE[index];
        }

        public double getAnmTemperatureMean(int index) {
            return A_TEMPERATURE_MEAN[index];
        }

        public double getBnmTemperatureMean(int index) {
            return B_TEMPERATURE_MEAN[index];
        }

        public double getAnmTemperatureAmpl(int index) {
            return A_TEMPERATURE_AMPLITUDE[index];
        }

        public double getBnmTemperatureAmpl(int index) {
            return B_TEMPERATURE_AMPLITUDE[index];
        }
    }
}

