/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.displacement;

import org.orekit.bodies.GeodeticPoint;
import org.orekit.models.earth.displacement.Tide;

public class OceanLoadingCoefficients {
    private final String siteName;
    private final GeodeticPoint siteLocation;
    private final Tide[][] tides;
    private final double[][] zAmplitude;
    private final double[][] zPhase;
    private final double[][] wAmplitude;
    private final double[][] wPhase;
    private final double[][] sAmplitude;
    private final double[][] sPhase;

    public OceanLoadingCoefficients(String siteName, GeodeticPoint siteLocation, Tide[][] tides, double[][] zAmplitude, double[][] zPhase, double[][] wAmplitude, double[][] wPhase, double[][] sAmplitude, double[][] sPhase) {
        this.siteName = siteName;
        this.siteLocation = siteLocation;
        this.tides = this.copy(tides);
        this.zAmplitude = this.copy(zAmplitude);
        this.zPhase = this.copy(zPhase);
        this.wAmplitude = this.copy(wAmplitude);
        this.wPhase = this.copy(wPhase);
        this.sAmplitude = this.copy(sAmplitude);
        this.sPhase = this.copy(sPhase);
    }

    private Tide[][] copy(Tide[][] array) {
        Tide[][] copied = new Tide[array.length][];
        for (int i = 0; i < array.length; ++i) {
            copied[i] = (Tide[])array[i].clone();
        }
        return copied;
    }

    private double[][] copy(double[][] array) {
        double[][] copied = new double[array.length][];
        for (int i = 0; i < array.length; ++i) {
            copied[i] = (double[])array[i].clone();
        }
        return copied;
    }

    public String getSiteName() {
        return this.siteName;
    }

    public GeodeticPoint getSiteLocation() {
        return this.siteLocation;
    }

    public Tide getTide(int i, int j) {
        return this.tides[i][j];
    }

    public double getZenithAmplitude(int i, int j) {
        return this.zAmplitude[i][j];
    }

    public double getZenithPhase(int i, int j) {
        return this.zPhase[i][j];
    }

    public double getWestAmplitude(int i, int j) {
        return this.wAmplitude[i][j];
    }

    public double getWestPhase(int i, int j) {
        return this.wPhase[i][j];
    }

    public double getSouthAmplitude(int i, int j) {
        return this.sAmplitude[i][j];
    }

    public double getSouthPhase(int i, int j) {
        return this.sPhase[i][j];
    }

    public int getNbSpecies() {
        return this.tides.length;
    }

    public int getNbTides(int species) {
        return this.tides[species].length;
    }
}

