/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.metric.parser;

import java.util.Locale;
import org.hipparchus.util.FastMath;
import org.orekit.gnss.metric.parser.DataField;
import org.orekit.gnss.metric.parser.DataType;
import org.orekit.gnss.metric.parser.EncodedMessage;
import org.orekit.gnss.metric.parser.Units;
import org.orekit.utils.units.Unit;

public enum RtcmDataField implements DataField
{
    DF002{

        @Override
        public String stringValue(EncodedMessage message, int n) {
            return String.format(Locale.US, "%4s", DataType.U_INT_12.decode(message).intValue()).trim();
        }
    }
    ,
    DF009{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.U_INT_6.decode(message).intValue();
        }
    }
    ,
    DF038{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.U_INT_6.decode(message).intValue();
        }
    }
    ,
    DF040{

        @Override
        public int intValue(EncodedMessage message) {
            int id = DataType.U_INT_5.decode(message).intValue();
            return id - 7;
        }
    }
    ,
    DF071{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.BIT_8.decode(message).intValue();
        }
    }
    ,
    DF076{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.U_INT_10.decode(message).intValue();
        }
    }
    ,
    DF077{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.U_INT_4.decode(message).intValue();
        }
    }
    ,
    DF078{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.BIT_2.decode(message).intValue();
        }
    }
    ,
    DF079{

        @Override
        public double doubleValue(EncodedMessage message) {
            return Units.SEMI_CIRCLE.toSI(FastMath.scalb((float)DataType.INT_14.decode(message).intValue(), (int)-43));
        }
    }
    ,
    DF081{

        @Override
        public double doubleValue(EncodedMessage message) {
            return (double)DataType.U_INT_16.decode(message).intValue() * 16.0;
        }
    }
    ,
    DF082{

        @Override
        public double doubleValue(EncodedMessage message) {
            return FastMath.scalb((float)DataType.INT_8.decode(message).intValue(), (int)-55);
        }
    }
    ,
    DF083{

        @Override
        public double doubleValue(EncodedMessage message) {
            return FastMath.scalb((float)DataType.INT_16.decode(message).intValue(), (int)-43);
        }
    }
    ,
    DF084{

        @Override
        public double doubleValue(EncodedMessage message) {
            return FastMath.scalb((float)DataType.INT_22.decode(message).intValue(), (int)-31);
        }
    }
    ,
    DF085{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.U_INT_10.decode(message).intValue();
        }
    }
    ,
    DF086{

        @Override
        public double doubleValue(EncodedMessage message) {
            return FastMath.scalb((float)DataType.INT_16.decode(message).intValue(), (int)-5);
        }
    }
    ,
    DF087{

        @Override
        public double doubleValue(EncodedMessage message) {
            return Units.SEMI_CIRCLE.toSI(FastMath.scalb((float)DataType.INT_16.decode(message).intValue(), (int)-43));
        }
    }
    ,
    DF088{

        @Override
        public double doubleValue(EncodedMessage message) {
            return Units.SEMI_CIRCLE.toSI(FastMath.scalb((float)DataType.INT_32.decode(message).intValue(), (int)-31));
        }
    }
    ,
    DF089{

        @Override
        public double doubleValue(EncodedMessage message) {
            return FastMath.scalb((float)DataType.INT_16.decode(message).intValue(), (int)-29);
        }
    }
    ,
    DF090{

        @Override
        public double doubleValue(EncodedMessage message) {
            return FastMath.scalb((float)DataType.U_INT_32.decode(message).longValue(), (int)-33);
        }
    }
    ,
    DF091{

        @Override
        public double doubleValue(EncodedMessage message) {
            return FastMath.scalb((float)DataType.INT_16.decode(message).intValue(), (int)-29);
        }
    }
    ,
    DF092{

        @Override
        public double doubleValue(EncodedMessage message) {
            return FastMath.scalb((float)DataType.U_INT_32.decode(message).longValue(), (int)-19);
        }
    }
    ,
    DF093{

        @Override
        public double doubleValue(EncodedMessage message) {
            return (double)DataType.U_INT_16.decode(message).intValue() * 16.0;
        }
    }
    ,
    DF094{

        @Override
        public double doubleValue(EncodedMessage message) {
            return FastMath.scalb((float)DataType.INT_16.decode(message).intValue(), (int)-29);
        }
    }
    ,
    DF095{

        @Override
        public double doubleValue(EncodedMessage message) {
            return Units.SEMI_CIRCLE.toSI(FastMath.scalb((float)DataType.INT_32.decode(message).intValue(), (int)-31));
        }
    }
    ,
    DF096{

        @Override
        public double doubleValue(EncodedMessage message) {
            return FastMath.scalb((float)DataType.INT_16.decode(message).intValue(), (int)-29);
        }
    }
    ,
    DF097{

        @Override
        public double doubleValue(EncodedMessage message) {
            return Units.SEMI_CIRCLE.toSI(FastMath.scalb((float)DataType.INT_32.decode(message).intValue(), (int)-31));
        }
    }
    ,
    DF098{

        @Override
        public double doubleValue(EncodedMessage message) {
            return FastMath.scalb((float)DataType.INT_16.decode(message).intValue(), (int)-5);
        }
    }
    ,
    DF099{

        @Override
        public double doubleValue(EncodedMessage message) {
            return Units.SEMI_CIRCLE.toSI(FastMath.scalb((float)DataType.INT_32.decode(message).intValue(), (int)-31));
        }
    }
    ,
    DF100{

        @Override
        public double doubleValue(EncodedMessage message) {
            return Units.SEMI_CIRCLE.toSI(FastMath.scalb((float)DataType.INT_24.decode(message).intValue(), (int)-43));
        }
    }
    ,
    DF101{

        @Override
        public double doubleValue(EncodedMessage message) {
            return FastMath.scalb((float)DataType.INT_8.decode(message).intValue(), (int)-31);
        }
    }
    ,
    DF102{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.U_INT_6.decode(message).intValue();
        }
    }
    ,
    DF103{

        @Override
        public boolean booleanValue(EncodedMessage message) {
            return DataType.BIT_1.decode(message) == 0L;
        }
    }
    ,
    DF104{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.BIT_1.decode(message).intValue();
        }
    }
    ,
    DF105{

        @Override
        public boolean booleanValue(EncodedMessage message) {
            return DataType.BIT_1.decode(message) > 0L;
        }
    }
    ,
    DF106{

        @Override
        public int intValue(EncodedMessage message) {
            switch (DataType.BIT_2.decode(message).intValue()) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1800;
                }
                case 2: {
                    return 2700;
                }
            }
            return 3600;
        }
    }
    ,
    DF107{

        @Override
        public double doubleValue(EncodedMessage message) {
            int hours = DataType.U_INT_5.decode(message).intValue();
            int minutes = DataType.U_INT_6.decode(message).intValue();
            double secondes = (double)DataType.BIT_1.decode(message).intValue() * 30.0;
            return (double)hours * 3600.0 + (double)minutes * 60.0 + secondes;
        }
    }
    ,
    DF108{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.BIT_1.decode(message).intValue();
        }
    }
    ,
    DF109{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.BIT_1.decode(message).intValue();
        }
    }
    ,
    DF110{

        @Override
        public double doubleValue(EncodedMessage message) {
            return Unit.MINUTE.toSI((double)DataType.U_INT_7.decode(message).intValue() * 15.0);
        }
    }
    ,
    DF111{

        @Override
        public double doubleValue(EncodedMessage message) {
            return Units.KM_PER_S.toSI(FastMath.scalb((float)DataType.INT_S_24.decode(message).intValue(), (int)-20));
        }
    }
    ,
    DF112{

        @Override
        public double doubleValue(EncodedMessage message) {
            return Unit.KILOMETRE.toSI(FastMath.scalb((float)DataType.INT_S_27.decode(message).intValue(), (int)-11));
        }
    }
    ,
    DF113{

        @Override
        public double doubleValue(EncodedMessage message) {
            return Units.KM_PER_S2.toSI(FastMath.scalb((float)DataType.INT_S_5.decode(message).intValue(), (int)-30));
        }
    }
    ,
    DF114{

        @Override
        public double doubleValue(EncodedMessage message) {
            return Units.KM_PER_S.toSI(FastMath.scalb((float)DataType.INT_S_24.decode(message).intValue(), (int)-20));
        }
    }
    ,
    DF115{

        @Override
        public double doubleValue(EncodedMessage message) {
            return Unit.KILOMETRE.toSI(FastMath.scalb((float)DataType.INT_S_27.decode(message).intValue(), (int)-11));
        }
    }
    ,
    DF116{

        @Override
        public double doubleValue(EncodedMessage message) {
            return Units.KM_PER_S2.toSI(FastMath.scalb((float)DataType.INT_S_5.decode(message).intValue(), (int)-30));
        }
    }
    ,
    DF117{

        @Override
        public double doubleValue(EncodedMessage message) {
            return Units.KM_PER_S.toSI(FastMath.scalb((float)DataType.INT_S_24.decode(message).intValue(), (int)-20));
        }
    }
    ,
    DF118{

        @Override
        public double doubleValue(EncodedMessage message) {
            return Unit.KILOMETRE.toSI(FastMath.scalb((float)DataType.INT_S_27.decode(message).intValue(), (int)-11));
        }
    }
    ,
    DF119{

        @Override
        public double doubleValue(EncodedMessage message) {
            return Units.KM_PER_S2.toSI(FastMath.scalb((float)DataType.INT_S_5.decode(message).intValue(), (int)-30));
        }
    }
    ,
    DF120{

        @Override
        public int intValue(EncodedMessage message) {
            if (DataType.BIT_1.decode(message) == 0L) {
                return 4;
            }
            return 5;
        }
    }
    ,
    DF121{

        @Override
        public double doubleValue(EncodedMessage message) {
            return FastMath.scalb((float)DataType.INT_S_11.decode(message).intValue(), (int)-40);
        }
    }
    ,
    DF122{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.BIT_2.decode(message).intValue();
        }
    }
    ,
    DF123{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.BIT_1.decode(message).intValue();
        }
    }
    ,
    DF124{

        @Override
        public double doubleValue(EncodedMessage message) {
            return FastMath.scalb((float)DataType.INT_S_22.decode(message).intValue(), (int)-30);
        }
    }
    ,
    DF125{

        @Override
        public double doubleValue(EncodedMessage message) {
            return FastMath.scalb((float)DataType.INT_S_5.decode(message).intValue(), (int)-30);
        }
    }
    ,
    DF126{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.U_INT_5.decode(message).intValue();
        }
    }
    ,
    DF127{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.BIT_1.decode(message).intValue();
        }
    }
    ,
    DF128{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.U_INT_4.decode(message).intValue();
        }
    }
    ,
    DF129{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.U_INT_11.decode(message).intValue();
        }
    }
    ,
    DF130{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.BIT_2.decode(message).intValue();
        }
    }
    ,
    DF131{

        @Override
        public boolean booleanValue(EncodedMessage message) {
            return DataType.BIT_1.decode(message) > 0L;
        }
    }
    ,
    DF132{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.U_INT_11.decode(message).intValue();
        }
    }
    ,
    DF133{

        @Override
        public double doubleValue(EncodedMessage message) {
            return FastMath.scalb((float)DataType.INT_S_32.decode(message).intValue(), (int)-31);
        }
    }
    ,
    DF134{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.U_INT_5.decode(message).intValue();
        }
    }
    ,
    DF135{

        @Override
        public double doubleValue(EncodedMessage message) {
            return FastMath.scalb((float)DataType.INT_S_22.decode(message).intValue(), (int)-31);
        }
    }
    ,
    DF136{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.BIT_1.decode(message).intValue();
        }
    }
    ,
    DF137{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.BIT_1.decode(message).intValue();
        }
    }
    ,
    DF252{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.U_INT_6.decode(message).intValue();
        }
    }
    ,
    DF289{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.U_INT_12.decode(message).intValue();
        }
    }
    ,
    DF290{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.U_INT_10.decode(message).intValue();
        }
    }
    ,
    DF291{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.BIT_8.decode(message).intValue();
        }
    }
    ,
    DF292{

        @Override
        public double doubleValue(EncodedMessage message) {
            return Units.SEMI_CIRCLE.toSI(FastMath.scalb((float)DataType.INT_14.decode(message).intValue(), (int)-43));
        }
    }
    ,
    DF293{

        @Override
        public double doubleValue(EncodedMessage message) {
            return (double)DataType.U_INT_14.decode(message).intValue() * 60.0;
        }
    }
    ,
    DF294{

        @Override
        public double doubleValue(EncodedMessage message) {
            return FastMath.scalb((float)DataType.INT_6.decode(message).intValue(), (int)-59);
        }
    }
    ,
    DF295{

        @Override
        public double doubleValue(EncodedMessage message) {
            return FastMath.scalb((float)DataType.INT_21.decode(message).intValue(), (int)-46);
        }
    }
    ,
    DF296{

        @Override
        public double doubleValue(EncodedMessage message) {
            return FastMath.scalb((float)DataType.INT_31.decode(message).intValue(), (int)-34);
        }
    }
    ,
    DF297{

        @Override
        public double doubleValue(EncodedMessage message) {
            return FastMath.scalb((float)DataType.INT_16.decode(message).intValue(), (int)-5);
        }
    }
    ,
    DF298{

        @Override
        public double doubleValue(EncodedMessage message) {
            return Units.SEMI_CIRCLE.toSI(FastMath.scalb((float)DataType.INT_16.decode(message).intValue(), (int)-43));
        }
    }
    ,
    DF299{

        @Override
        public double doubleValue(EncodedMessage message) {
            return Units.SEMI_CIRCLE.toSI(FastMath.scalb((float)DataType.INT_32.decode(message).intValue(), (int)-31));
        }
    }
    ,
    DF300{

        @Override
        public double doubleValue(EncodedMessage message) {
            return FastMath.scalb((float)DataType.INT_16.decode(message).intValue(), (int)-29);
        }
    }
    ,
    DF301{

        @Override
        public double doubleValue(EncodedMessage message) {
            return FastMath.scalb((double)DataType.U_INT_32.decode(message).doubleValue(), (int)-33);
        }
    }
    ,
    DF302{

        @Override
        public double doubleValue(EncodedMessage message) {
            return FastMath.scalb((float)DataType.INT_16.decode(message).intValue(), (int)-29);
        }
    }
    ,
    DF303{

        @Override
        public double doubleValue(EncodedMessage message) {
            return FastMath.scalb((double)DataType.U_INT_32.decode(message).doubleValue(), (int)-19);
        }
    }
    ,
    DF304{

        @Override
        public double doubleValue(EncodedMessage message) {
            return (double)DataType.U_INT_14.decode(message).intValue() * 60.0;
        }
    }
    ,
    DF305{

        @Override
        public double doubleValue(EncodedMessage message) {
            return FastMath.scalb((float)DataType.INT_16.decode(message).intValue(), (int)-29);
        }
    }
    ,
    DF306{

        @Override
        public double doubleValue(EncodedMessage message) {
            return Units.SEMI_CIRCLE.toSI(FastMath.scalb((float)DataType.INT_32.decode(message).intValue(), (int)-31));
        }
    }
    ,
    DF307{

        @Override
        public double doubleValue(EncodedMessage message) {
            return FastMath.scalb((float)DataType.INT_16.decode(message).intValue(), (int)-29);
        }
    }
    ,
    DF308{

        @Override
        public double doubleValue(EncodedMessage message) {
            return Units.SEMI_CIRCLE.toSI(FastMath.scalb((float)DataType.INT_32.decode(message).intValue(), (int)-31));
        }
    }
    ,
    DF309{

        @Override
        public double doubleValue(EncodedMessage message) {
            return FastMath.scalb((float)DataType.INT_16.decode(message).intValue(), (int)-5);
        }
    }
    ,
    DF310{

        @Override
        public double doubleValue(EncodedMessage message) {
            return Units.SEMI_CIRCLE.toSI(FastMath.scalb((float)DataType.INT_32.decode(message).intValue(), (int)-31));
        }
    }
    ,
    DF311{

        @Override
        public double doubleValue(EncodedMessage message) {
            return Units.SEMI_CIRCLE.toSI(FastMath.scalb((float)DataType.INT_24.decode(message).intValue(), (int)-43));
        }
    }
    ,
    DF312{

        @Override
        public double doubleValue(EncodedMessage message) {
            return FastMath.scalb((float)DataType.INT_10.decode(message).intValue(), (int)-32);
        }
    }
    ,
    DF313{

        @Override
        public double doubleValue(EncodedMessage message) {
            return FastMath.scalb((float)DataType.INT_10.decode(message).intValue(), (int)-32);
        }
    }
    ,
    DF314{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.BIT_2.decode(message).intValue();
        }
    }
    ,
    DF315{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.BIT_1.decode(message).intValue();
        }
    }
    ,
    DF316{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.BIT_2.decode(message).intValue();
        }
    }
    ,
    DF317{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.BIT_1.decode(message).intValue();
        }
    }
    ,
    DF429{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.U_INT_4.decode(message).intValue() + 192;
        }
    }
    ,
    DF430{

        @Override
        public double doubleValue(EncodedMessage message) {
            return (double)DataType.U_INT_16.decode(message).intValue() * 16.0;
        }
    }
    ,
    DF431{

        @Override
        public double doubleValue(EncodedMessage message) {
            return FastMath.scalb((float)DataType.INT_8.decode(message).intValue(), (int)-55);
        }
    }
    ,
    DF432{

        @Override
        public double doubleValue(EncodedMessage message) {
            return FastMath.scalb((float)DataType.INT_16.decode(message).intValue(), (int)-43);
        }
    }
    ,
    DF433{

        @Override
        public double doubleValue(EncodedMessage message) {
            return FastMath.scalb((float)DataType.INT_22.decode(message).intValue(), (int)-31);
        }
    }
    ,
    DF434{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.U_INT_8.decode(message).intValue();
        }
    }
    ,
    DF435{

        @Override
        public double doubleValue(EncodedMessage message) {
            return FastMath.scalb((float)DataType.INT_16.decode(message).intValue(), (int)-5);
        }
    }
    ,
    DF436{

        @Override
        public double doubleValue(EncodedMessage message) {
            return Units.SEMI_CIRCLE.toSI(FastMath.scalb((float)DataType.INT_16.decode(message).intValue(), (int)-43));
        }
    }
    ,
    DF437{

        @Override
        public double doubleValue(EncodedMessage message) {
            return Units.SEMI_CIRCLE.toSI(FastMath.scalb((float)DataType.INT_32.decode(message).intValue(), (int)-31));
        }
    }
    ,
    DF438{

        @Override
        public double doubleValue(EncodedMessage message) {
            return FastMath.scalb((float)DataType.INT_16.decode(message).intValue(), (int)-29);
        }
    }
    ,
    DF439{

        @Override
        public double doubleValue(EncodedMessage message) {
            return FastMath.scalb((double)DataType.U_INT_32.decode(message).doubleValue(), (int)-33);
        }
    }
    ,
    DF440{

        @Override
        public double doubleValue(EncodedMessage message) {
            return FastMath.scalb((float)DataType.INT_16.decode(message).intValue(), (int)-29);
        }
    }
    ,
    DF441{

        @Override
        public double doubleValue(EncodedMessage message) {
            return FastMath.scalb((double)DataType.U_INT_32.decode(message).doubleValue(), (int)-19);
        }
    }
    ,
    DF442{

        @Override
        public double doubleValue(EncodedMessage message) {
            return (double)DataType.U_INT_16.decode(message).intValue() * 16.0;
        }
    }
    ,
    DF443{

        @Override
        public double doubleValue(EncodedMessage message) {
            return FastMath.scalb((float)DataType.INT_16.decode(message).intValue(), (int)-29);
        }
    }
    ,
    DF444{

        @Override
        public double doubleValue(EncodedMessage message) {
            return Units.SEMI_CIRCLE.toSI(FastMath.scalb((float)DataType.INT_32.decode(message).intValue(), (int)-31));
        }
    }
    ,
    DF445{

        @Override
        public double doubleValue(EncodedMessage message) {
            return FastMath.scalb((float)DataType.INT_16.decode(message).intValue(), (int)-29);
        }
    }
    ,
    DF446{

        @Override
        public double doubleValue(EncodedMessage message) {
            return Units.SEMI_CIRCLE.toSI(FastMath.scalb((float)DataType.INT_32.decode(message).intValue(), (int)-31));
        }
    }
    ,
    DF447{

        @Override
        public double doubleValue(EncodedMessage message) {
            return FastMath.scalb((float)DataType.INT_16.decode(message).intValue(), (int)-5);
        }
    }
    ,
    DF448{

        @Override
        public double doubleValue(EncodedMessage message) {
            return Units.SEMI_CIRCLE.toSI(FastMath.scalb((float)DataType.INT_32.decode(message).intValue(), (int)-31));
        }
    }
    ,
    DF449{

        @Override
        public double doubleValue(EncodedMessage message) {
            return Units.SEMI_CIRCLE.toSI(FastMath.scalb((float)DataType.INT_24.decode(message).intValue(), (int)-43));
        }
    }
    ,
    DF450{

        @Override
        public double doubleValue(EncodedMessage message) {
            return Units.SEMI_CIRCLE.toSI(FastMath.scalb((float)DataType.INT_14.decode(message).intValue(), (int)-43));
        }
    }
    ,
    DF451{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.BIT_2.decode(message).intValue();
        }
    }
    ,
    DF452{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.U_INT_10.decode(message).intValue();
        }
    }
    ,
    DF453{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.U_INT_4.decode(message).intValue();
        }
    }
    ,
    DF454{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.U_INT_6.decode(message).intValue();
        }
    }
    ,
    DF455{

        @Override
        public double doubleValue(EncodedMessage message) {
            return FastMath.scalb((float)DataType.INT_8.decode(message).intValue(), (int)-31);
        }
    }
    ,
    DF456{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.U_INT_10.decode(message).intValue();
        }
    }
    ,
    DF457{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.BIT_1.decode(message).intValue();
        }
    }
    ,
    DF488{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.U_INT_6.decode(message).intValue();
        }
    }
    ,
    DF489{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.U_INT_13.decode(message).intValue();
        }
    }
    ,
    DF490{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.BIT_4.decode(message).intValue();
        }
    }
    ,
    DF491{

        @Override
        public double doubleValue(EncodedMessage message) {
            return Units.SEMI_CIRCLE.toSI(FastMath.scalb((float)DataType.INT_14.decode(message).intValue(), (int)-43));
        }
    }
    ,
    DF492{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.U_INT_5.decode(message).intValue();
        }
    }
    ,
    DF493{

        @Override
        public double doubleValue(EncodedMessage message) {
            return (double)DataType.U_INT_17.decode(message).intValue() * 8.0;
        }
    }
    ,
    DF494{

        @Override
        public double doubleValue(EncodedMessage message) {
            return FastMath.scalb((float)DataType.INT_11.decode(message).intValue(), (int)-66);
        }
    }
    ,
    DF495{

        @Override
        public double doubleValue(EncodedMessage message) {
            return FastMath.scalb((float)DataType.INT_22.decode(message).intValue(), (int)-50);
        }
    }
    ,
    DF496{

        @Override
        public double doubleValue(EncodedMessage message) {
            return FastMath.scalb((float)DataType.INT_24.decode(message).intValue(), (int)-33);
        }
    }
    ,
    DF497{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.U_INT_5.decode(message).intValue();
        }
    }
    ,
    DF498{

        @Override
        public double doubleValue(EncodedMessage message) {
            return FastMath.scalb((float)DataType.INT_18.decode(message).intValue(), (int)-6);
        }
    }
    ,
    DF499{

        @Override
        public double doubleValue(EncodedMessage message) {
            return Units.SEMI_CIRCLE.toSI(FastMath.scalb((float)DataType.INT_16.decode(message).intValue(), (int)-43));
        }
    }
    ,
    DF500{

        @Override
        public double doubleValue(EncodedMessage message) {
            return Units.SEMI_CIRCLE.toSI(FastMath.scalb((float)DataType.INT_32.decode(message).intValue(), (int)-31));
        }
    }
    ,
    DF501{

        @Override
        public double doubleValue(EncodedMessage message) {
            return FastMath.scalb((float)DataType.INT_18.decode(message).intValue(), (int)-31);
        }
    }
    ,
    DF502{

        @Override
        public double doubleValue(EncodedMessage message) {
            return FastMath.scalb((double)DataType.U_INT_32.decode(message).doubleValue(), (int)-33);
        }
    }
    ,
    DF503{

        @Override
        public double doubleValue(EncodedMessage message) {
            return FastMath.scalb((float)DataType.INT_18.decode(message).intValue(), (int)-31);
        }
    }
    ,
    DF504{

        @Override
        public double doubleValue(EncodedMessage message) {
            return FastMath.scalb((double)DataType.U_INT_32.decode(message).doubleValue(), (int)-19);
        }
    }
    ,
    DF505{

        @Override
        public double doubleValue(EncodedMessage message) {
            return (double)DataType.U_INT_17.decode(message).intValue() * 8.0;
        }
    }
    ,
    DF506{

        @Override
        public double doubleValue(EncodedMessage message) {
            return FastMath.scalb((float)DataType.INT_18.decode(message).intValue(), (int)-31);
        }
    }
    ,
    DF507{

        @Override
        public double doubleValue(EncodedMessage message) {
            return Units.SEMI_CIRCLE.toSI(FastMath.scalb((float)DataType.INT_32.decode(message).intValue(), (int)-31));
        }
    }
    ,
    DF508{

        @Override
        public double doubleValue(EncodedMessage message) {
            return FastMath.scalb((float)DataType.INT_18.decode(message).intValue(), (int)-31);
        }
    }
    ,
    DF509{

        @Override
        public double doubleValue(EncodedMessage message) {
            return Units.SEMI_CIRCLE.toSI(FastMath.scalb((float)DataType.INT_32.decode(message).intValue(), (int)-31));
        }
    }
    ,
    DF510{

        @Override
        public double doubleValue(EncodedMessage message) {
            return FastMath.scalb((float)DataType.INT_18.decode(message).intValue(), (int)-6);
        }
    }
    ,
    DF511{

        @Override
        public double doubleValue(EncodedMessage message) {
            return Units.SEMI_CIRCLE.toSI(FastMath.scalb((float)DataType.INT_32.decode(message).intValue(), (int)-31));
        }
    }
    ,
    DF512{

        @Override
        public double doubleValue(EncodedMessage message) {
            return Units.SEMI_CIRCLE.toSI(FastMath.scalb((float)DataType.INT_24.decode(message).intValue(), (int)-43));
        }
    }
    ,
    DF513{

        @Override
        public double doubleValue(EncodedMessage message) {
            return Units.NS.toSI((double)DataType.INT_10.decode(message).intValue() * 0.1);
        }
    }
    ,
    DF514{

        @Override
        public double doubleValue(EncodedMessage message) {
            return Units.NS.toSI((double)DataType.INT_10.decode(message).intValue() * 0.1);
        }
    }
    ,
    DF515{

        @Override
        public int intValue(EncodedMessage message) {
            return DataType.BIT_1.decode(message).intValue();
        }
    };

}

