/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.metric.parser;

import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.gnss.metric.parser.EncodedMessage;

public abstract class AbstractEncodedMessages
implements EncodedMessage {
    private int current;
    private int remaining;

    @Override
    public void start() {
        this.remaining = 0;
    }

    protected abstract int fetchByte();

    @Override
    public long extractBits(int n) {
        int nbBits;
        if (n > 63) {
            throw new OrekitException((Localizable)OrekitMessages.TOO_LARGE_DATA_TYPE, n);
        }
        long value = 0L;
        for (int needed = n; needed > 0; needed -= nbBits) {
            if (this.remaining == 0) {
                int read = this.fetchByte();
                if (read == -1) {
                    throw new OrekitException((Localizable)OrekitMessages.END_OF_ENCODED_MESSAGE, new Object[0]);
                }
                this.current = read & 0xFF;
                this.remaining = 8;
            }
            nbBits = FastMath.min((int)this.remaining, (int)needed);
            value = value << nbBits | (long)(this.current >>> 8 - nbBits);
            this.current = this.current << nbBits & 0xFF;
            this.remaining -= nbBits;
        }
        return value;
    }
}

