/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.metric.messages.rtcm.ephemeris;

import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.gnss.SatelliteSystem;
import org.orekit.gnss.metric.messages.rtcm.ephemeris.RtcmEphemerisData;
import org.orekit.propagation.analytical.gnss.data.GPSNavigationMessage;
import org.orekit.time.GNSSDate;
import org.orekit.time.TimeScales;

public class Rtcm1019Data
extends RtcmEphemerisData {
    private GPSNavigationMessage gpsNavigationMessage;
    private double gpsToc;
    private int gpsCodeOnL2;
    private boolean gpsL2PDataFlag;
    private int gpsFitInterval;

    @DefaultDataContext
    public GPSNavigationMessage getGpsNavigationMessage() {
        return this.getGpsNavigationMessage(DataContext.getDefault().getTimeScales());
    }

    public GPSNavigationMessage getGpsNavigationMessage(TimeScales timeScales) {
        SatelliteSystem system = SatelliteSystem.GPS;
        int week = this.gpsNavigationMessage.getWeek();
        double toe = this.gpsNavigationMessage.getTime();
        this.gpsNavigationMessage.setDate(new GNSSDate(week, 1000.0 * toe, system, timeScales).getDate());
        this.gpsNavigationMessage.setEpochToc(new GNSSDate(week, 1000.0 * this.gpsToc, system, timeScales).getDate());
        return this.gpsNavigationMessage;
    }

    public void setGpsNavigationMessage(GPSNavigationMessage gpsNavigationMessage) {
        this.gpsNavigationMessage = gpsNavigationMessage;
    }

    public double getGpsToc() {
        return this.gpsToc;
    }

    public void setGpsToc(double toc) {
        this.gpsToc = toc;
    }

    public int getGpsCodeOnL2() {
        return this.gpsCodeOnL2;
    }

    public void setGpsCodeOnL2(int gpsCodeOnL2) {
        this.gpsCodeOnL2 = gpsCodeOnL2;
    }

    public boolean getGpsL2PDataFlag() {
        return this.gpsL2PDataFlag;
    }

    public void setGpsL2PDataFlag(boolean gpsL2PDataFlag) {
        this.gpsL2PDataFlag = gpsL2PDataFlag;
    }

    public int getGpsFitInterval() {
        return this.gpsFitInterval;
    }

    public void setGpsFitInterval(int gpsFitInterval) {
        this.gpsFitInterval = gpsFitInterval;
    }
}

