/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.clock;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.gnss.AppliedDCBS;
import org.orekit.gnss.AppliedPCVS;
import org.orekit.gnss.ObservationType;
import org.orekit.gnss.SatelliteSystem;
import org.orekit.gnss.TimeSystem;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateComponents;
import org.orekit.time.TimeComponents;
import org.orekit.time.TimeScale;
import org.orekit.utils.TimeSpanMap;

public class RinexClock {
    private double formatVersion = 0.0;
    private SatelliteSystem satelliteSystem;
    private String programName;
    private String agencyName = "";
    private String creationDateString = "";
    private String creationTimeString = "";
    private String creationTimeZoneString = "";
    private AbsoluteDate creationDate = null;
    private String comments = "";
    private Map<SatelliteSystem, List<ObservationType>> systemObservationTypes = new HashMap<SatelliteSystem, List<ObservationType>>();
    private TimeSystem timeSystem;
    private TimeScale timeScale;
    private int numberOfLeapSeconds;
    private int numberOfLeapSecondsGNSS;
    private List<AppliedDCBS> listAppliedDCBS = new ArrayList<AppliedDCBS>();
    private List<AppliedPCVS> listAppliedPCVS = new ArrayList<AppliedPCVS>();
    private List<ClockDataType> clockDataTypes = new ArrayList<ClockDataType>();
    private String stationName;
    private String stationIdentifier;
    private String externalClockReference = "";
    private String analysisCenterID = "";
    private String analysisCenterName = "";
    private TimeSpanMap<List<ReferenceClock>> referenceClocks;
    private String frameName;
    private final Function<? super String, ? extends Frame> frameBuilder;
    private List<Receiver> receivers = new ArrayList<Receiver>();
    private List<String> satellites = new ArrayList<String>();
    private Map<String, List<ClockDataLine>> clockData = new HashMap<String, List<ClockDataLine>>();

    public RinexClock(Function<? super String, ? extends Frame> frameBuilder) {
        this.frameBuilder = frameBuilder;
        this.frameName = "";
        this.numberOfLeapSeconds = 0;
        this.numberOfLeapSecondsGNSS = 0;
        this.programName = "";
        this.referenceClocks = null;
        this.satelliteSystem = null;
        this.stationIdentifier = "";
        this.stationName = "";
        this.timeScale = null;
        this.timeSystem = null;
    }

    public void addSatellite(String satId) {
        if (!this.satellites.contains(satId)) {
            this.satellites.add(satId);
        }
    }

    public void addReceiver(Receiver receiver) {
        boolean notInList = true;
        for (Receiver rec : this.receivers) {
            if (!rec.designator.equals(receiver.designator)) continue;
            notInList = false;
        }
        if (notInList) {
            this.receivers.add(receiver);
        }
    }

    public int getNumberOfClockDataTypes() {
        return this.clockDataTypes.size();
    }

    public int getTotalNumberOfDataLines() {
        int result = 0;
        Map<String, List<ClockDataLine>> data = this.getClockData();
        for (Map.Entry<String, List<ClockDataLine>> entry : data.entrySet()) {
            result += entry.getValue().size();
        }
        return result;
    }

    public int numberOfObsTypes(SatelliteSystem system) {
        if (this.systemObservationTypes.containsKey((Object)system)) {
            return this.systemObservationTypes.get((Object)system).size();
        }
        return 0;
    }

    public int getNumberOfReceivers() {
        return this.receivers.size();
    }

    public int getNumberOfSatellites() {
        return this.satellites.size();
    }

    public double getFormatVersion() {
        return this.formatVersion;
    }

    public void setFormatVersion(double formatVersion) {
        this.formatVersion = formatVersion;
    }

    public SatelliteSystem getSatelliteSystem() {
        return this.satelliteSystem;
    }

    public void setSatelliteSystem(SatelliteSystem satelliteSystem) {
        this.satelliteSystem = satelliteSystem;
    }

    public String getProgramName() {
        return this.programName;
    }

    public void setProgramName(String programName) {
        this.programName = programName;
    }

    public String getAgencyName() {
        return this.agencyName;
    }

    public void setAgencyName(String agencyName) {
        this.agencyName = agencyName;
    }

    public String getCreationDateString() {
        return this.creationDateString;
    }

    public void setCreationDateString(String creationDateString) {
        this.creationDateString = creationDateString;
    }

    public String getCreationTimeString() {
        return this.creationTimeString;
    }

    public void setCreationTimeString(String creationTimeString) {
        this.creationTimeString = creationTimeString;
    }

    public String getCreationTimeZoneString() {
        return this.creationTimeZoneString;
    }

    public void setCreationTimeZoneString(String creationTimeZoneString) {
        this.creationTimeZoneString = creationTimeZoneString;
    }

    public AbsoluteDate getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(AbsoluteDate creationDate) {
        this.creationDate = creationDate;
    }

    public String getComments() {
        return this.comments;
    }

    public void addComment(String comment) {
        this.comments = this.comments.concat(comment + "\n");
    }

    public Map<SatelliteSystem, List<ObservationType>> getSystemObservationTypes() {
        return Collections.unmodifiableMap(this.systemObservationTypes);
    }

    public void addSystemObservationType(SatelliteSystem satSystem, ObservationType observationType) {
        this.systemObservationTypes.putIfAbsent(satSystem, new ArrayList());
        this.systemObservationTypes.get((Object)satSystem).add(observationType);
    }

    public TimeSystem getTimeSystem() {
        return this.timeSystem;
    }

    public void setTimeSystem(TimeSystem timeSystem) {
        this.timeSystem = timeSystem;
    }

    public TimeScale getTimeScale() {
        return this.timeScale;
    }

    public void setTimeScale(TimeScale timeScale) {
        this.timeScale = timeScale;
    }

    public int getNumberOfLeapSeconds() {
        return this.numberOfLeapSeconds;
    }

    public void setNumberOfLeapSeconds(int numberOfLeapSeconds) {
        this.numberOfLeapSeconds = numberOfLeapSeconds;
    }

    public int getNumberOfLeapSecondsGNSS() {
        return this.numberOfLeapSecondsGNSS;
    }

    public void setNumberOfLeapSecondsGNSS(int numberOfLeapSecondsGNSS) {
        this.numberOfLeapSecondsGNSS = numberOfLeapSecondsGNSS;
    }

    public List<AppliedDCBS> getListAppliedDCBS() {
        return Collections.unmodifiableList(this.listAppliedDCBS);
    }

    public void addAppliedDCBS(AppliedDCBS appliedDCBS) {
        this.listAppliedDCBS.add(appliedDCBS);
    }

    public List<AppliedPCVS> getListAppliedPCVS() {
        return Collections.unmodifiableList(this.listAppliedPCVS);
    }

    public void addAppliedPCVS(AppliedPCVS appliedPCVS) {
        this.listAppliedPCVS.add(appliedPCVS);
    }

    public List<ClockDataType> getClockDataTypes() {
        return Collections.unmodifiableList(this.clockDataTypes);
    }

    public void addClockDataType(ClockDataType clockDataType) {
        this.clockDataTypes.add(clockDataType);
    }

    public String getStationName() {
        return this.stationName;
    }

    public void setStationName(String stationName) {
        this.stationName = stationName;
    }

    public String getStationIdentifier() {
        return this.stationIdentifier;
    }

    public void setStationIdentifier(String stationIdentifier) {
        this.stationIdentifier = stationIdentifier;
    }

    public String getExternalClockReference() {
        return this.externalClockReference;
    }

    public void setExternalClockReference(String externalClockReference) {
        this.externalClockReference = externalClockReference;
    }

    public String getAnalysisCenterID() {
        return this.analysisCenterID;
    }

    public void setAnalysisCenterID(String analysisCenterID) {
        this.analysisCenterID = analysisCenterID;
    }

    public String getAnalysisCenterName() {
        return this.analysisCenterName;
    }

    public void setAnalysisCenterName(String analysisCenterName) {
        this.analysisCenterName = analysisCenterName;
    }

    public TimeSpanMap<List<ReferenceClock>> getReferenceClocks() {
        return this.referenceClocks;
    }

    public void addReferenceClockList(List<ReferenceClock> referenceClockList, AbsoluteDate startDate) {
        if (this.referenceClocks == null) {
            this.referenceClocks = new TimeSpanMap<Object>(null);
        }
        this.referenceClocks.addValidAfter(referenceClockList, startDate, false);
    }

    public String getFrameName() {
        return this.frameName;
    }

    public void setFrameName(String frameName) {
        this.frameName = frameName;
    }

    public List<Receiver> getReceivers() {
        return Collections.unmodifiableList(this.receivers);
    }

    public List<String> getSatellites() {
        return Collections.unmodifiableList(this.satellites);
    }

    public Frame getFrame() {
        return this.frameBuilder.apply(this.frameName);
    }

    public Map<String, List<ClockDataLine>> getClockData() {
        return Collections.unmodifiableMap(this.clockData);
    }

    public void addClockData(String id, ClockDataLine clockDataLine) {
        this.clockData.putIfAbsent(id, new ArrayList());
        this.clockData.get(id).add(clockDataLine);
    }

    public static enum ClockDataType {
        AR("AR"),
        AS("AS"),
        CR("CR"),
        DR("DR"),
        MS("MS");

        private static final Map<String, ClockDataType> KEYS_MAP;
        private final String key;

        private ClockDataType(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public static ClockDataType parseClockDataType(String s) throws OrekitIllegalArgumentException {
            ClockDataType clockDataType = KEYS_MAP.get(s);
            if (clockDataType == null) {
                throw new OrekitIllegalArgumentException(OrekitMessages.UNKNOWN_CLOCK_DATA_TYPE, s);
            }
            return clockDataType;
        }

        static {
            KEYS_MAP = new HashMap<String, ClockDataType>();
            for (ClockDataType timeSystem : ClockDataType.values()) {
                KEYS_MAP.put(timeSystem.getKey(), timeSystem);
            }
        }
    }

    public static class Receiver {
        private String designator;
        private String receiverIdentifier;
        private double x;
        private double y;
        private double z;

        public Receiver(String designator, String receiverIdentifier, double x, double y, double z) {
            this.designator = designator;
            this.receiverIdentifier = receiverIdentifier;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public String getDesignator() {
            return this.designator;
        }

        public String getReceiverIdentifier() {
            return this.receiverIdentifier;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getZ() {
            return this.z;
        }
    }

    public static class ReferenceClock {
        private String referenceName;
        private String clockID;
        private double clockConstraint;
        private AbsoluteDate startDate;
        private AbsoluteDate endDate;

        public ReferenceClock(String referenceName, String clockID, double clockConstraint, AbsoluteDate startDate, AbsoluteDate endDate) {
            this.referenceName = referenceName;
            this.clockID = clockID;
            this.clockConstraint = clockConstraint;
            this.startDate = startDate;
            this.endDate = endDate;
        }

        public String getReferenceName() {
            return this.referenceName;
        }

        public String getClockID() {
            return this.clockID;
        }

        public double getClockConstraint() {
            return this.clockConstraint;
        }

        public AbsoluteDate getStartDate() {
            return this.startDate;
        }

        public AbsoluteDate getEndDate() {
            return this.endDate;
        }
    }

    public class ClockDataLine {
        private ClockDataType dataType;
        private String name;
        private DateComponents dateComponents;
        private TimeComponents timeComponents;
        private int numberOfValues;
        private double clockBias;
        private double clockBiasSigma;
        private double clockRate;
        private double clockRateSigma;
        private double clockAcceleration;
        private double clockAccelrerationSigma;

        public ClockDataLine(ClockDataType type, String name, DateComponents dateComponents, TimeComponents timeComponents, int numberOfValues, double clockBias, double clockBiasSigma, double clockRate, double clockRateSigma, double clockAcceleration, double clockAccelerationSigma) {
            this.dataType = type;
            this.name = name;
            this.dateComponents = dateComponents;
            this.timeComponents = timeComponents;
            this.numberOfValues = numberOfValues;
            this.clockBias = clockBias;
            this.clockBiasSigma = clockBiasSigma;
            this.clockRate = clockRate;
            this.clockRateSigma = clockRateSigma;
            this.clockAcceleration = clockAcceleration;
            this.clockAccelrerationSigma = clockAccelerationSigma;
        }

        public ClockDataType getDataType() {
            return this.dataType;
        }

        public String getName() {
            return this.name;
        }

        public int getNumberOfValues() {
            return this.numberOfValues;
        }

        public AbsoluteDate getEpoch() {
            return new AbsoluteDate(this.dateComponents, this.timeComponents, RinexClock.this.timeScale);
        }

        public AbsoluteDate getEpoch(TimeScale epochTimeScale) {
            return new AbsoluteDate(this.dateComponents, this.timeComponents, epochTimeScale);
        }

        public double getClockBias() {
            return this.clockBias;
        }

        public double getClockBiasSigma() {
            return this.clockBiasSigma;
        }

        public double getClockRate() {
            return this.clockRate;
        }

        public double getClockRateSigma() {
            return this.clockRateSigma;
        }

        public double getClockAcceleration() {
            return this.clockAcceleration;
        }

        public double getClockAccelerationSigma() {
            return this.clockAccelrerationSigma;
        }
    }
}

