/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.SortedSet;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hipparchus.exception.Localizable;
import org.orekit.data.DataProvidersManager;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.AbstractEopLoader;
import org.orekit.frames.AbstractEopParser;
import org.orekit.frames.EOPEntry;
import org.orekit.frames.EOPHistoryLoader;
import org.orekit.frames.EopParserLoader;
import org.orekit.frames.ITRFVersionLoader;
import org.orekit.frames.ItrfVersionProvider;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateComponents;
import org.orekit.time.TimeScale;
import org.orekit.utils.IERSConventions;
import org.orekit.utils.units.UnitsConverter;

class RapidDataAndPredictionColumnsLoader
extends AbstractEopLoader
implements EOPHistoryLoader {
    private static final String INTEGER2_FIELD = "((?:\\p{Blank}|\\p{Digit})\\p{Digit})";
    private static final String MJD_FIELD = "\\p{Blank}+(\\p{Digit}+)(?:\\.00*)";
    private static final String SEPARATOR = "\\p{Blank}*[IP]";
    private static final String REAL_FIELD = "\\p{Blank}*(-?\\p{Digit}*\\.\\p{Digit}*)";
    private static int DATE_START = 0;
    private static int DATE_END = 15;
    private static final Pattern DATE_PATTERN = Pattern.compile("((?:\\p{Blank}|\\p{Digit})\\p{Digit})((?:\\p{Blank}|\\p{Digit})\\p{Digit})((?:\\p{Blank}|\\p{Digit})\\p{Digit})\\p{Blank}+(\\p{Digit}+)(?:\\.00*)");
    private static int POLE_START_A = 16;
    private static int POLE_END_A = 55;
    private static final Pattern POLE_PATTERN_A = Pattern.compile("\\p{Blank}*[IP]\\p{Blank}*(-?\\p{Digit}*\\.\\p{Digit}*)\\p{Blank}*(-?\\p{Digit}*\\.\\p{Digit}*)\\p{Blank}*(-?\\p{Digit}*\\.\\p{Digit}*)\\p{Blank}*(-?\\p{Digit}*\\.\\p{Digit}*)");
    private static int POLE_START_B = 134;
    private static int POLE_END_B = 154;
    private static final Pattern POLE_PATTERN_B = Pattern.compile("\\p{Blank}*(-?\\p{Digit}*\\.\\p{Digit}*)\\p{Blank}*(-?\\p{Digit}*\\.\\p{Digit}*)");
    private static int UT1_UTC_START_A = 57;
    private static int UT1_UTC_END_A = 78;
    private static final Pattern UT1_UTC_PATTERN_A = Pattern.compile("\\p{Blank}*[IP]\\p{Blank}*(-?\\p{Digit}*\\.\\p{Digit}*)\\p{Blank}*(-?\\p{Digit}*\\.\\p{Digit}*)");
    private static int UT1_UTC_START_B = 154;
    private static int UT1_UTC_END_B = 165;
    private static final Pattern UT1_UTC_PATTERN_B = Pattern.compile("\\p{Blank}*(-?\\p{Digit}*\\.\\p{Digit}*)");
    private static int LOD_START_A = 79;
    private static int LOD_END_A = 93;
    private static final Pattern LOD_PATTERN_A = Pattern.compile("\\p{Blank}*(-?\\p{Digit}*\\.\\p{Digit}*)\\p{Blank}*(-?\\p{Digit}*\\.\\p{Digit}*)");
    private static int NUTATION_START_A = 95;
    private static int NUTATION_END_A = 134;
    private static final Pattern NUTATION_PATTERN_A = Pattern.compile("\\p{Blank}*[IP]\\p{Blank}*(-?\\p{Digit}*\\.\\p{Digit}*)\\p{Blank}*(-?\\p{Digit}*\\.\\p{Digit}*)\\p{Blank}*(-?\\p{Digit}*\\.\\p{Digit}*)\\p{Blank}*(-?\\p{Digit}*\\.\\p{Digit}*)");
    private static int NUTATION_START_B = 165;
    private static int NUTATION_END_B = 185;
    private static final Pattern NUTATION_PATTERN_B = Pattern.compile("\\p{Blank}*(-?\\p{Digit}*\\.\\p{Digit}*)\\p{Blank}*(-?\\p{Digit}*\\.\\p{Digit}*)");
    private final boolean isNonRotatingOrigin;

    RapidDataAndPredictionColumnsLoader(boolean isNonRotatingOrigin, String supportedNames, DataProvidersManager manager, Supplier<TimeScale> utcSupplier) {
        super(supportedNames, manager, utcSupplier);
        this.isNonRotatingOrigin = isNonRotatingOrigin;
    }

    @Override
    public void fillHistory(IERSConventions.NutationCorrectionConverter converter, SortedSet<EOPEntry> history) {
        ITRFVersionLoader itrfVersionProvider = new ITRFVersionLoader("itrf-versions.conf", this.getDataProvidersManager());
        Parser parser = new Parser(converter, itrfVersionProvider, this.getUtc(), this.isNonRotatingOrigin);
        EopParserLoader loader = new EopParserLoader(parser);
        this.feed(loader);
        history.addAll(loader.getEop());
    }

    private static String getPart(String line, int start, int end) {
        return line.length() >= end ? line.substring(start, end) : "";
    }

    static class Parser
    extends AbstractEopParser {
        private final boolean isNonRotatingOrigin;

        Parser(IERSConventions.NutationCorrectionConverter converter, ItrfVersionProvider itrfVersionProvider, TimeScale utc, boolean isNonRotatingOrigin) {
            super(converter, itrfVersionProvider, utc);
            this.isNonRotatingOrigin = isNonRotatingOrigin;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Collection<EOPEntry> parse(InputStream input, String name) throws IOException {
            ArrayList<EOPEntry> history = new ArrayList<EOPEntry>();
            ITRFVersionLoader.ITRFVersionConfiguration configuration = null;
            int lineNumber = 0;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
                String line = reader.readLine();
                while (line != null) {
                    double[] equinox;
                    double[] nro;
                    double lod;
                    double dtu1;
                    double y;
                    double x;
                    ++lineNumber;
                    String datePart = RapidDataAndPredictionColumnsLoader.getPart(line, DATE_START, DATE_END);
                    String polePartA = RapidDataAndPredictionColumnsLoader.getPart(line, POLE_START_A, POLE_END_A);
                    String ut1utcPartA = RapidDataAndPredictionColumnsLoader.getPart(line, UT1_UTC_START_A, UT1_UTC_END_A);
                    String lodPartA = RapidDataAndPredictionColumnsLoader.getPart(line, LOD_START_A, LOD_END_A);
                    String nutationPartA = RapidDataAndPredictionColumnsLoader.getPart(line, NUTATION_START_A, NUTATION_END_A);
                    String polePartB = RapidDataAndPredictionColumnsLoader.getPart(line, POLE_START_B, POLE_END_B);
                    String ut1utcPartB = RapidDataAndPredictionColumnsLoader.getPart(line, UT1_UTC_START_B, UT1_UTC_END_B);
                    String nutationPartB = RapidDataAndPredictionColumnsLoader.getPart(line, NUTATION_START_B, NUTATION_END_B);
                    Matcher dateMatcher = DATE_PATTERN.matcher(datePart);
                    if (!dateMatcher.matches()) throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
                    int yy = Integer.parseInt(dateMatcher.group(1).trim());
                    int mm = Integer.parseInt(dateMatcher.group(2).trim());
                    int dd = Integer.parseInt(dateMatcher.group(3).trim());
                    int mjd = Integer.parseInt(dateMatcher.group(4).trim());
                    DateComponents reconstructedDate = new DateComponents(DateComponents.MODIFIED_JULIAN_EPOCH, mjd);
                    if (reconstructedDate.getYear() % 100 != yy || reconstructedDate.getMonth() != mm || reconstructedDate.getDay() != dd) {
                        throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
                    }
                    if (polePartB.trim().length() == 0) {
                        if (polePartA.trim().length() == 0) {
                            x = 0.0;
                            y = 0.0;
                        } else {
                            Matcher poleAMatcher = POLE_PATTERN_A.matcher(polePartA);
                            if (!poleAMatcher.matches()) throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
                            x = UnitsConverter.ARC_SECONDS_TO_RADIANS.convert(Double.parseDouble(poleAMatcher.group(1)));
                            y = UnitsConverter.ARC_SECONDS_TO_RADIANS.convert(Double.parseDouble(poleAMatcher.group(3)));
                        }
                    } else {
                        Matcher poleBMatcher = POLE_PATTERN_B.matcher(polePartB);
                        if (!poleBMatcher.matches()) throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
                        x = UnitsConverter.ARC_SECONDS_TO_RADIANS.convert(Double.parseDouble(poleBMatcher.group(1)));
                        y = UnitsConverter.ARC_SECONDS_TO_RADIANS.convert(Double.parseDouble(poleBMatcher.group(2)));
                    }
                    if (ut1utcPartB.trim().length() == 0) {
                        if (ut1utcPartA.trim().length() == 0) {
                            dtu1 = 0.0;
                        } else {
                            Matcher ut1utcAMatcher = UT1_UTC_PATTERN_A.matcher(ut1utcPartA);
                            if (!ut1utcAMatcher.matches()) throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
                            dtu1 = Double.parseDouble(ut1utcAMatcher.group(1));
                        }
                    } else {
                        Matcher ut1utcBMatcher = UT1_UTC_PATTERN_B.matcher(ut1utcPartB);
                        if (!ut1utcBMatcher.matches()) throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
                        dtu1 = Double.parseDouble(ut1utcBMatcher.group(1));
                    }
                    if (lodPartA.trim().length() == 0) {
                        lod = 0.0;
                    } else {
                        Matcher lodAMatcher = LOD_PATTERN_A.matcher(lodPartA);
                        if (!lodAMatcher.matches()) throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
                        lod = UnitsConverter.MILLI_SECONDS_TO_SECONDS.convert(Double.parseDouble(lodAMatcher.group(1)));
                    }
                    AbsoluteDate mjdDate = new AbsoluteDate(new DateComponents(DateComponents.MODIFIED_JULIAN_EPOCH, mjd), this.getUtc());
                    if (nutationPartB.trim().length() == 0) {
                        if (nutationPartA.trim().length() == 0) {
                            nro = new double[2];
                            equinox = new double[2];
                        } else {
                            Matcher nutationAMatcher = NUTATION_PATTERN_A.matcher(nutationPartA);
                            if (!nutationAMatcher.matches()) throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
                            if (this.isNonRotatingOrigin) {
                                nro = new double[]{UnitsConverter.MILLI_ARC_SECONDS_TO_RADIANS.convert(Double.parseDouble(nutationAMatcher.group(1))), UnitsConverter.MILLI_ARC_SECONDS_TO_RADIANS.convert(Double.parseDouble(nutationAMatcher.group(3)))};
                                equinox = this.getConverter().toEquinox(mjdDate, nro[0], nro[1]);
                            } else {
                                equinox = new double[]{UnitsConverter.MILLI_ARC_SECONDS_TO_RADIANS.convert(Double.parseDouble(nutationAMatcher.group(1))), UnitsConverter.MILLI_ARC_SECONDS_TO_RADIANS.convert(Double.parseDouble(nutationAMatcher.group(3)))};
                                nro = this.getConverter().toNonRotating(mjdDate, equinox[0], equinox[1]);
                            }
                        }
                    } else {
                        Matcher nutationBMatcher = NUTATION_PATTERN_B.matcher(nutationPartB);
                        if (!nutationBMatcher.matches()) throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
                        if (this.isNonRotatingOrigin) {
                            nro = new double[]{UnitsConverter.MILLI_ARC_SECONDS_TO_RADIANS.convert(Double.parseDouble(nutationBMatcher.group(1))), UnitsConverter.MILLI_ARC_SECONDS_TO_RADIANS.convert(Double.parseDouble(nutationBMatcher.group(2)))};
                            equinox = this.getConverter().toEquinox(mjdDate, nro[0], nro[1]);
                        } else {
                            equinox = new double[]{UnitsConverter.MILLI_ARC_SECONDS_TO_RADIANS.convert(Double.parseDouble(nutationBMatcher.group(1))), UnitsConverter.MILLI_ARC_SECONDS_TO_RADIANS.convert(Double.parseDouble(nutationBMatcher.group(2)))};
                            nro = this.getConverter().toNonRotating(mjdDate, equinox[0], equinox[1]);
                        }
                    }
                    if (configuration == null || !configuration.isValid(mjd)) {
                        configuration = this.getItrfVersionProvider().getConfiguration(name, mjd);
                    }
                    history.add(new EOPEntry(mjd, dtu1, lod, x, y, equinox[0], equinox[1], nro[0], nro[1], configuration.getVersion(), mjdDate));
                    line = reader.readLine();
                }
                return history;
            }
        }
    }
}

