/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.frames;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Transform;
import org.orekit.frames.TransformProvider;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;

public class FixedTransformProvider
implements TransformProvider {
    private static final long serialVersionUID = 20170106L;
    private final Transform transform;
    private final transient Map<Field<? extends CalculusFieldElement<?>>, FieldTransform<? extends CalculusFieldElement<?>>> cached;

    public FixedTransformProvider(Transform transform) {
        this.transform = transform;
        this.cached = new HashMap();
    }

    @Override
    public Transform getTransform(AbsoluteDate date) {
        return this.transform;
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldTransform<T> getTransform(FieldAbsoluteDate<T> date) {
        FieldTransform<Object> ft = this.cached.get(date.getField());
        if (ft == null) {
            ft = new FieldTransform<T>(date.getField(), this.transform);
            this.cached.put(date.getField(), ft);
        }
        return ft;
    }

    private Object writeReplace() {
        return new DataTransferObject(this.transform);
    }

    private static class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = 20170106L;
        private final Transform transform;

        private DataTransferObject(Transform transform) {
            this.transform = transform;
        }

        private Object readResolve() {
            return new FixedTransformProvider(this.transform);
        }
    }
}

