/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.radiation;

import java.util.List;
import java.util.stream.Stream;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.polynomials.PolynomialFunction;
import org.hipparchus.analysis.polynomials.PolynomialsUtils;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.SinCos;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.data.DataContext;
import org.orekit.forces.AbstractForceModel;
import org.orekit.forces.radiation.RadiationSensitive;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.utils.ExtendedPVCoordinatesProvider;
import org.orekit.utils.ParameterDriver;

public class KnockeRediffusedForceModel
extends AbstractForceModel {
    private static final double EARTH_AROUND_SUN_PULSATION = 1.991021277657232E-7;
    private static final double ES_COEFF = 4.5606E-6;
    private static final double A0 = 0.34;
    private static final double C0 = 0.0;
    private static final double C1 = 0.1;
    private static final double C2 = 0.0;
    private static final double A2 = 0.29;
    private static final double E0 = 0.68;
    private static final double K0 = 0.0;
    private static final double K1 = -0.07;
    private static final double K2 = 0.0;
    private static final double E2 = -0.18;
    private final ExtendedPVCoordinatesProvider sun;
    private final RadiationSensitive spacecraft;
    private final double angularResolution;
    private double equatorialRadius;
    private final AbsoluteDate referenceEpoch;

    @DefaultDataContext
    public KnockeRediffusedForceModel(ExtendedPVCoordinatesProvider sun, RadiationSensitive spacecraft, double equatorialRadius, double angularResolution) {
        this(sun, spacecraft, equatorialRadius, angularResolution, DataContext.getDefault().getTimeScales().getUTC());
    }

    public KnockeRediffusedForceModel(ExtendedPVCoordinatesProvider sun, RadiationSensitive spacecraft, double equatorialRadius, double angularResolution, TimeScale utc) {
        this.sun = sun;
        this.spacecraft = spacecraft;
        this.equatorialRadius = equatorialRadius;
        this.angularResolution = angularResolution;
        this.referenceEpoch = new AbsoluteDate(1981, 12, 22, 0, 0, 0.0, utc);
    }

    @Override
    public boolean dependsOnPositionOnly() {
        return false;
    }

    @Override
    public Stream<EventDetector> getEventsDetectors() {
        return Stream.of(new EventDetector[0]);
    }

    @Override
    public <T extends CalculusFieldElement<T>> Stream<FieldEventDetector<T>> getFieldEventsDetectors(Field<T> field) {
        return Stream.of(new FieldEventDetector[0]);
    }

    @Override
    public Vector3D acceleration(SpacecraftState s, double[] parameters) {
        AbsoluteDate date = s.getDate();
        Frame frame = s.getFrame();
        Vector3D satellitePosition = s.getPVCoordinates().getPosition();
        Vector3D sunPosition = this.sun.getPVCoordinates(date, frame).getPosition();
        OneAxisEllipsoid earth = new OneAxisEllipsoid(this.equatorialRadius, 0.0, frame);
        Vector3D projectedToGround = satellitePosition.normalize().scalarMultiply(this.equatorialRadius);
        Vector3D east = earth.transform(satellitePosition, frame, date).getEast();
        double centerArea = Math.PI * 2 * this.equatorialRadius * this.equatorialRadius * (1.0 - FastMath.cos((double)this.angularResolution));
        Vector3D rediffusedFlux = this.computeElementaryFlux(s, projectedToGround, sunPosition, earth, centerArea);
        for (double eastAxisOffset = 1.5 * this.angularResolution; eastAxisOffset < FastMath.asin((double)(this.equatorialRadius / satellitePosition.getNorm())); eastAxisOffset += this.angularResolution) {
            Transform eastRotation = new Transform(date, new Rotation(east, eastAxisOffset, RotationConvention.VECTOR_OPERATOR));
            Vector3D firstCrownSectorCenter = eastRotation.transformPosition(projectedToGround);
            for (double radialAxisOffset = 0.5 * this.angularResolution; radialAxisOffset < Math.PI * 2; radialAxisOffset += this.angularResolution) {
                Transform radialRotation = new Transform(date, new Rotation(projectedToGround, radialAxisOffset, RotationConvention.VECTOR_OPERATOR));
                Vector3D currentCenter = radialRotation.transformPosition(firstCrownSectorCenter);
                double sectorArea = this.equatorialRadius * this.equatorialRadius * 2.0 * this.angularResolution * FastMath.sin((double)(0.5 * this.angularResolution)) * FastMath.sin((double)eastAxisOffset);
                rediffusedFlux = rediffusedFlux.add((Vector)this.computeElementaryFlux(s, currentCenter, sunPosition, earth, sectorArea));
            }
        }
        return this.spacecraft.radiationPressureAcceleration(date, frame, satellitePosition, s.getAttitude().getRotation(), s.getMass(), rediffusedFlux, parameters);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldVector3D<T> acceleration(FieldSpacecraftState<T> s, T[] parameters) {
        FieldAbsoluteDate<T> date = s.getDate();
        Frame frame = s.getFrame();
        CalculusFieldElement zero = (CalculusFieldElement)date.getField().getZero();
        FieldVector3D satellitePosition = s.getPVCoordinates().getPosition();
        FieldVector3D sunPosition = this.sun.getPVCoordinates(date, frame).getPosition();
        OneAxisEllipsoid earth = new OneAxisEllipsoid(this.equatorialRadius, 0.0, frame);
        FieldVector3D projectedToGround = satellitePosition.normalize().scalarMultiply(this.equatorialRadius);
        FieldVector3D east = earth.transform(satellitePosition, frame, date).getEast();
        CalculusFieldElement centerArea = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)zero.getPi()).multiply(2.0)).multiply(this.equatorialRadius)).multiply(this.equatorialRadius)).multiply(1.0 - FastMath.cos((double)this.angularResolution));
        FieldVector3D rediffusedFlux = this.computeElementaryFlux(s, projectedToGround, sunPosition, earth, centerArea);
        for (double eastAxisOffset = 1.5 * this.angularResolution; eastAxisOffset < FastMath.asin((double)(this.equatorialRadius / satellitePosition.getNorm().getReal())); eastAxisOffset += this.angularResolution) {
            FieldTransform<T> eastRotation = new FieldTransform<T>(date, new FieldRotation(east, (CalculusFieldElement)zero.add(eastAxisOffset), RotationConvention.VECTOR_OPERATOR));
            FieldVector3D<T> firstCrownSectorCenter = eastRotation.transformPosition(projectedToGround);
            for (double radialAxisOffset = 0.5 * this.angularResolution; radialAxisOffset < Math.PI * 2; radialAxisOffset += this.angularResolution) {
                FieldTransform<T> radialRotation = new FieldTransform<T>(date, new FieldRotation(projectedToGround, (CalculusFieldElement)zero.add(radialAxisOffset), RotationConvention.VECTOR_OPERATOR));
                FieldVector3D<T> currentCenter = radialRotation.transformPosition(firstCrownSectorCenter);
                CalculusFieldElement sectorArea = (CalculusFieldElement)zero.add(this.equatorialRadius * this.equatorialRadius * 2.0 * this.angularResolution * FastMath.sin((double)(0.5 * this.angularResolution)) * FastMath.sin((double)eastAxisOffset));
                rediffusedFlux = rediffusedFlux.add(this.computeElementaryFlux(s, currentCenter, sunPosition, earth, sectorArea));
            }
        }
        return this.spacecraft.radiationPressureAcceleration(date, frame, satellitePosition, (FieldRotation)s.getAttitude().getRotation(), (CalculusFieldElement)s.getMass(), rediffusedFlux, (CalculusFieldElement[])parameters);
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return this.spacecraft.getRadiationParametersDrivers();
    }

    private double computeAlbedo(AbsoluteDate date, double phi) {
        double deltaT = date.durationFrom(this.referenceEpoch);
        SinCos sc = FastMath.sinCos((double)(1.991021277657232E-7 * deltaT));
        double A1 = 0.0 + 0.1 * sc.cos() + 0.0 * sc.sin();
        PolynomialFunction firstLegendrePolynomial = PolynomialsUtils.createLegendrePolynomial((int)1);
        PolynomialFunction secondLegendrePolynomial = PolynomialsUtils.createLegendrePolynomial((int)2);
        double sinPhi = FastMath.sin((double)phi);
        return 0.34 + A1 * firstLegendrePolynomial.value(sinPhi) + 0.29 * secondLegendrePolynomial.value(sinPhi);
    }

    private <T extends CalculusFieldElement<T>> T computeAlbedo(FieldAbsoluteDate<T> date, T phi) {
        T deltaT = date.durationFrom(this.referenceEpoch);
        FieldSinCos sc = FastMath.sinCos((CalculusFieldElement)((CalculusFieldElement)deltaT.multiply(1.991021277657232E-7)));
        CalculusFieldElement A1 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sc.cos()).multiply(0.1)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sc.sin()).multiply(0.0)))).add(0.0);
        PolynomialFunction firstLegendrePolynomial = PolynomialsUtils.createLegendrePolynomial((int)1);
        PolynomialFunction secondLegendrePolynomial = PolynomialsUtils.createLegendrePolynomial((int)2);
        CalculusFieldElement sinPhi = FastMath.sin(phi);
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)firstLegendrePolynomial.value(sinPhi).multiply((FieldElement)A1)).add((FieldElement)((CalculusFieldElement)secondLegendrePolynomial.value(sinPhi).multiply(0.29)))).add(0.34));
    }

    private double computeEmissivity(AbsoluteDate date, double phi) {
        double deltaT = date.durationFrom(this.referenceEpoch);
        SinCos sc = FastMath.sinCos((double)(1.991021277657232E-7 * deltaT));
        double E1 = 0.0 + -0.07 * sc.cos() + 0.0 * sc.sin();
        PolynomialFunction firstLegendrePolynomial = PolynomialsUtils.createLegendrePolynomial((int)1);
        PolynomialFunction secondLegendrePolynomial = PolynomialsUtils.createLegendrePolynomial((int)2);
        double sinPhi = FastMath.sin((double)phi);
        return 0.68 + E1 * firstLegendrePolynomial.value(sinPhi) + -0.18 * secondLegendrePolynomial.value(sinPhi);
    }

    private <T extends CalculusFieldElement<T>> T computeEmissivity(FieldAbsoluteDate<T> date, T phi) {
        T deltaT = date.durationFrom(this.referenceEpoch);
        FieldSinCos sc = FastMath.sinCos((CalculusFieldElement)((CalculusFieldElement)deltaT.multiply(1.991021277657232E-7)));
        CalculusFieldElement E1 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sc.cos()).multiply(-0.07)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sc.sin()).multiply(0.0)))).add(0.0);
        PolynomialFunction firstLegendrePolynomial = PolynomialsUtils.createLegendrePolynomial((int)1);
        PolynomialFunction secondLegendrePolynomial = PolynomialsUtils.createLegendrePolynomial((int)2);
        CalculusFieldElement sinPhi = FastMath.sin(phi);
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)firstLegendrePolynomial.value(sinPhi).multiply((FieldElement)E1)).add((FieldElement)((CalculusFieldElement)secondLegendrePolynomial.value(sinPhi).multiply(-0.18)))).add(0.68));
    }

    private double computeSolarFlux(Vector3D sunPosition) {
        double earthSunDistance = sunPosition.getNorm() / 1.49597870691E11;
        return 1367.2334839548 / (earthSunDistance * earthSunDistance);
    }

    private <T extends CalculusFieldElement<T>> T computeSolarFlux(FieldVector3D<T> sunPosition) {
        CalculusFieldElement earthSunDistance = (CalculusFieldElement)sunPosition.getNorm().divide(1.49597870691E11);
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)earthSunDistance.multiply((FieldElement)earthSunDistance)).reciprocal()).multiply(1367.2334839548));
    }

    private Vector3D computeElementaryFlux(SpacecraftState state, Vector3D elementCenter, Vector3D sunPosition, OneAxisEllipsoid earth, double elementArea) {
        Vector3D satellitePosition = state.getPVCoordinates().getPosition();
        AbsoluteDate date = state.getDate();
        Frame frame = state.getFrame();
        double solarFlux = this.computeSolarFlux(sunPosition);
        double alpha = Vector3D.angle((Vector3D)elementCenter, (Vector3D)satellitePosition);
        if (FastMath.abs((double)alpha) < 1.5707963267948966) {
            double currentLatitude = earth.transform(elementCenter, frame, date).getLatitude();
            double e = this.computeEmissivity(date, currentLatitude);
            double a = 0.0;
            double sunAngle = Vector3D.angle((Vector3D)elementCenter, (Vector3D)sunPosition);
            if (FastMath.abs((double)sunAngle) < 1.5707963267948966) {
                a = this.computeAlbedo(date, currentLatitude);
            }
            double albedoAndIR = a * solarFlux * FastMath.cos((double)sunAngle) + e * solarFlux * 0.25;
            Vector3D r = satellitePosition.subtract((Vector)elementCenter);
            double rNorm = r.getNorm();
            Vector3D projectedAreaVector = r.scalarMultiply(elementArea * FastMath.cos((double)alpha) / (Math.PI * rNorm * rNorm * rNorm));
            return projectedAreaVector.scalarMultiply(albedoAndIR / 2.99792458E8);
        }
        return new Vector3D(0.0, 0.0, 0.0);
    }

    private <T extends CalculusFieldElement<T>> FieldVector3D<T> computeElementaryFlux(FieldSpacecraftState<T> state, FieldVector3D<T> elementCenter, FieldVector3D<T> sunPosition, OneAxisEllipsoid earth, T elementArea) {
        FieldVector3D satellitePosition = state.getPVCoordinates().getPosition();
        FieldAbsoluteDate<T> date = state.getDate();
        Frame frame = state.getFrame();
        CalculusFieldElement zero = (CalculusFieldElement)date.getField().getZero();
        T solarFlux = this.computeSolarFlux(sunPosition);
        CalculusFieldElement alpha = FieldVector3D.angle(elementCenter, satellitePosition);
        if (FastMath.abs((CalculusFieldElement)alpha).getReal() < 1.5707963267948966) {
            T currentLatitude = earth.transform(elementCenter, frame, date).getLatitude();
            T e = this.computeEmissivity(date, currentLatitude);
            Object a = zero;
            CalculusFieldElement sunAngle = FieldVector3D.angle(elementCenter, sunPosition);
            if (FastMath.abs((CalculusFieldElement)sunAngle).getReal() < 1.5707963267948966) {
                a = this.computeAlbedo(date, currentLatitude);
            }
            CalculusFieldElement albedoAndIR = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)a.multiply(solarFlux)).multiply((FieldElement)FastMath.cos((CalculusFieldElement)sunAngle))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)e.multiply(solarFlux)).multiply(0.25)));
            FieldVector3D r = satellitePosition.subtract(elementCenter);
            CalculusFieldElement rNorm = r.getNorm();
            FieldVector3D projectedAreaVector = r.scalarMultiply((CalculusFieldElement)((CalculusFieldElement)elementArea.multiply((FieldElement)FastMath.cos((CalculusFieldElement)alpha))).divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)rNorm.multiply((FieldElement)rNorm)).multiply((FieldElement)rNorm)).multiply((FieldElement)((CalculusFieldElement)zero.getPi())))));
            return projectedAreaVector.scalarMultiply((CalculusFieldElement)albedoAndIR.divide(2.99792458E8));
        }
        return new FieldVector3D(zero, zero, zero);
    }
}

