/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.radiation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.forces.radiation.RadiationSensitive;
import org.orekit.frames.Frame;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.ParameterDriver;

public class IsotropicRadiationCNES95Convention
implements RadiationSensitive {
    private final double SCALE = FastMath.scalb((double)1.0, (int)-3);
    private final List<ParameterDriver> parameterDrivers = new ArrayList<ParameterDriver>(2);
    private final double crossSection;

    public IsotropicRadiationCNES95Convention(double crossSection, double alpha, double tau) {
        this.parameterDrivers.add(new ParameterDriver("absorption coefficient", alpha, this.SCALE, 0.0, 1.0));
        this.parameterDrivers.add(new ParameterDriver("reflection coefficient", tau, this.SCALE, 0.0, 1.0));
        this.crossSection = crossSection;
    }

    @Override
    public List<ParameterDriver> getRadiationParametersDrivers() {
        return Collections.unmodifiableList(this.parameterDrivers);
    }

    @Override
    public Vector3D radiationPressureAcceleration(AbsoluteDate date, Frame frame, Vector3D position, Rotation rotation, double mass, Vector3D flux, double[] parameters) {
        double alpha = parameters[0];
        double tau = parameters[1];
        double kP = this.crossSection * (1.0 + 4.0 * (1.0 - alpha) * (1.0 - tau) / 9.0);
        return new Vector3D(kP / mass, flux);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldVector3D<T> radiationPressureAcceleration(FieldAbsoluteDate<T> date, Frame frame, FieldVector3D<T> position, FieldRotation<T> rotation, T mass, FieldVector3D<T> flux, T[] parameters) {
        T alpha = parameters[0];
        T tau = parameters[1];
        CalculusFieldElement kP = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)alpha.negate()).add(1.0)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)tau.negate()).add(1.0)))).multiply(0.4444444444444444)).add(1.0)).multiply(this.crossSection);
        return new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)mass.reciprocal()).multiply((FieldElement)kP), flux);
    }
}

