/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.maneuvers.trigger;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.ode.events.Action;
import org.orekit.forces.maneuvers.trigger.AbstractManeuverTriggers;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FieldAbstractDetector;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.events.handlers.FieldEventHandler;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;

public abstract class IntervalEventTrigger<T extends AbstractDetector<T>>
extends AbstractManeuverTriggers {
    private final T firingIntervalDetector;
    private final transient Map<Field<? extends CalculusFieldElement<?>>, FieldEventDetector<? extends CalculusFieldElement<?>>> cached;

    public IntervalEventTrigger(T prototypeFiringIntervalDetector) {
        this.firingIntervalDetector = ((AbstractDetector)prototypeFiringIntervalDetector).withHandler(new Handler());
        this.cached = new HashMap();
    }

    public T getFiringIntervalDetector() {
        return this.firingIntervalDetector;
    }

    @Override
    protected boolean isFiringOnInitialState(SpacecraftState initialState, boolean isForward) {
        double insideThrustArcG = ((AbstractDetector)this.firingIntervalDetector).g(initialState);
        if (insideThrustArcG == 0.0) {
            double shift = (double)(isForward ? 2 : -2) * ((AbstractDetector)this.firingIntervalDetector).getThreshold();
            if (((AbstractDetector)this.firingIntervalDetector).g(initialState.shiftedBy(shift)) > 0.0) {
                this.notifyResetters(initialState, isForward);
                return true;
            }
            this.notifyResetters(initialState, !isForward);
            return false;
        }
        return insideThrustArcG > 0.0;
    }

    @Override
    public Stream<EventDetector> getEventsDetectors() {
        return Stream.of(this.firingIntervalDetector);
    }

    public <S extends CalculusFieldElement<S>> Stream<FieldEventDetector<S>> getFieldEventsDetectors(Field<S> field) {
        FieldEventDetector<Object> fd = this.cached.get(field);
        if (fd == null) {
            fd = this.convertAndSetUpHandler(field);
            this.cached.put(field, fd);
        }
        return Stream.of(fd);
    }

    private <D extends FieldAbstractDetector<D, S>, S extends CalculusFieldElement<S>> D convertAndSetUpHandler(Field<S> field) {
        FieldAbstractDetector<D, S> converted = this.convertIntervalDetector(field, this.firingIntervalDetector);
        return (D)((FieldAbstractDetector)((FieldAbstractDetector)((FieldAbstractDetector)converted.withMaxCheck((CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(((AbstractDetector)this.firingIntervalDetector).getMaxCheckInterval()))).withThreshold((CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(((AbstractDetector)this.firingIntervalDetector).getThreshold()))).withHandler(new FieldHandler()));
    }

    protected abstract <D extends FieldEventDetector<S>, S extends CalculusFieldElement<S>> FieldAbstractDetector<D, S> convertIntervalDetector(Field<S> var1, T var2);

    private class FieldHandler<D extends FieldEventDetector<S>, S extends CalculusFieldElement<S>>
    implements FieldEventHandler<D, S> {
        private boolean forward;

        private FieldHandler() {
        }

        @Override
        public void init(FieldSpacecraftState<S> initialState, FieldAbsoluteDate<S> target, D detector) {
            this.forward = target.isAfterOrEqualTo(initialState);
            IntervalEventTrigger.this.initializeResetters(initialState, target);
        }

        @Override
        public Action eventOccurred(FieldSpacecraftState<S> s, D detector, boolean increasing) {
            if (this.forward) {
                IntervalEventTrigger.this.getFirings().addValidAfter(increasing, s.getDate().toAbsoluteDate(), false);
            } else {
                IntervalEventTrigger.this.getFirings().addValidBefore(!increasing, s.getDate().toAbsoluteDate(), false);
            }
            IntervalEventTrigger.this.notifyResetters(s, increasing);
            return Action.RESET_STATE;
        }

        @Override
        public FieldSpacecraftState<S> resetState(D detector, FieldSpacecraftState<S> oldState) {
            return IntervalEventTrigger.this.applyResetters(oldState);
        }
    }

    private class Handler
    implements EventHandler<T> {
        private boolean forward;

        private Handler() {
        }

        @Override
        public void init(SpacecraftState initialState, AbsoluteDate target, T detector) {
            this.forward = target.isAfterOrEqualTo(initialState);
            IntervalEventTrigger.this.initializeResetters(initialState, target);
        }

        @Override
        public Action eventOccurred(SpacecraftState s, T detector, boolean increasing) {
            if (this.forward) {
                IntervalEventTrigger.this.getFirings().addValidAfter(increasing, s.getDate(), false);
            } else {
                IntervalEventTrigger.this.getFirings().addValidBefore(!increasing, s.getDate(), false);
            }
            IntervalEventTrigger.this.notifyResetters(s, increasing);
            return Action.RESET_STATE;
        }

        @Override
        public SpacecraftState resetState(T detector, SpacecraftState oldState) {
            return IntervalEventTrigger.this.applyResetters(oldState);
        }
    }
}

