/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ilrs;

import java.io.IOException;
import java.util.Locale;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.errors.OrekitException;
import org.orekit.files.ilrs.CPFHeader;
import org.orekit.frames.Frame;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.sampling.OrekitFixedStepHandler;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateTimeComponents;
import org.orekit.time.TimeScale;
import org.orekit.utils.TimeStampedPVCoordinates;

public class StreamingCpfWriter {
    private static final String NEW_LINE = "\n";
    private static final String A1 = "%1s";
    private static final String A2 = "%2s";
    private static final String A3 = "%3s";
    private static final String A4 = "%4s";
    private static final String A8 = "%8s";
    private static final String A10 = "%10s";
    private static final String I1 = "%1d";
    private static final String I2 = "%2d";
    private static final String I3 = "%3d";
    private static final String I4 = "%4d";
    private static final String I5 = "%5d";
    private static final String F13_6 = "%13.6f";
    private static final String F17_3 = "%17.3f";
    private static final String SPACE = " ";
    private static final String EMPTY_STRING = "";
    private static final String FORMAT = "CPF";
    private static final Locale STANDARDIZED_LOCALE = Locale.US;
    private static final int DEFAULT_DIRECTION_FLAG = 0;
    private final Appendable writer;
    private final TimeScale timeScale;
    private final CPFHeader header;

    public StreamingCpfWriter(Appendable writer, TimeScale timeScale, CPFHeader header) {
        this.writer = writer;
        this.timeScale = timeScale;
        this.header = header;
    }

    public void writeHeader() throws IOException {
        HeaderLineWriter.H1.write(this.header, this.writer, this.timeScale);
        this.writer.append(NEW_LINE);
        HeaderLineWriter.H2.write(this.header, this.writer, this.timeScale);
        this.writer.append(NEW_LINE);
        this.writer.append("H9");
        this.writer.append(NEW_LINE);
    }

    public void writeEndOfFile() throws IOException {
        this.writer.append("99");
    }

    public Segment newSegment(Frame frame) {
        return new Segment(frame);
    }

    private static void writeValue(Appendable cpfWriter, String format, String value, boolean withSpace) throws IOException {
        cpfWriter.append(String.format(STANDARDIZED_LOCALE, format, value)).append(withSpace ? SPACE : EMPTY_STRING);
    }

    private static void writeValue(Appendable cpfWriter, String format, int value, boolean withSpace) throws IOException {
        cpfWriter.append(String.format(STANDARDIZED_LOCALE, format, value)).append(withSpace ? SPACE : EMPTY_STRING);
    }

    private static void writeValue(Appendable cpfWriter, String format, double value, boolean withSpace) throws IOException {
        cpfWriter.append(String.format(STANDARDIZED_LOCALE, format, value)).append(withSpace ? SPACE : EMPTY_STRING);
    }

    private static void writeValue(Appendable cpfWriter, String format, boolean value, boolean withSpace) throws IOException {
        int intValue = value ? 1 : 0;
        StreamingCpfWriter.writeValue(cpfWriter, format, intValue, withSpace);
    }

    public static enum HeaderLineWriter {
        H1("H1"){

            @Override
            public void write(CPFHeader cpfHeader, Appendable cpfWriter, TimeScale timescale) throws IOException {
                StreamingCpfWriter.writeValue(cpfWriter, StreamingCpfWriter.A2, this.getIdentifier(), true);
                StreamingCpfWriter.writeValue(cpfWriter, StreamingCpfWriter.A3, StreamingCpfWriter.FORMAT, true);
                StreamingCpfWriter.writeValue(cpfWriter, StreamingCpfWriter.I2, cpfHeader.getVersion(), true);
                StreamingCpfWriter.writeValue(cpfWriter, StreamingCpfWriter.A1, StreamingCpfWriter.SPACE, false);
                StreamingCpfWriter.writeValue(cpfWriter, StreamingCpfWriter.A3, cpfHeader.getSource(), true);
                StreamingCpfWriter.writeValue(cpfWriter, StreamingCpfWriter.I4, cpfHeader.getProductionEpoch().getYear(), true);
                StreamingCpfWriter.writeValue(cpfWriter, StreamingCpfWriter.I2, cpfHeader.getProductionEpoch().getMonth(), true);
                StreamingCpfWriter.writeValue(cpfWriter, StreamingCpfWriter.I2, cpfHeader.getProductionEpoch().getDay(), true);
                StreamingCpfWriter.writeValue(cpfWriter, StreamingCpfWriter.I2, cpfHeader.getProductionHour(), true);
                StreamingCpfWriter.writeValue(cpfWriter, StreamingCpfWriter.A1, StreamingCpfWriter.SPACE, false);
                StreamingCpfWriter.writeValue(cpfWriter, StreamingCpfWriter.I3, cpfHeader.getSequenceNumber(), true);
                if (cpfHeader.getVersion() == 2) {
                    StreamingCpfWriter.writeValue(cpfWriter, StreamingCpfWriter.I2, cpfHeader.getSubDailySequenceNumber(), true);
                }
                StreamingCpfWriter.writeValue(cpfWriter, StreamingCpfWriter.A10, cpfHeader.getName(), true);
                StreamingCpfWriter.writeValue(cpfWriter, StreamingCpfWriter.A10, StreamingCpfWriter.SPACE, false);
            }
        }
        ,
        H2("H2"){

            @Override
            public void write(CPFHeader cpfHeader, Appendable cpfWriter, TimeScale timescale) throws IOException {
                StreamingCpfWriter.writeValue(cpfWriter, StreamingCpfWriter.A2, this.getIdentifier(), true);
                StreamingCpfWriter.writeValue(cpfWriter, StreamingCpfWriter.A8, cpfHeader.getIlrsSatelliteId(), true);
                StreamingCpfWriter.writeValue(cpfWriter, StreamingCpfWriter.A4, cpfHeader.getSic(), true);
                StreamingCpfWriter.writeValue(cpfWriter, StreamingCpfWriter.A8, cpfHeader.getNoradId(), true);
                AbsoluteDate starting = cpfHeader.getStartEpoch();
                DateTimeComponents dtcStart = starting.getComponents(timescale);
                StreamingCpfWriter.writeValue(cpfWriter, StreamingCpfWriter.I4, dtcStart.getDate().getYear(), true);
                StreamingCpfWriter.writeValue(cpfWriter, StreamingCpfWriter.I2, dtcStart.getDate().getMonth(), true);
                StreamingCpfWriter.writeValue(cpfWriter, StreamingCpfWriter.I2, dtcStart.getDate().getDay(), true);
                StreamingCpfWriter.writeValue(cpfWriter, StreamingCpfWriter.I2, dtcStart.getTime().getHour(), true);
                StreamingCpfWriter.writeValue(cpfWriter, StreamingCpfWriter.I2, dtcStart.getTime().getMinute(), true);
                StreamingCpfWriter.writeValue(cpfWriter, StreamingCpfWriter.I2, (int)dtcStart.getTime().getSecond(), true);
                AbsoluteDate ending = cpfHeader.getEndEpoch();
                DateTimeComponents dtcEnd = ending.getComponents(timescale);
                StreamingCpfWriter.writeValue(cpfWriter, StreamingCpfWriter.I4, dtcEnd.getDate().getYear(), true);
                StreamingCpfWriter.writeValue(cpfWriter, StreamingCpfWriter.I2, dtcEnd.getDate().getMonth(), true);
                StreamingCpfWriter.writeValue(cpfWriter, StreamingCpfWriter.I2, dtcEnd.getDate().getDay(), true);
                StreamingCpfWriter.writeValue(cpfWriter, StreamingCpfWriter.I2, dtcEnd.getTime().getHour(), true);
                StreamingCpfWriter.writeValue(cpfWriter, StreamingCpfWriter.I2, dtcEnd.getTime().getMinute(), true);
                StreamingCpfWriter.writeValue(cpfWriter, StreamingCpfWriter.I2, (int)dtcEnd.getTime().getSecond(), true);
                StreamingCpfWriter.writeValue(cpfWriter, StreamingCpfWriter.I5, cpfHeader.getStep(), true);
                StreamingCpfWriter.writeValue(cpfWriter, StreamingCpfWriter.I1, cpfHeader.isCompatibleWithTIVs(), true);
                StreamingCpfWriter.writeValue(cpfWriter, StreamingCpfWriter.I1, cpfHeader.getTargetClass(), true);
                StreamingCpfWriter.writeValue(cpfWriter, StreamingCpfWriter.I2, cpfHeader.getRefFrameId(), true);
                StreamingCpfWriter.writeValue(cpfWriter, StreamingCpfWriter.I1, cpfHeader.getRotationalAngleType(), true);
                if (cpfHeader.getVersion() == 1) {
                    StreamingCpfWriter.writeValue(cpfWriter, StreamingCpfWriter.I1, cpfHeader.isCenterOfMassCorrectionApplied(), false);
                } else {
                    StreamingCpfWriter.writeValue(cpfWriter, StreamingCpfWriter.I1, cpfHeader.isCenterOfMassCorrectionApplied(), true);
                    StreamingCpfWriter.writeValue(cpfWriter, StreamingCpfWriter.I2, cpfHeader.getTargetLocation(), false);
                }
            }
        };

        private final String identifier;

        private HeaderLineWriter(String identifier) {
            this.identifier = identifier;
        }

        public abstract void write(CPFHeader var1, Appendable var2, TimeScale var3) throws IOException;

        public String getIdentifier() {
            return this.identifier;
        }
    }

    public class Segment
    implements OrekitFixedStepHandler {
        private final Frame frame;

        private Segment(Frame frame) {
            this.frame = frame;
        }

        @Override
        public void handleStep(SpacecraftState currentState) {
            try {
                this.writeEphemerisLine(currentState.getPVCoordinates(this.frame));
            }
            catch (IOException e) {
                throw new OrekitException(e, (Localizable)LocalizedCoreFormats.SIMPLE_MESSAGE, e.getLocalizedMessage());
            }
        }

        @Override
        public void finish(SpacecraftState finalState) {
            try {
                this.writeEphemerisLine(finalState.getPVCoordinates(this.frame));
                StreamingCpfWriter.this.writeEndOfFile();
            }
            catch (IOException e) {
                throw new OrekitException(e, (Localizable)LocalizedCoreFormats.SIMPLE_MESSAGE, e.getLocalizedMessage());
            }
        }

        public void writeEphemerisLine(TimeStampedPVCoordinates pv) throws IOException {
            StreamingCpfWriter.writeValue(StreamingCpfWriter.this.writer, StreamingCpfWriter.A2, "10", true);
            StreamingCpfWriter.writeValue(StreamingCpfWriter.this.writer, StreamingCpfWriter.I1, 0, true);
            AbsoluteDate epoch = pv.getDate();
            DateTimeComponents dtc = epoch.getComponents(StreamingCpfWriter.this.timeScale);
            StreamingCpfWriter.writeValue(StreamingCpfWriter.this.writer, StreamingCpfWriter.I5, dtc.getDate().getMJD(), true);
            StreamingCpfWriter.writeValue(StreamingCpfWriter.this.writer, StreamingCpfWriter.F13_6, dtc.getTime().getSecondsInLocalDay(), true);
            StreamingCpfWriter.writeValue(StreamingCpfWriter.this.writer, StreamingCpfWriter.I2, 0, true);
            Vector3D position = pv.getPosition();
            StreamingCpfWriter.writeValue(StreamingCpfWriter.this.writer, StreamingCpfWriter.F17_3, position.getX(), true);
            StreamingCpfWriter.writeValue(StreamingCpfWriter.this.writer, StreamingCpfWriter.F17_3, position.getY(), true);
            StreamingCpfWriter.writeValue(StreamingCpfWriter.this.writer, StreamingCpfWriter.F17_3, position.getZ(), false);
            StreamingCpfWriter.this.writer.append(StreamingCpfWriter.NEW_LINE);
        }
    }
}

