/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ilrs;

import java.util.HashMap;
import java.util.Map;
import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ilrs.ILRSHeader;

public class CRDHeader
extends ILRSHeader {
    private String stationName;
    private int systemIdentifier;
    private int systemNumber;
    private int systemOccupancy;
    private int epochIdentifier;
    private String stationNetword;
    private int spacecraftEpochTimeScale;
    private int dataType;
    private int dataReleaseFlag;
    private boolean isTroposphericRefractionApplied;
    private boolean isCenterOfMassCorrectionApplied;
    private boolean isReceiveAmplitudeCorrectionApplied;
    private boolean isStationSystemDelayApplied;
    private boolean isTransponderDelayApplied;
    private RangeType rangeType;
    private int qualityIndicator;
    private int predictionType;
    private int yearOfCentury;
    private String dateAndTime;
    private String predictionProvider;

    public String getStationName() {
        return this.stationName;
    }

    public void setStationName(String stationName) {
        this.stationName = stationName;
    }

    public int getSystemIdentifier() {
        return this.systemIdentifier;
    }

    public void setSystemIdentifier(int systemIdentifier) {
        this.systemIdentifier = systemIdentifier;
    }

    public int getSystemNumber() {
        return this.systemNumber;
    }

    public void setSystemNumber(int systemNumber) {
        this.systemNumber = systemNumber;
    }

    public int getSystemOccupancy() {
        return this.systemOccupancy;
    }

    public void setSystemOccupancy(int systemOccupancy) {
        this.systemOccupancy = systemOccupancy;
    }

    public int getEpochIdentifier() {
        return this.epochIdentifier;
    }

    public void setEpochIdentifier(int epochIdentifier) {
        this.epochIdentifier = epochIdentifier;
    }

    public String getStationNetword() {
        return this.stationNetword;
    }

    public void setStationNetword(String stationNetword) {
        this.stationNetword = stationNetword;
    }

    public int getSpacecraftEpochTimeScale() {
        return this.spacecraftEpochTimeScale;
    }

    public void setSpacecraftEpochTimeScale(int spacecraftEpochTimeScale) {
        this.spacecraftEpochTimeScale = spacecraftEpochTimeScale;
    }

    public int getDataType() {
        return this.dataType;
    }

    public void setDataType(int dataType) {
        this.dataType = dataType;
    }

    public int getDataReleaseFlag() {
        return this.dataReleaseFlag;
    }

    public void setDataReleaseFlag(int dataReleaseFlag) {
        this.dataReleaseFlag = dataReleaseFlag;
    }

    public boolean isTroposphericRefractionApplied() {
        return this.isTroposphericRefractionApplied;
    }

    public void setIsTroposphericRefractionApplied(boolean isTroposphericRefractionApplied) {
        this.isTroposphericRefractionApplied = isTroposphericRefractionApplied;
    }

    public boolean isCenterOfMassCorrectionApplied() {
        return this.isCenterOfMassCorrectionApplied;
    }

    public void setIsCenterOfMassCorrectionApplied(boolean isCenterOfMassCorrectionApplied) {
        this.isCenterOfMassCorrectionApplied = isCenterOfMassCorrectionApplied;
    }

    public boolean isReceiveAmplitudeCorrectionApplied() {
        return this.isReceiveAmplitudeCorrectionApplied;
    }

    public void setIsReceiveAmplitudeCorrectionApplied(boolean isReceiveAmplitudeCorrectionApplied) {
        this.isReceiveAmplitudeCorrectionApplied = isReceiveAmplitudeCorrectionApplied;
    }

    public boolean isStationSystemDelayApplied() {
        return this.isStationSystemDelayApplied;
    }

    public void setIsStationSystemDelayApplied(boolean isStationSystemDelayApplied) {
        this.isStationSystemDelayApplied = isStationSystemDelayApplied;
    }

    public boolean isTransponderDelayApplied() {
        return this.isTransponderDelayApplied;
    }

    public void setIsTransponderDelayApplied(boolean isTransponderDelayApplied) {
        this.isTransponderDelayApplied = isTransponderDelayApplied;
    }

    public RangeType getRangeType() {
        return this.rangeType;
    }

    public void setRangeType(int indicator) {
        this.rangeType = RangeType.getRangeType(indicator);
    }

    public int getQualityIndicator() {
        return this.qualityIndicator;
    }

    public void setQualityIndicator(int qualityIndicator) {
        this.qualityIndicator = qualityIndicator;
    }

    public int getPredictionType() {
        return this.predictionType;
    }

    public void setPredictionType(int predictionType) {
        this.predictionType = predictionType;
    }

    public int getYearOfCentury() {
        return this.yearOfCentury;
    }

    public void setYearOfCentury(int yearOfCentury) {
        this.yearOfCentury = yearOfCentury;
    }

    public String getDateAndTime() {
        return this.dateAndTime;
    }

    public void setDateAndTime(String dateAndTime) {
        this.dateAndTime = dateAndTime;
    }

    public String getPredictionProvider() {
        return this.predictionProvider;
    }

    public void setPredictionProvider(String predictionProvider) {
        this.predictionProvider = predictionProvider;
    }

    public static enum RangeType {
        NO_RANGES(0),
        ONE_WAY(1),
        TWO_WAY(2),
        RECEIVED_ONLY(3),
        MIXED(4);

        private static final Map<Integer, RangeType> CODES_MAP;
        private final int indicator;

        private RangeType(int indicator) {
            this.indicator = indicator;
        }

        public int getIndicator() {
            return this.indicator;
        }

        public static RangeType getRangeType(int id) {
            RangeType type = CODES_MAP.get(id);
            if (type == null) {
                throw new OrekitException((Localizable)OrekitMessages.INVALID_RANGE_INDICATOR_IN_CRD_FILE, id);
            }
            return type;
        }

        static {
            CODES_MAP = new HashMap<Integer, RangeType>();
            for (RangeType type : RangeType.values()) {
                CODES_MAP.put(type.getIndicator(), type);
            }
        }
    }
}

