/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ilrs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.orekit.files.ilrs.CRDConfiguration;
import org.orekit.files.ilrs.CRDHeader;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.ChronologicalComparator;
import org.orekit.time.TimeStamped;
import org.orekit.utils.ImmutableTimeStampedCache;

public class CRD {
    private List<String> comments = new ArrayList<String>();
    private List<CRDDataBlock> dataBlocks = new ArrayList<CRDDataBlock>();

    public void addDataBlock(CRDDataBlock dataBlock) {
        this.dataBlocks.add(dataBlock);
    }

    public List<String> getComments() {
        return this.comments;
    }

    public List<CRDDataBlock> getDataBlocks() {
        return Collections.unmodifiableList(this.dataBlocks);
    }

    public static class Meteo {
        private static final int N_NEIGHBORS = 2;
        private final AbsoluteDate firstDate;
        private final AbsoluteDate lastDate;
        private transient MeteorologicalMeasurement previousParam;
        private transient MeteorologicalMeasurement nextParam;
        private final transient ImmutableTimeStampedCache<MeteorologicalMeasurement> meteo;

        public Meteo(SortedSet<MeteorologicalMeasurement> meteoData) {
            int neighborsSize;
            int n = neighborsSize = meteoData.size() < 2 ? meteoData.size() : 2;
            if (neighborsSize == 0) {
                this.meteo = ImmutableTimeStampedCache.emptyCache();
                this.firstDate = null;
                this.lastDate = null;
            } else {
                this.meteo = new ImmutableTimeStampedCache<MeteorologicalMeasurement>(neighborsSize, meteoData);
                this.firstDate = meteoData.first().getDate();
                this.lastDate = meteoData.last().getDate();
            }
        }

        public List<MeteorologicalMeasurement> getData() {
            return this.meteo.getAll();
        }

        public MeteorologicalMeasurement getMeteo(AbsoluteDate date) {
            if (this.meteo.getNeighborsSize() == 0) {
                return null;
            }
            this.bracketDate(date);
            if (date.durationFrom(this.firstDate) <= 0.0 || date.durationFrom(this.lastDate) > 0.0) {
                return this.previousParam;
            }
            double pressure = this.getLinearInterpolation(date, this.previousParam.getPressure(), this.nextParam.getPressure());
            double temperature = this.getLinearInterpolation(date, this.previousParam.getTemperature(), this.nextParam.getTemperature());
            double humidity = this.getLinearInterpolation(date, this.previousParam.getHumidity(), this.nextParam.getHumidity());
            return new MeteorologicalMeasurement(date, pressure, temperature, humidity);
        }

        private void bracketDate(AbsoluteDate date) {
            if (this.previousParam != null && date.durationFrom(this.previousParam.getDate()) > 0.0 && date.durationFrom(this.nextParam.getDate()) <= 0.0) {
                return;
            }
            if (date.durationFrom(this.firstDate) <= 0.0) {
                this.nextParam = this.previousParam = this.meteo.getEarliest();
            } else if (date.durationFrom(this.lastDate) > 0.0) {
                this.nextParam = this.previousParam = this.meteo.getLatest();
            } else {
                List neighbors = this.meteo.getNeighbors(date).collect(Collectors.toList());
                this.previousParam = (MeteorologicalMeasurement)neighbors.get(0);
                this.nextParam = (MeteorologicalMeasurement)neighbors.get(1);
            }
        }

        private double getLinearInterpolation(AbsoluteDate date, double previousValue, double nextValue) {
            AbsoluteDate previousDate = this.previousParam.getDate();
            AbsoluteDate currentDate = this.nextParam.getDate();
            double dt = currentDate.durationFrom(previousDate);
            double previousWeight = currentDate.durationFrom(date) / dt;
            double nextWeight = date.durationFrom(previousDate) / dt;
            return previousValue * previousWeight + nextValue * nextWeight;
        }
    }

    public static class AnglesMeasurement
    implements TimeStamped {
        private AbsoluteDate date;
        private final double azimuth;
        private final double elevation;
        private final int directionFlag;
        private final int originIndicator;
        private final boolean refractionCorrected;
        private final double azimuthRate;
        private final double elevationRate;

        public AnglesMeasurement(AbsoluteDate date, double azimuth, double elevation, int directionFlag, int originIndicator, boolean refractionCorrected, double azimuthRate, double elevationRate) {
            this.date = date;
            this.azimuth = azimuth;
            this.elevation = elevation;
            this.directionFlag = directionFlag;
            this.originIndicator = originIndicator;
            this.refractionCorrected = refractionCorrected;
            this.azimuthRate = azimuthRate;
            this.elevationRate = elevationRate;
        }

        public double getAzimuth() {
            return this.azimuth;
        }

        public double getElevation() {
            return this.elevation;
        }

        public int getDirectionFlag() {
            return this.directionFlag;
        }

        public int getOriginIndicator() {
            return this.originIndicator;
        }

        public boolean isRefractionCorrected() {
            return this.refractionCorrected;
        }

        public double getAzimuthRate() {
            return this.azimuthRate;
        }

        public double getElevationRate() {
            return this.elevationRate;
        }

        @Override
        public AbsoluteDate getDate() {
            return this.date;
        }
    }

    public static class MeteorologicalMeasurement
    implements TimeStamped {
        private AbsoluteDate date;
        private final double pressure;
        private final double temperature;
        private final double humidity;

        public MeteorologicalMeasurement(AbsoluteDate date, double pressure, double temperature, double humidity) {
            this.date = date;
            this.pressure = pressure;
            this.temperature = temperature;
            this.humidity = humidity;
        }

        public double getPressure() {
            return this.pressure;
        }

        public double getTemperature() {
            return this.temperature;
        }

        public double getHumidity() {
            return this.humidity;
        }

        @Override
        public AbsoluteDate getDate() {
            return this.date;
        }
    }

    public static class RangeMeasurement
    implements TimeStamped {
        private AbsoluteDate date;
        private final double timeOfFlight;
        private final int epochEvent;
        private final double snr;

        public RangeMeasurement(AbsoluteDate date, double timeOfFlight, int epochEvent) {
            this(date, timeOfFlight, epochEvent, Double.NaN);
        }

        public RangeMeasurement(AbsoluteDate date, double timeOfFlight, int epochEvent, double snr) {
            this.date = date;
            this.timeOfFlight = timeOfFlight;
            this.epochEvent = epochEvent;
            this.snr = snr;
        }

        public double getTimeOfFlight() {
            return this.timeOfFlight;
        }

        public int getEpochEvent() {
            return this.epochEvent;
        }

        public double getSnr() {
            return this.snr;
        }

        @Override
        public AbsoluteDate getDate() {
            return this.date;
        }
    }

    public static class CRDDataBlock {
        private CRDHeader header;
        private CRDConfiguration configurationRecords;
        private List<RangeMeasurement> rangeData = new ArrayList<RangeMeasurement>();
        private final SortedSet<MeteorologicalMeasurement> meteoData = new TreeSet<TimeStamped>(new ChronologicalComparator());
        private List<AnglesMeasurement> anglesData = new ArrayList<AnglesMeasurement>();

        public CRDHeader getHeader() {
            return this.header;
        }

        public void setHeader(CRDHeader header) {
            this.header = header;
        }

        public CRDConfiguration getConfigurationRecords() {
            return this.configurationRecords;
        }

        public void setConfigurationRecords(CRDConfiguration configurationRecords) {
            this.configurationRecords = configurationRecords;
        }

        public void addRangeData(RangeMeasurement range) {
            this.rangeData.add(range);
        }

        public void addMeteoData(MeteorologicalMeasurement meteorologicalMeasurement) {
            this.meteoData.add(meteorologicalMeasurement);
        }

        public void addAnglesData(AnglesMeasurement angles) {
            this.anglesData.add(angles);
        }

        public List<RangeMeasurement> getRangeData() {
            return Collections.unmodifiableList(this.rangeData);
        }

        public List<AnglesMeasurement> getAnglesData() {
            return Collections.unmodifiableList(this.anglesData);
        }

        public Meteo getMeteoData() {
            return new Meteo(this.meteoData);
        }
    }
}

