/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.general;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.orekit.files.general.EphemerisSegmentPropagator;
import org.orekit.frames.Frame;
import org.orekit.propagation.BoundedPropagator;
import org.orekit.propagation.analytical.AggregateBoundedPropagator;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.CartesianDerivativesFilter;
import org.orekit.utils.TimeStampedPVCoordinates;

public interface EphemerisFile<C extends TimeStampedPVCoordinates, S extends EphemerisSegment<C>> {
    public Map<String, ? extends SatelliteEphemeris<C, S>> getSatellites();

    public static interface EphemerisSegment<C extends TimeStampedPVCoordinates> {
        public double getMu();

        public Frame getFrame();

        default public Frame getInertialFrame() {
            Frame frame = this.getFrame();
            if (frame.isPseudoInertial()) {
                return frame;
            }
            return Frame.getRoot();
        }

        public int getInterpolationSamples();

        public CartesianDerivativesFilter getAvailableDerivatives();

        public List<C> getCoordinates();

        public AbsoluteDate getStart();

        public AbsoluteDate getStop();

        default public BoundedPropagator getPropagator() {
            return new EphemerisSegmentPropagator(this);
        }
    }

    public static interface SatelliteEphemeris<C extends TimeStampedPVCoordinates, S extends EphemerisSegment<C>> {
        public String getId();

        public double getMu();

        public List<S> getSegments();

        public AbsoluteDate getStart();

        public AbsoluteDate getStop();

        default public BoundedPropagator getPropagator() {
            ArrayList<BoundedPropagator> propagators = new ArrayList<BoundedPropagator>();
            for (EphemerisSegment segment : this.getSegments()) {
                propagators.add(segment.getPropagator());
            }
            return new AggregateBoundedPropagator(propagators);
        }
    }
}

