/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.omm;

import java.io.IOException;
import org.orekit.data.DataContext;
import org.orekit.files.ccsds.definitions.TimeSystem;
import org.orekit.files.ccsds.ndm.ParsedUnitsBehavior;
import org.orekit.files.ccsds.ndm.odm.CartesianCovarianceWriter;
import org.orekit.files.ccsds.ndm.odm.SpacecraftParametersWriter;
import org.orekit.files.ccsds.ndm.odm.UserDefinedWriter;
import org.orekit.files.ccsds.ndm.odm.omm.MeanKeplerianElementsWriter;
import org.orekit.files.ccsds.ndm.odm.omm.Omm;
import org.orekit.files.ccsds.ndm.odm.omm.OmmData;
import org.orekit.files.ccsds.ndm.odm.omm.OmmMetadata;
import org.orekit.files.ccsds.ndm.odm.omm.OmmMetadataWriter;
import org.orekit.files.ccsds.ndm.odm.omm.OmmTleWriter;
import org.orekit.files.ccsds.ndm.odm.omm.XmlSubStructureKey;
import org.orekit.files.ccsds.section.Header;
import org.orekit.files.ccsds.section.Segment;
import org.orekit.files.ccsds.section.XmlStructureKey;
import org.orekit.files.ccsds.utils.ContextBinding;
import org.orekit.files.ccsds.utils.FileFormat;
import org.orekit.files.ccsds.utils.generation.AbstractMessageWriter;
import org.orekit.files.ccsds.utils.generation.Generator;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.IERSConventions;

public class OmmWriter
extends AbstractMessageWriter<Header, Segment<OmmMetadata, OmmData>, Omm> {
    public static final double CCSDS_OMM_VERS = 3.0;
    public static final int KVN_PADDING_WIDTH = 19;

    public OmmWriter(IERSConventions conventions, DataContext dataContext, AbsoluteDate missionReferenceDate) {
        super("omm", "CCSDS_OMM_VERS", 3.0, new ContextBinding(() -> conventions, () -> false, () -> dataContext, () -> ParsedUnitsBehavior.STRICT_COMPLIANCE, () -> missionReferenceDate, () -> TimeSystem.UTC, () -> 0.0, () -> 1.0));
    }

    @Override
    public void writeSegmentContent(Generator generator, double formatVersion, Segment<OmmMetadata, OmmData> segment) throws IOException {
        ContextBinding oldContext = this.getContext();
        OmmMetadata metadata = segment.getMetadata();
        this.setContext(new ContextBinding(oldContext::getConventions, oldContext::isSimpleEOP, oldContext::getDataContext, oldContext::getParsedUnitsBehavior, oldContext::getReferenceDate, metadata::getTimeSystem, oldContext::getClockCount, oldContext::getClockRate));
        new OmmMetadataWriter(metadata, this.getTimeConverter()).write(generator);
        if (generator.getFormat() == FileFormat.XML) {
            generator.enterSection(XmlStructureKey.data.name());
        }
        new MeanKeplerianElementsWriter(XmlSubStructureKey.meanElements.name(), null, segment.getData().getKeplerianElementsBlock(), this.getTimeConverter(), segment.getMetadata().theoryIsSgpSdp()).write(generator);
        if (segment.getData().getSpacecraftParametersBlock() != null) {
            new SpacecraftParametersWriter(XmlSubStructureKey.spacecraftParameters.name(), null, segment.getData().getSpacecraftParametersBlock()).write(generator);
        }
        if (segment.getData().getTLEBlock() != null) {
            new OmmTleWriter(XmlSubStructureKey.tleParameters.name(), null, segment.getData().getTLEBlock()).write(generator);
        }
        if (segment.getData().getCovarianceBlock() != null) {
            new CartesianCovarianceWriter(XmlSubStructureKey.covarianceMatrix.name(), null, segment.getData().getCovarianceBlock()).write(generator);
        }
        if (segment.getData().getUserDefinedBlock() != null) {
            new UserDefinedWriter(XmlSubStructureKey.userDefinedParameters.name(), null, segment.getData().getUserDefinedBlock()).write(generator);
        }
        if (generator.getFormat() == FileFormat.XML) {
            generator.exitSection();
        }
    }
}

