/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.odm.ocm;

import java.io.IOException;
import java.util.List;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.files.ccsds.definitions.DutyCycleType;
import org.orekit.files.ccsds.definitions.TimeConverter;
import org.orekit.files.ccsds.ndm.odm.ocm.Maneuver;
import org.orekit.files.ccsds.ndm.odm.ocm.ManeuverFieldType;
import org.orekit.files.ccsds.ndm.odm.ocm.ManeuverHistory;
import org.orekit.files.ccsds.ndm.odm.ocm.ManeuverHistoryMetadata;
import org.orekit.files.ccsds.ndm.odm.ocm.ManeuverHistoryMetadataKey;
import org.orekit.files.ccsds.ndm.odm.ocm.OcmDataSubStructureKey;
import org.orekit.files.ccsds.section.AbstractWriter;
import org.orekit.files.ccsds.utils.FileFormat;
import org.orekit.files.ccsds.utils.generation.Generator;
import org.orekit.utils.AccurateFormatter;
import org.orekit.utils.units.Unit;

class ManeuverHistoryWriter
extends AbstractWriter {
    private final ManeuverHistory history;
    private final TimeConverter timeConverter;

    ManeuverHistoryWriter(ManeuverHistory maneuverHistory, TimeConverter timeConverter) {
        super(OcmDataSubStructureKey.man.name(), OcmDataSubStructureKey.MAN.name());
        this.history = maneuverHistory;
        this.timeConverter = timeConverter;
    }

    @Override
    protected void writeContent(Generator generator) throws IOException {
        ManeuverHistoryMetadata metadata = this.history.getMetadata();
        generator.writeComments(metadata.getComments());
        generator.writeEntry(ManeuverHistoryMetadataKey.MAN_ID.name(), metadata.getManID(), null, false);
        generator.writeEntry(ManeuverHistoryMetadataKey.MAN_PREV_ID.name(), metadata.getManPrevID(), null, false);
        generator.writeEntry(ManeuverHistoryMetadataKey.MAN_NEXT_ID.name(), metadata.getManNextID(), null, false);
        generator.writeEntry(ManeuverHistoryMetadataKey.MAN_BASIS.name(), metadata.getManBasis(), false);
        generator.writeEntry(ManeuverHistoryMetadataKey.MAN_BASIS_ID.name(), metadata.getManBasisID(), null, false);
        generator.writeEntry(ManeuverHistoryMetadataKey.MAN_DEVICE_ID.name(), metadata.getManDeviceID(), null, false);
        generator.writeEntry(ManeuverHistoryMetadataKey.MAN_PREV_EPOCH.name(), this.timeConverter, metadata.getManPrevEpoch(), false);
        generator.writeEntry(ManeuverHistoryMetadataKey.MAN_NEXT_EPOCH.name(), this.timeConverter, metadata.getManNextEpoch(), false);
        generator.writeEntry(ManeuverHistoryMetadataKey.MAN_PURPOSE.name(), metadata.getManPurpose(), false);
        generator.writeEntry(ManeuverHistoryMetadataKey.MAN_PRED_SOURCE.name(), metadata.getManPredSource(), null, false);
        generator.writeEntry(ManeuverHistoryMetadataKey.MAN_REF_FRAME.name(), metadata.getManReferenceFrame().getName(), null, false);
        generator.writeEntry(ManeuverHistoryMetadataKey.MAN_FRAME_EPOCH.name(), this.timeConverter, metadata.getManFrameEpoch(), false);
        if (metadata.getGravitationalAssist() != null) {
            generator.writeEntry(ManeuverHistoryMetadataKey.GRAV_ASSIST_NAME.name(), metadata.getGravitationalAssist().getName(), null, false);
        }
        boolean notContinuous = metadata.getDcType() != DutyCycleType.CONTINUOUS;
        boolean timeAndAngle = metadata.getDcType() == DutyCycleType.TIME_AND_ANGLE;
        generator.writeEntry(ManeuverHistoryMetadataKey.DC_TYPE.name(), metadata.getDcType(), false);
        generator.writeEntry(ManeuverHistoryMetadataKey.DC_WIN_OPEN.name(), this.timeConverter, metadata.getDcWindowOpen(), notContinuous);
        generator.writeEntry(ManeuverHistoryMetadataKey.DC_WIN_CLOSE.name(), this.timeConverter, metadata.getDcWindowClose(), notContinuous);
        generator.writeEntry(ManeuverHistoryMetadataKey.DC_MIN_CYCLES.name(), metadata.getDcMinCycles(), false);
        generator.writeEntry(ManeuverHistoryMetadataKey.DC_MAX_CYCLES.name(), metadata.getDcMaxCycles(), false);
        generator.writeEntry(ManeuverHistoryMetadataKey.DC_EXEC_START.name(), this.timeConverter, metadata.getDcExecStart(), notContinuous);
        generator.writeEntry(ManeuverHistoryMetadataKey.DC_EXEC_STOP.name(), this.timeConverter, metadata.getDcExecStop(), notContinuous);
        generator.writeEntry(ManeuverHistoryMetadataKey.DC_REF_TIME.name(), this.timeConverter, metadata.getDcRefTime(), notContinuous);
        generator.writeEntry(ManeuverHistoryMetadataKey.DC_TIME_PULSE_DURATION.name(), metadata.getDcTimePulseDuration(), Unit.SECOND, notContinuous);
        generator.writeEntry(ManeuverHistoryMetadataKey.DC_TIME_PULSE_PERIOD.name(), metadata.getDcTimePulsePeriod(), Unit.SECOND, notContinuous);
        if (timeAndAngle) {
            generator.writeEntry(ManeuverHistoryMetadataKey.DC_REF_DIR.name(), this.toString(metadata.getDcRefDir()), null, timeAndAngle);
            generator.writeEntry(ManeuverHistoryMetadataKey.DC_BODY_FRAME.name(), metadata.getDcBodyFrame().toString().replace(' ', '_'), null, timeAndAngle);
            generator.writeEntry(ManeuverHistoryMetadataKey.DC_BODY_TRIGGER.name(), this.toString(metadata.getDcBodyTrigger()), null, timeAndAngle);
            generator.writeEntry(ManeuverHistoryMetadataKey.DC_PA_START_ANGLE.name(), metadata.getDcPhaseStartAngle(), Unit.DEGREE, timeAndAngle);
            generator.writeEntry(ManeuverHistoryMetadataKey.DC_PA_STOP_ANGLE.name(), metadata.getDcPhaseStopAngle(), Unit.DEGREE, timeAndAngle);
        }
        List<ManeuverFieldType> types = metadata.getManComposition();
        StringBuilder composition = new StringBuilder();
        for (int i = 0; i < types.size(); ++i) {
            if (i > 0) {
                composition.append(',');
            }
            composition.append(types.get(i).name());
        }
        generator.writeEntry(ManeuverHistoryMetadataKey.MAN_COMPOSITION.name(), composition.toString(), null, false);
        generator.writeEntry(ManeuverHistoryMetadataKey.MAN_UNITS.name(), generator.unitsListToString(metadata.getManUnits()), null, false);
        for (Maneuver maneuver : this.history.getManeuvers()) {
            StringBuilder line = new StringBuilder();
            for (int i = 0; i < types.size(); ++i) {
                if (i > 0) {
                    line.append(' ');
                }
                line.append(types.get(i).outputField(this.timeConverter, maneuver));
            }
            if (generator.getFormat() == FileFormat.XML) {
                generator.writeEntry("manLine", line.toString(), null, true);
                continue;
            }
            generator.writeRawData(line);
            generator.newLine();
        }
    }

    private String toString(Vector3D vector) {
        StringBuilder builder = new StringBuilder();
        builder.append(AccurateFormatter.format(Unit.ONE.fromSI(vector.getX())));
        builder.append(' ');
        builder.append(AccurateFormatter.format(Unit.ONE.fromSI(vector.getY())));
        builder.append(' ');
        builder.append(AccurateFormatter.format(Unit.ONE.fromSI(vector.getZ())));
        return builder.toString();
    }
}

