/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.apm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.orekit.files.ccsds.ndm.adm.apm.ApmQuaternion;
import org.orekit.files.ccsds.ndm.adm.apm.Euler;
import org.orekit.files.ccsds.ndm.adm.apm.Maneuver;
import org.orekit.files.ccsds.ndm.adm.apm.SpacecraftParameters;
import org.orekit.files.ccsds.ndm.adm.apm.SpinStabilized;
import org.orekit.files.ccsds.section.CommentsContainer;
import org.orekit.files.ccsds.section.Data;

public class ApmData
implements Data {
    private final CommentsContainer commentsBlock;
    private final ApmQuaternion quaternionBlock;
    private final Euler eulerBlock;
    private final SpinStabilized spinStabilizedBlock;
    private final SpacecraftParameters spacecraftParameters;
    private final List<Maneuver> maneuvers;

    public ApmData(CommentsContainer commentsBlock, ApmQuaternion quaternionBlock, Euler eulerBlock, SpinStabilized spinStabilizedBlock, SpacecraftParameters spacecraftParameters) {
        this.commentsBlock = commentsBlock;
        this.quaternionBlock = quaternionBlock;
        this.eulerBlock = eulerBlock;
        this.spinStabilizedBlock = spinStabilizedBlock;
        this.spacecraftParameters = spacecraftParameters;
        this.maneuvers = new ArrayList<Maneuver>();
    }

    @Override
    public void validate(double version) {
        this.quaternionBlock.validate(version);
        if (this.eulerBlock != null) {
            this.eulerBlock.validate(version);
        }
        if (this.spinStabilizedBlock != null) {
            this.spinStabilizedBlock.validate(version);
        }
        if (this.spacecraftParameters != null) {
            this.spacecraftParameters.validate(version);
        }
        for (Maneuver maneuver : this.maneuvers) {
            maneuver.validate(version);
        }
    }

    public List<String> getComments() {
        return this.commentsBlock.getComments();
    }

    public ApmQuaternion getQuaternionBlock() {
        return this.quaternionBlock;
    }

    public Euler getEulerBlock() {
        return this.eulerBlock;
    }

    public SpinStabilized getSpinStabilizedBlock() {
        return this.spinStabilizedBlock;
    }

    public SpacecraftParameters getSpacecraftParametersBlock() {
        return this.spacecraftParameters;
    }

    public int getNbManeuvers() {
        return this.maneuvers.size();
    }

    public List<Maneuver> getManeuvers() {
        return Collections.unmodifiableList(this.maneuvers);
    }

    public Maneuver getManeuver(int index) {
        return this.maneuvers.get(index);
    }

    public void addManeuver(Maneuver maneuver) {
        this.maneuvers.add(maneuver);
    }

    public boolean hasManeuvers() {
        return !this.maneuvers.isEmpty();
    }
}

