/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm.aem;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hipparchus.exception.Localizable;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.definitions.TimeSystem;
import org.orekit.files.ccsds.ndm.NdmConstituent;
import org.orekit.files.ccsds.ndm.adm.aem.AemMetadata;
import org.orekit.files.ccsds.ndm.adm.aem.AemSatelliteEphemeris;
import org.orekit.files.ccsds.ndm.adm.aem.AemSegment;
import org.orekit.files.ccsds.section.Header;
import org.orekit.files.general.AttitudeEphemerisFile;
import org.orekit.utils.IERSConventions;
import org.orekit.utils.TimeStampedAngularCoordinates;

public class Aem
extends NdmConstituent<Header, AemSegment>
implements AttitudeEphemerisFile<TimeStampedAngularCoordinates, AemSegment> {
    public static final String ROOT = "aem";
    public static final String FORMAT_VERSION_KEY = "CCSDS_AEM_VERS";

    public Aem(Header header, List<AemSegment> segments, IERSConventions conventions, DataContext dataContext) {
        super(header, segments, conventions, dataContext);
    }

    @Override
    public Map<String, AemSatelliteEphemeris> getSatellites() {
        HashMap byId = new HashMap();
        for (AemSegment segment : this.getSegments()) {
            String id = ((AemMetadata)segment.getMetadata()).getObjectID();
            byId.putIfAbsent(id, new ArrayList());
            ((List)byId.get(id)).add(segment);
        }
        HashMap<String, AemSatelliteEphemeris> ret = new HashMap<String, AemSatelliteEphemeris>();
        for (Map.Entry entry : byId.entrySet()) {
            ret.put((String)entry.getKey(), new AemSatelliteEphemeris((String)entry.getKey(), (List)entry.getValue()));
        }
        return ret;
    }

    public void checkTimeSystems() {
        TimeSystem referenceTimeSystem = null;
        for (AemSegment segment : this.getSegments()) {
            TimeSystem timeSystem = ((AemMetadata)segment.getMetadata()).getTimeSystem();
            if (referenceTimeSystem == null) {
                referenceTimeSystem = timeSystem;
                continue;
            }
            if (referenceTimeSystem.equals((Object)timeSystem)) continue;
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_AEM_INCONSISTENT_TIME_SYSTEMS, referenceTimeSystem.name(), timeSystem.name());
        }
    }
}

