/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm.adm;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeBuilder;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.definitions.FrameFacade;
import org.orekit.files.ccsds.definitions.OrbitRelativeFrame;
import org.orekit.frames.Frame;
import org.orekit.utils.AngularCoordinates;
import org.orekit.utils.FieldAngularCoordinates;
import org.orekit.utils.FieldPVCoordinatesProvider;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedAngularCoordinates;
import org.orekit.utils.TimeStampedFieldAngularCoordinates;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class AttitudeEndoints
implements AttitudeBuilder {
    public static final String A2B = "A2B";
    public static final String B2A = "B2A";
    private FrameFacade frameA;
    private FrameFacade frameB;
    private Boolean a2b;

    private void checkNotNull(Object field, Enum<?> key) {
        if (field == null) {
            throw new OrekitException((Localizable)OrekitMessages.UNINITIALIZED_VALUE_FOR_KEY, key.name());
        }
    }

    public void checkExternalFrame(Enum<?> aKey, Enum<?> bKey) {
        this.checkNotNull(this.frameA, aKey);
        this.checkNotNull(this.frameB, bKey);
        if (this.frameA.asSpacecraftBodyFrame() != null && this.frameB.asSpacecraftBodyFrame() != null) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_INVALID_FRAME, this.frameB.getName());
        }
    }

    public void checkMandatoryEntriesExceptExternalFrame(Enum<?> aKey, Enum<?> bKey, Enum<?> dirKey) {
        if (this.frameA == null) {
            if (this.frameB == null || this.frameB.asSpacecraftBodyFrame() == null) {
                throw new OrekitException((Localizable)OrekitMessages.UNINITIALIZED_VALUE_FOR_KEY, aKey.name());
            }
        } else if (this.frameA.asSpacecraftBodyFrame() == null) {
            if (this.frameB == null) {
                throw new OrekitException((Localizable)OrekitMessages.UNINITIALIZED_VALUE_FOR_KEY, bKey.name());
            }
            if (this.frameB.asSpacecraftBodyFrame() == null) {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_INVALID_FRAME, this.frameB.getName());
            }
        }
        this.checkNotNull(this.a2b, dirKey);
    }

    public void setFrameA(FrameFacade frameA) {
        this.frameA = frameA;
    }

    public FrameFacade getFrameA() {
        return this.frameA;
    }

    public void setFrameB(FrameFacade frameB) {
        this.frameB = frameB;
    }

    public FrameFacade getFrameB() {
        return this.frameB;
    }

    public void setA2b(boolean a2b) {
        this.a2b = a2b;
    }

    public boolean isA2b() {
        return this.a2b == null ? true : this.a2b;
    }

    public FrameFacade getExternalFrame() {
        return this.frameA.asSpacecraftBodyFrame() == null ? this.frameA : this.frameB;
    }

    public FrameFacade getSpacecraftBodyFrame() {
        return this.frameA.asSpacecraftBodyFrame() == null ? this.frameB : this.frameA;
    }

    public boolean isExternal2SpacecraftBody() {
        return this.a2b ^ this.frameB.asSpacecraftBodyFrame() == null;
    }

    public boolean isCompatibleWith(AttitudeEndoints other) {
        return this.frameA.getName().equals(other.frameA.getName()) && this.frameB.getName().equals(other.frameB.getName()) && this.a2b.equals(other.a2b);
    }

    @Override
    public Attitude build(Frame frame, PVCoordinatesProvider pvProv, TimeStampedAngularCoordinates rawAttitude) {
        TimeStampedAngularCoordinates att = this.isExternal2SpacecraftBody() ? rawAttitude : rawAttitude.revert();
        FrameFacade external = this.getExternalFrame();
        OrbitRelativeFrame orf = external.asOrbitRelativeFrame();
        if (orf != null) {
            if (orf.getLofType() == null) {
                throw new OrekitException((Localizable)OrekitMessages.UNSUPPORTED_LOCAL_ORBITAL_FRAME, external.getName());
            }
            TimeStampedPVCoordinates pv = pvProv.getPVCoordinates(rawAttitude.getDate(), frame);
            AngularCoordinates frame2Lof = orf.isQuasiInertial() ? new AngularCoordinates(orf.getLofType().rotationFromInertial(pv), Vector3D.ZERO) : orf.getLofType().transformFromInertial(att.getDate(), pv).getAngular();
            return new Attitude(frame, att.addOffset(frame2Lof));
        }
        if (external.asFrame() == null) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_INVALID_FRAME, external.getName());
        }
        Attitude attitude = new Attitude(external.asFrame(), att);
        return frame == null ? attitude : attitude.withReferenceFrame(frame);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldAttitude<T> build(Frame frame, FieldPVCoordinatesProvider<T> pvProv, TimeStampedFieldAngularCoordinates<T> rawAttitude) {
        FieldAngularCoordinates att = this.isExternal2SpacecraftBody() ? rawAttitude : rawAttitude.revert();
        FrameFacade external = this.getExternalFrame();
        OrbitRelativeFrame orf = external.asOrbitRelativeFrame();
        if (orf != null) {
            if (orf.getLofType() == null) {
                throw new OrekitException((Localizable)OrekitMessages.UNSUPPORTED_LOCAL_ORBITAL_FRAME, external.getName());
            }
            TimeStampedFieldPVCoordinates<T> pv = pvProv.getPVCoordinates(rawAttitude.getDate(), frame);
            Field<T> field = rawAttitude.getDate().getField();
            FieldAngularCoordinates referenceToLof = orf.isQuasiInertial() ? new FieldAngularCoordinates(orf.getLofType().rotationFromInertial(field, pv), FieldVector3D.getZero(field)) : orf.getLofType().transformFromInertial(((TimeStampedFieldAngularCoordinates)att).getDate(), pv).getAngular();
            return new FieldAttitude(frame, ((TimeStampedFieldAngularCoordinates)att).addOffset(referenceToLof));
        }
        if (external.asFrame() == null) {
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_INVALID_FRAME, external.getName());
        }
        FieldAttitude<T> attitude = new FieldAttitude<T>(external.asFrame(), att);
        return frame == null ? attitude : attitude.withReferenceFrame(frame);
    }

    public String toString() {
        return this.frameA.getName() + (this.isA2b() ? " \u2192 " : " \u2190 ") + this.frameB.getName();
    }
}

