/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.ndm;

import org.hipparchus.exception.Localizable;
import org.hipparchus.util.Precision;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.utils.units.Unit;

public enum ParsedUnitsBehavior {
    IGNORE_PARSED{

        @Override
        public Unit select(Unit message, Unit standard) {
            return standard;
        }
    }
    ,
    CONVERT_COMPATIBLE{

        @Override
        public Unit select(Unit message, Unit standard) {
            if (message == Unit.NONE) {
                return standard;
            }
            if (message.sameDimension(standard)) {
                return message;
            }
            throw new OrekitException((Localizable)OrekitMessages.INCOMPATIBLE_UNITS, message.getName(), standard.getName());
        }
    }
    ,
    STRICT_COMPLIANCE{

        @Override
        public Unit select(Unit message, Unit standard) {
            if (message == Unit.NONE || Precision.equals((double)message.getScale(), (double)standard.getScale(), (int)1) && message.sameDimension(standard)) {
                return standard;
            }
            throw new OrekitException((Localizable)OrekitMessages.INCOMPATIBLE_UNITS, message.getName(), standard.getName());
        }
    };


    public abstract Unit select(Unit var1, Unit var2);
}

