/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds.definitions;

import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;

public class SpacecraftBodyFrame {
    private final BaseEquipment baseEquipment;
    private final String label;

    public SpacecraftBodyFrame(BaseEquipment baseEquipment, String label) {
        this.baseEquipment = baseEquipment;
        this.label = label;
    }

    public BaseEquipment getBaseEquipment() {
        return this.baseEquipment;
    }

    public String getLabel() {
        return this.label;
    }

    public String toString() {
        return this.getBaseEquipment().name() + "_" + this.getLabel();
    }

    public static SpacecraftBodyFrame parse(String descriptor) {
        int separatorIndex = descriptor.lastIndexOf(95);
        if (separatorIndex >= 0) {
            try {
                String equipmentName = descriptor.substring(0, separatorIndex);
                return new SpacecraftBodyFrame(BaseEquipment.valueOf(equipmentName), descriptor.substring(separatorIndex + 1));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        throw new OrekitException((Localizable)OrekitMessages.CCSDS_INVALID_FRAME, descriptor);
    }

    public static enum BaseEquipment {
        ACC,
        ACTUATOR,
        AST,
        CSS,
        DSS,
        ESA,
        GYRO,
        GYRO_FRAME,
        IMU_FRAME,
        INSTRUMENT,
        MTA,
        RW,
        SA,
        SC_BODY,
        SENSOR,
        STARTRACKER,
        TAM;

    }
}

